/*
 * Decompiled with CFR 0.152.
 */
package com.mentor.nucleus.fuse.core.types;

import com.mentor.nucleus.fuse.core.properties.NoSuchPropertyException;
import com.mentor.nucleus.fuse.core.properties.PropertyException;
import com.mentor.nucleus.fuse.core.properties.PropertyValueConstraintException;
import com.mentor.nucleus.fuse.core.types.AnnotatedElement;
import com.mentor.nucleus.fuse.core.types.Component;
import com.mentor.nucleus.fuse.core.types.Composite;
import com.mentor.nucleus.fuse.core.visitors.Visitor;
import com.mentor.nucleus.fuse.util.StringUtils;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;

public class Package
extends AnnotatedElement
implements Composite {
    LinkedList<Component> components = new LinkedList();
    LinkedList<Package> subPackages = new LinkedList();
    private File homeDirectory = null;

    public Package(String name) {
        this.setName(name);
        this.setEnabled(true);
    }

    public Package(String name, File homeDirectory) {
        this(name);
        this.homeDirectory = homeDirectory;
    }

    @Override
    public File getDirectory() {
        return this.homeDirectory;
    }

    public void setEnabled(boolean enabled) {
        this.setProperty("enable", enabled);
    }

    public boolean getEnabled() {
        boolean isEnabled = false;
        try {
            isEnabled = this.getBooleanProperty("enable");
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return isEnabled;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.preVisit(this);
        for (Package package_ : this.getPackages()) {
            package_.accept(visitor);
        }
        for (AnnotatedElement annotatedElement : this.getComponents()) {
            ((Component)annotatedElement).accept(visitor);
        }
        visitor.postVisit(this);
    }

    public void setName(String name) {
        this.setStringProperty("name", name);
    }

    @Override
    public String getName() {
        String name = null;
        try {
            name = this.getStringProperty("name");
        }
        catch (PropertyException pe) {
            pe.printStackTrace();
        }
        return name;
    }

    public void addPackage(Package subPackage) {
        this.subPackages.add(subPackage);
        subPackage.setParent(this);
    }

    public Package[] getPackages() {
        Package[] packageArray = new Package[this.subPackages.size()];
        this.subPackages.toArray(packageArray);
        return packageArray;
    }

    public void addComponent(Component component) {
        this.components.add(component);
        component.setParent(this);
    }

    public Component[] getComponents() {
        Component[] componentArray = new Component[this.components.size()];
        this.components.toArray(componentArray);
        return componentArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getProperty(String name) throws NoSuchPropertyException {
        Object o = null;
        String[] pieces = name.split("\\.");
        if (pieces.length == 1) {
            return super.getProperty(name);
        }
        if (pieces.length == 2) {
            if (this.findPackage(pieces[0]) != null) {
                return this.findPackage(pieces[0]).getProperty(pieces[1]);
            }
            if (this.findComponent(pieces[0]) == null) throw new NoSuchPropertyException("in the specifier '" + name + "' the name '" + pieces[0] + "' was used as package, component, or option group when no such" + " element exists.");
            return this.findComponent(pieces[0]).getProperty(pieces[1]);
        }
        String rest = StringUtils.join(Arrays.copyOfRange(pieces, 1, pieces.length), ".");
        if (this.findPackage(pieces[0]) != null) return this.findPackage(pieces[0]).getProperty(rest);
        if (this.findComponent(pieces[0]) == null) throw new NoSuchPropertyException("in the specifier '" + name + "' the name '" + pieces[0] + "' was used as package when no such package exist.");
        if (this.findComponent(pieces[0]).findOptionGroup(pieces[1]) == null) return o;
        return this.findComponent(pieces[0]).findOptionGroup(pieces[1]).getProperty(pieces[2]);
    }

    @Override
    public void setProperty(String name, Object data) {
        String[] pieces = name.split("\\.");
        if (pieces.length == 1) {
            super.setProperty(name, data);
        } else if (pieces.length == 2) {
            if (this.findPackage(pieces[0]) != null) {
                this.findPackage(pieces[0]).setProperty(pieces[1], data);
            } else if (this.findComponent(pieces[0]) != null) {
                Component c = this.findComponent(pieces[0]);
                if (data instanceof Integer) {
                    try {
                        c.setIntegerProperty(pieces[1], (Integer)data);
                    }
                    catch (PropertyValueConstraintException e) {
                        e.printStackTrace();
                    }
                } else {
                    c.setProperty(pieces[1], data);
                }
            }
        } else {
            String rest = StringUtils.join(Arrays.copyOfRange(pieces, 1, pieces.length), ".");
            if (this.findPackage(pieces[0]) == null) {
                if (this.findComponent(pieces[0]) != null && this.findComponent(pieces[0]).findOptionGroup(pieces[1]) != null) {
                    if (data instanceof Integer) {
                        try {
                            this.findComponent(pieces[0]).findOptionGroup(pieces[1]).setIntegerProperty(pieces[2], (Integer)data);
                        }
                        catch (PropertyValueConstraintException e) {
                            e.printStackTrace();
                        }
                    } else {
                        this.findComponent(pieces[0]).findOptionGroup(pieces[1]).setProperty(pieces[2], data);
                    }
                }
            } else {
                this.findPackage(pieces[0]).setProperty(rest, data);
            }
        }
    }

    public Component findComponent(String componentName) {
        for (Component c : this.components) {
            if (!c.getName().equals(componentName)) continue;
            return c;
        }
        return null;
    }

    public Package findPackage(String packageName) {
        for (Package p : this.subPackages) {
            if (!p.getName().equals(packageName)) continue;
            return p;
        }
        return null;
    }

    @Override
    public String getPackageName() {
        String name = null;
        try {
            name = this.getStringProperty("package");
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return name;
    }

    @Override
    public void setPackageName(String name) {
        this.setProperty("package", name);
    }

    @Override
    public String[] getPlatforms() {
        return new String[0];
    }

    @Override
    public boolean supportsPlatform(String platformName) {
        return true;
    }

    public void setMajorVersionNumber(int major) {
        this.setProperty("major", major);
    }

    public int getMajorVersionNumber() {
        int major = 0;
        try {
            major = this.getIntegerProperty("major");
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return major;
    }

    public void setMinorVersionNumber(int minor) {
        this.setProperty("minor", minor);
    }

    public int getMinorVersionNumber() {
        int minor = 0;
        try {
            minor = this.getIntegerProperty("minor");
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return minor;
    }

    public void setPatchVersionNumber(int patch) {
        this.setProperty("patch", patch);
    }

    public int getPatchVersionNumber() {
        int patch = 0;
        try {
            patch = this.getIntegerProperty("patch");
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return patch;
    }

    public Component findFQComponent(String name) {
        Package p;
        String[] pieces = name.split("\\.");
        Component c = null;
        if (pieces.length == 1) {
            c = this.findComponent(pieces[0]);
        } else if (pieces.length > 1 && (p = this.findPackage(pieces[0])) != null) {
            String rest = StringUtils.join(Arrays.copyOfRange(pieces, 1, pieces.length), ".");
            c = p.findFQComponent(rest);
        }
        return c;
    }

    public Package findFQPackage(String name) {
        String[] pieces = name.split("\\.");
        Package p = null;
        if (pieces.length == 1) {
            p = this.findPackage(pieces[0]);
        } else if (pieces.length > 1 && (p = this.findPackage(pieces[0])) != null) {
            String rest = StringUtils.join(Arrays.copyOfRange(pieces, 1, pieces.length), ".");
            p = p.findFQPackage(rest);
        }
        return p;
    }
}

