/*
 * Decompiled with CFR 0.152.
 */
package com.mentor.nucleus.fuse.core.types;

import com.mentor.nucleus.fuse.core.properties.PropertyException;
import com.mentor.nucleus.fuse.core.types.AnnotatedElement;
import com.mentor.nucleus.fuse.core.types.Option;
import com.mentor.nucleus.fuse.core.visitors.Visitor;
import java.util.LinkedList;

public class OptionGroup
extends AnnotatedElement {
    private LinkedList<Option> options = new LinkedList();

    public OptionGroup(String name) {
        this.setName(name);
        this.setEnabled(true);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.preVisit(this);
        for (Option o : this.getOptions()) {
            o.accept(visitor);
        }
        visitor.postVisit(this);
    }

    public void setEnabled(boolean enabled) {
        this.setProperty("enable", enabled);
    }

    public boolean getEnabled() {
        boolean isEnabled = false;
        try {
            isEnabled = this.getBooleanProperty("enable");
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return isEnabled;
    }

    public void setName(String name) {
        this.setProperty("name", name);
    }

    public String getName() {
        String name = null;
        try {
            name = this.getStringProperty("name");
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return name;
    }

    public void addOption(Option option) {
        this.options.add(option);
        option.setParent(this);
    }

    public Option findOption(String name) {
        for (Option opt : this.getOptions()) {
            if (!opt.getName().equals(name)) continue;
            return opt;
        }
        return null;
    }

    public Option[] getOptions() {
        return this.options.toArray(new Option[this.options.size()]);
    }
}

