/*
 * Decompiled with CFR 0.152.
 */
package com.mentor.nucleus.fuse.core.types;

import com.mentor.nucleus.fuse.core.types.AbstractFileSet;
import com.mentor.nucleus.fuse.core.visitors.Visitor;
import java.io.File;
import java.util.LinkedList;

public class FileSet
extends AbstractFileSet {
    private static String[] blackListedDirs = new String[]{".svn"};
    private static String[] blackListedFiles = new String[0];

    public FileSet() {
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.preVisit(this);
        visitor.postVisit(this);
    }

    public FileSet(File initialFile) {
        if (initialFile.isFile()) {
            this.add(initialFile);
        } else if (initialFile.isDirectory()) {
            this.addRecursive(initialFile);
        } else {
            this.add(initialFile);
        }
    }

    private boolean isBlackListed(File file) {
        String[] blackList;
        for (String name : blackList = file.isDirectory() ? blackListedDirs : blackListedFiles) {
            if (!file.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void addRecursive(File baseDirectory) {
        LinkedList<File> directoryQueue = new LinkedList<File>();
        directoryQueue.add(baseDirectory);
        while (directoryQueue.size() > 0) {
            File currentDirectory = (File)directoryQueue.removeFirst();
            for (File file : currentDirectory.listFiles()) {
                if (this.isBlackListed(file)) continue;
                if (file.isFile()) {
                    this.add(file);
                    continue;
                }
                directoryQueue.add(file);
            }
        }
    }
}

