/*
 * Decompiled with CFR 0.152.
 */
package com.mentor.nucleus.fuse.core.types;

import com.mentor.nucleus.fuse.core.properties.PropertyException;
import com.mentor.nucleus.fuse.core.types.AnnotatedElement;
import com.mentor.nucleus.fuse.core.types.Composite;
import com.mentor.nucleus.fuse.core.types.Executable;
import com.mentor.nucleus.fuse.core.types.Library;
import com.mentor.nucleus.fuse.core.types.Option;
import com.mentor.nucleus.fuse.core.types.OptionGroup;
import com.mentor.nucleus.fuse.core.types.Process;
import com.mentor.nucleus.fuse.core.types.Requirement;
import com.mentor.nucleus.fuse.core.visitors.Visitor;
import java.io.File;
import java.util.LinkedList;

public class Component
extends AnnotatedElement
implements Composite {
    private File homeDirectory = null;
    private LinkedList<Requirement> requirements = new LinkedList();
    private LinkedList<Library> libraries = new LinkedList();
    private LinkedList<Executable> executables = new LinkedList();
    private LinkedList<Process> processes = new LinkedList();
    private LinkedList<Option> options = new LinkedList();
    private LinkedList<OptionGroup> optionGroups = new LinkedList();
    private LinkedList<String> platformNames = new LinkedList();
    private String toolsetName = null;
    private String architecture = null;

    public Component(String name) {
        this.setName(name);
        this.setEnabled(true);
    }

    public Component(String name, File homeDirectory) {
        this.homeDirectory = homeDirectory;
        this.setName(name);
        this.setEnabled(true);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.preVisit(this);
        for (Requirement requirement : this.getRequirements()) {
            requirement.accept(visitor);
        }
        for (AnnotatedElement annotatedElement : this.getLibraries()) {
            ((Library)annotatedElement).accept(visitor);
        }
        for (AnnotatedElement annotatedElement : this.getExecutables()) {
            ((Executable)annotatedElement).accept(visitor);
        }
        for (AnnotatedElement annotatedElement : this.getProcesses()) {
            ((Process)annotatedElement).accept(visitor);
        }
        for (AnnotatedElement annotatedElement : this.getOptions()) {
            ((Option)annotatedElement).accept(visitor);
        }
        for (AnnotatedElement annotatedElement : this.getOptionGroups()) {
            ((OptionGroup)annotatedElement).accept(visitor);
        }
        visitor.postVisit(this);
    }

    @Override
    public File getDirectory() {
        return this.homeDirectory;
    }

    public void addOption(Option option) {
        this.options.add(option);
        option.setParent(this);
    }

    public Option findOption(String name) {
        for (Option opt : this.getOptions()) {
            if (!opt.getName().equals(name)) continue;
            return opt;
        }
        return null;
    }

    public Option[] getOptions() {
        return this.options.toArray(new Option[this.options.size()]);
    }

    public void addRequirement(Requirement req) {
        this.requirements.add(req);
        req.setParent(this);
    }

    public Requirement findRequirement(String required) {
        for (Requirement req : this.getRequirements()) {
            if (!req.getRequiredComponent().equals(required)) continue;
            return req;
        }
        return null;
    }

    public Requirement[] getRequirements() {
        return this.requirements.toArray(new Requirement[this.requirements.size()]);
    }

    public void addLibrary(Library lib) {
        this.libraries.add(lib);
        lib.setParent(this);
    }

    public Library findLibrary(String name) {
        for (Library lib : this.getLibraries()) {
            if (!lib.getName().equals(name)) continue;
            return lib;
        }
        return null;
    }

    public Library[] getLibraries() {
        return this.libraries.toArray(new Library[this.libraries.size()]);
    }

    public void addExecutable(Executable exe) {
        this.executables.add(exe);
        exe.setParent(this);
    }

    public Executable findExecutable(String name) {
        for (Executable exe : this.getExecutables()) {
            if (!exe.getName().equals(name)) continue;
            return exe;
        }
        return null;
    }

    public Executable[] getExecutables() {
        return this.executables.toArray(new Executable[this.executables.size()]);
    }

    public void addProcess(Process exe) {
        this.processes.add(exe);
        exe.setParent(this);
    }

    public Process findProcess(String name) {
        for (Process exe : this.getProcesses()) {
            if (!exe.getName().equals(name)) continue;
            return exe;
        }
        return null;
    }

    public Process[] getProcesses() {
        return this.processes.toArray(new Process[this.processes.size()]);
    }

    public void addOptionGroup(OptionGroup optionGroup) {
        this.optionGroups.add(optionGroup);
        optionGroup.setParent(this);
    }

    public OptionGroup findOptionGroup(String name) {
        for (OptionGroup optGroup : this.getOptionGroups()) {
            if (!optGroup.getName().equals(name)) continue;
            return optGroup;
        }
        return null;
    }

    public OptionGroup[] getOptionGroups() {
        return this.optionGroups.toArray(new OptionGroup[this.optionGroups.size()]);
    }

    public void setName(String name) {
        this.setProperty("name", name);
    }

    @Override
    public String getName() {
        String name = null;
        try {
            name = this.getStringProperty("name");
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return name;
    }

    @Override
    public void setPackageName(String name) {
        this.setProperty("package", name);
    }

    @Override
    public String getPackageName() {
        String name = null;
        try {
            name = this.getStringProperty("package");
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return name;
    }

    public void setMajorVersionNumber(int major) {
        this.setProperty("major", major);
    }

    public int getMajorVersionNumber() {
        int major = 0;
        try {
            major = this.getIntegerProperty("major");
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return major;
    }

    public void setMinorVersionNumber(int minor) {
        this.setProperty("minor", minor);
    }

    public int getMinorVersionNumber() {
        int minor = 0;
        try {
            minor = this.getIntegerProperty("minor");
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return minor;
    }

    public void setPatchVersionNumber(int patch) {
        this.setProperty("patch", patch);
    }

    public int getPatchVersionNumber() {
        int patch = 0;
        try {
            patch = this.getIntegerProperty("patch");
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return patch;
    }

    public void setEnabled(boolean enabled) {
        this.setProperty("enable", enabled);
    }

    public boolean getEnabled() {
        boolean isEnabled = false;
        try {
            isEnabled = this.getBooleanProperty("enable");
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return isEnabled;
    }

    public void addPlatform(String name) {
        this.platformNames.add(name);
    }

    @Override
    public boolean supportsPlatform(String name) {
        for (String platformName : this.getPlatforms()) {
            if (!platformName.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getPlatforms() {
        return this.platformNames.toArray(new String[this.platformNames.size()]);
    }

    public String getToolsetName() {
        return this.toolsetName;
    }

    public void setToolsetName(String name) {
        this.toolsetName = name;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String name) {
        this.architecture = name;
    }
}

