/*
 * Decompiled with CFR 0.152.
 */
package com.mentor.nucleus.fuse.core.types;

import com.mentor.nucleus.fuse.core.properties.NoSuchPropertyException;
import com.mentor.nucleus.fuse.core.properties.PropertyValueTypeException;
import com.mentor.nucleus.fuse.core.types.AnnotatedElement;
import com.mentor.nucleus.fuse.core.types.FileSet;
import java.io.File;

public abstract class CompiledArtifact
extends AnnotatedElement {
    private String name;
    private FileSet files;
    private FileSet includePaths;

    protected CompiledArtifact(String name) {
        this.name = name;
        this.files = new FileSet();
        this.includePaths = new FileSet();
    }

    public String getName() {
        return this.name;
    }

    public void addSourceFile(File sourceFile) {
        this.files.add(sourceFile);
    }

    public FileSet getSourceFiles() {
        return this.files;
    }

    public void addIncludePath(File path) {
        this.includePaths.add(path);
    }

    public FileSet getIncludePaths() {
        return this.includePaths;
    }

    public void addFlag(String toolName, String flagValue) {
        try {
            String flags = this.getStringProperty(toolName + ".flags");
            if (flags.length() == 0) {
                flags = flags + ",";
            }
            this.setStringProperty(toolName + ".flags", flagValue);
        }
        catch (NoSuchPropertyException e) {
            e.printStackTrace();
        }
        catch (PropertyValueTypeException e) {
            e.printStackTrace();
        }
    }
}

