/*
 * Decompiled with CFR 0.152.
 */
package com.mentor.nucleus.fuse.core.types;

import com.mentor.nucleus.fuse.core.properties.NoSuchPropertyException;
import com.mentor.nucleus.fuse.core.properties.PropertySet;
import com.mentor.nucleus.fuse.core.properties.PropertyValueConstraintException;
import com.mentor.nucleus.fuse.core.properties.PropertyValueTypeException;
import com.mentor.nucleus.fuse.core.types.SystemElement;
import com.mentor.nucleus.fuse.core.visitors.Visitor;
import com.mentor.nucleus.fuse.util.Range;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public abstract class AnnotatedElement
extends SystemElement
implements PropertySet {
    private AnnotatedElement parent;
    private Map<String, Object> propertyMap;

    protected AnnotatedElement() {
        this.parent = null;
        this.propertyMap = new Hashtable<String, Object>();
    }

    protected AnnotatedElement(AnnotatedElement parent) {
        this.parent = parent;
        this.propertyMap = new Hashtable<String, Object>();
    }

    @Override
    public abstract void accept(Visitor var1);

    public void setParent(AnnotatedElement element) {
        this.parent = element;
    }

    @Override
    public SystemElement getParent() {
        return this.parent;
    }

    @Override
    public void setProperty(String name, Object data) {
        this.propertyMap.put(name, data);
    }

    @Override
    public void setStringProperty(String name, String s) {
        this.propertyMap.put(name, s);
    }

    @Override
    public void setDoubleProperty(String name, double d) {
        this.propertyMap.put(name, d);
    }

    @Override
    public void setIntegerProperty(String name, int i) throws PropertyValueConstraintException {
        if (this.getBoundedRange(name) != null && !this.getBoundedRange(name).isIn(i)) {
            throw new PropertyValueConstraintException("attempted to set the integer property '" + name + "' outside of it bounds.");
        }
        this.propertyMap.put(name, i);
    }

    @Override
    public void setBooleanProperty(String name, boolean b) {
        this.propertyMap.put(name, b);
    }

    @Override
    public void setBoundedRange(String name, Range r) {
        this.propertyMap.put(name + ".range", r);
    }

    @Override
    public Range getBoundedRange(String name) {
        if (this.hasProperty(name)) {
            return (Range)this.propertyMap.get(name + ".range");
        }
        return null;
    }

    @Override
    public <T> void setListValues(String name, List<T> l) {
        this.propertyMap.put(name + ".values", l);
        for (int idx = 0; idx < l.size(); ++idx) {
            this.propertyMap.put(name + ".values." + idx, l.get(idx));
        }
    }

    public List<Integer> getListValues(String name) {
        ArrayList<Integer> constraintsList = null;
        Integer idx = 0;
        if (this.hasProperty(name) && this.hasProperty(name + ".values." + idx.toString())) {
            constraintsList = new ArrayList<Integer>();
            while (this.hasProperty(name) && this.hasProperty(name + ".values." + idx.toString())) {
                try {
                    constraintsList.add(new Integer((Integer)this.getTypedProperty(name + ".values." + idx.toString(), Integer.class)));
                }
                catch (NoSuchPropertyException e) {
                    e.printStackTrace();
                }
                catch (PropertyValueTypeException e) {
                    e.printStackTrace();
                }
                Integer n = idx;
                Integer n2 = idx = Integer.valueOf(idx + 1);
            }
        }
        return constraintsList;
    }

    @Override
    public Object getProperty(String name) throws NoSuchPropertyException {
        Object o = this.propertyMap.get(name);
        if (o == null) {
            if (this.parent != null) {
                o = this.parent.getProperty(name);
            } else {
                throw new NoSuchPropertyException("the property '" + name + "' does not exist.");
            }
        }
        return o;
    }

    @Override
    public String getStringProperty(String name) throws NoSuchPropertyException, PropertyValueTypeException {
        return (String)this.getTypedProperty(name, String.class);
    }

    @Override
    public double getDecimalProperty(String name) throws NoSuchPropertyException, PropertyValueTypeException {
        return (Double)this.getTypedProperty(name, Double.class);
    }

    @Override
    public int getIntegerProperty(String name) throws NoSuchPropertyException, PropertyValueTypeException {
        return (Integer)this.getTypedProperty(name, Integer.class);
    }

    @Override
    public boolean getBooleanProperty(String name) throws NoSuchPropertyException, PropertyValueTypeException {
        return (Boolean)this.getTypedProperty(name, Boolean.class);
    }

    @Override
    public boolean hasProperty(String name) {
        boolean propertyExist = false;
        try {
            this.getProperty(name);
            propertyExist = true;
        }
        catch (NoSuchPropertyException nspe) {
            propertyExist = false;
        }
        return propertyExist;
    }

    @Override
    public void removeProperty(String name) {
        this.propertyMap.remove(name);
    }

    private Object getTypedProperty(String name, Class<?> propertyValueClass) throws NoSuchPropertyException, PropertyValueTypeException {
        Object o = this.getProperty(name);
        if (propertyValueClass.isInstance(o)) {
            return this.getProperty(name);
        }
        throw new PropertyValueTypeException("the property '" + name + "' was requested as a'" + propertyValueClass.getName() + "', but is actually of type '" + o.getClass().getName() + "'");
    }
}

