/*
 * Decompiled with CFR 0.152.
 */
package com.mentor.nucleus.fuse.core.types;

import com.mentor.nucleus.fuse.core.properties.NoSuchPropertyException;
import com.mentor.nucleus.fuse.core.properties.PropertySet;
import com.mentor.nucleus.fuse.core.properties.PropertyValue;
import com.mentor.nucleus.fuse.core.properties.PropertyValueConstraintException;
import com.mentor.nucleus.fuse.core.properties.PropertyValueTypeException;
import com.mentor.nucleus.fuse.core.types.AnnotatedElement;
import com.mentor.nucleus.fuse.core.visitors.Visitor;
import com.mentor.nucleus.fuse.util.Range;
import java.util.List;

public abstract class AbstractProperty
extends AnnotatedElement
implements PropertyValue {
    private String name;
    private PropertySet properties;

    protected AbstractProperty(String name, PropertySet properties) {
        this.name = name;
        this.properties = properties;
    }

    @Override
    public abstract void accept(Visitor var1);

    public String getName() {
        return this.name;
    }

    @Override
    public void set(Object obj) {
        this.properties.setProperty(this.name, obj);
    }

    @Override
    public void setString(String s) {
        this.properties.setStringProperty(this.name, s);
    }

    @Override
    public void setDouble(double d) {
        this.properties.setDoubleProperty(this.name, d);
    }

    @Override
    public void setInteger(int i) throws PropertyValueConstraintException {
        this.properties.setIntegerProperty(this.name, i);
    }

    @Override
    public void setBoolean(boolean b) {
        this.properties.setBooleanProperty(this.name, b);
    }

    @Override
    public void setBoundedRange(Range r) {
        this.properties.setBoundedRange(this.name, r);
    }

    @Override
    public <T> void setListValues(List<T> l) {
        this.properties.setListValues(this.name, l);
    }

    public <T> List<T> getListValues() {
        return this.properties.getListValues(this.name);
    }

    @Override
    public Object get() {
        Object o = null;
        try {
            o = this.properties.getProperty(this.name);
        }
        catch (NoSuchPropertyException e) {
            e.printStackTrace();
        }
        return o;
    }

    @Override
    public String getString() throws PropertyValueTypeException {
        String value = null;
        try {
            value = this.properties.getStringProperty(this.name);
        }
        catch (NoSuchPropertyException e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public double getDouble() throws PropertyValueTypeException {
        double value = 0.0;
        try {
            value = this.properties.getDecimalProperty(this.name);
        }
        catch (NoSuchPropertyException e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public int getInteger() throws PropertyValueTypeException {
        int value = 0;
        try {
            value = this.properties.getIntegerProperty(this.name);
        }
        catch (NoSuchPropertyException e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public boolean getBoolean() throws PropertyValueTypeException {
        boolean value = false;
        try {
            value = this.properties.getBooleanProperty(this.name);
        }
        catch (NoSuchPropertyException e) {
            e.printStackTrace();
        }
        return value;
    }
}

