/*
 * Decompiled with CFR 0.152.
 */
package com.mentor.nucleus.fuse.core.runners;

import com.mentor.nucleus.fuse.core.runners.BadOptionValueException;
import com.mentor.nucleus.fuse.core.types.Package;
import com.mentor.nucleus.fuse.phases.BuiltinLoaderPhase;
import com.mentor.nucleus.fuse.phases.ComponentLoaderPhase;
import com.mentor.nucleus.fuse.phases.FuseContext;
import com.mentor.nucleus.fuse.phases.Phase;
import com.mentor.nucleus.fuse.phases.PropertyLoaderPhase;
import com.mentor.nucleus.fuse.phases.SerializeContextPhase;
import com.mentor.nucleus.fuse.util.ConfigFileLoadException;
import com.mentor.nucleus.fuse.util.RichProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.ScriptingContainer;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class CLIRunner {
    Options options;
    FuseContext context = null;

    public CLIRunner() {
        this.buildOptionParser();
        this.context = new FuseContext();
    }

    public void setFuseContext(FuseContext context) {
        this.context = context;
    }

    public FuseContext getFuseContext() {
        return this.context;
    }

    public static void main(String[] args) {
        CLIRunner runner = new CLIRunner();
        try {
            Phase phaseList = runner.parseOptions(args);
            if (phaseList != null && !phaseList.execute(runner.getFuseContext())) {
                System.exit(1);
            }
        }
        catch (ParseException e) {
            System.out.println("error: " + e.getMessage());
            System.exit(2);
        }
        catch (BadOptionValueException e) {
            System.out.println("error: " + e.getMessage());
            System.exit(2);
        }
        catch (ConfigFileLoadException e) {
            System.out.println(e.getFilename() + ": error: " + e.getMessage());
            System.exit(2);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private Phase parseOptions(String[] args) throws Exception {
        Phase phaseList = null;
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        if (args.length == 0) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("fuse", this.options);
        } else {
            line = parser.parse(this.options, args);
            if (line.hasOption("version")) {
                this.listVersion();
                return null;
            }
            if (line.hasOption("deserialize")) {
                FuseContext newContext = this.deserializeContext(line);
                newContext.setConfigurationRoot(newContext.getConfigurationRoot());
                this.setFuseContext(newContext);
                phaseList = this.addTransforms(newContext, line, phaseList);
                return phaseList;
            }
            this.setBuildRoot(this.context, line);
            this.setConfigurationRoot(this.context);
            this.loadBuiltins(this.context);
            if (line.hasOption("list-platforms")) {
                this.list("Available platforms:", this.context.getAvailablePlatforms());
                return null;
            }
            if (line.hasOption("list-toolsets")) {
                this.list("Available toolsets:", this.context.getAvailableToolsets());
                return null;
            }
            if (line.hasOption("list-transforms")) {
                this.list("Available transforms:", this.context.getAvailableTransforms());
                return null;
            }
            this.setToolset(this.context, line);
            this.setPlatform(this.context, line);
            this.setProperties(this.context, line);
            phaseList = this.addTransforms(this.context, line, phaseList);
            if (line.hasOption("serialize")) {
                String filename = new String(line.getOptionValue("serialize"));
                phaseList = new SerializeContextPhase(phaseList, filename);
            }
            phaseList = new PropertyLoaderPhase(phaseList);
            phaseList = new ComponentLoaderPhase(phaseList);
        }
        return phaseList;
    }

    private FuseContext deserializeContext(CommandLine line) {
        String filename = line.getOptionValue("deserialize");
        FuseContext localContext = null;
        try {
            FileInputStream fis = new FileInputStream(filename);
            ObjectInputStream ois = new ObjectInputStream(fis);
            localContext = (FuseContext)ois.readObject();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return localContext;
    }

    private void setProperties(FuseContext context, CommandLine line) throws Exception {
        String value = null;
        RichProperties newprops = new RichProperties();
        Properties cliprops = line.getOptionProperties("D");
        Enumeration<?> s = cliprops.propertyNames();
        while (s.hasMoreElements()) {
            String key = (String)s.nextElement();
            value = cliprops.getProperty(key);
            newprops.put(key, value);
        }
        if (line.hasOption("f")) {
            String configfileLine = new String(line.getOptionValue("f"));
            String[] configfileList = configfileLine.split(",");
            for (int i = 0; i < configfileList.length; ++i) {
                try {
                    String configFilename = configfileList[i];
                    File configfilePath = new File(context.getBuildRoot(), configFilename);
                    newprops.addIncludePath(configfilePath.getParentFile());
                    newprops.load(new FileInputStream(configFilename));
                    continue;
                }
                catch (ConfigFileLoadException e) {
                    if (e.getFilename() != null) {
                        throw e;
                    }
                    throw new ConfigFileLoadException(e.getMessage(), configfileList[i]);
                }
                catch (IOException e) {
                    throw new ConfigFileLoadException(e.getMessage(), configfileList[i]);
                }
            }
        }
        context.setCliProperties(newprops);
    }

    private void setPlatform(FuseContext context, CommandLine line) throws BadOptionValueException {
        String platformName = line.getOptionValue("platform");
        if (platformName == null) {
            throw new BadOptionValueException("you must specify a target platform. Please invoke 'fuse --list-platforms' to see what is available.");
        }
        this.verifyPlatform(context, platformName);
        context.setPlatformName(platformName);
    }

    private void verifyPlatform(FuseContext context, String platformName) throws BadOptionValueException {
        boolean platformFound = false;
        for (String availablePlatformName : context.getAvailablePlatforms()) {
            if (!availablePlatformName.equals(platformName)) continue;
            platformFound = true;
        }
        if (!platformFound) {
            throw new BadOptionValueException("the specified platform '" + platformName + "' does not exist.");
        }
        Package toolsetPlatformPackage = context.getUniverse().findPackage("toolsets").findPackage(platformName);
        if (toolsetPlatformPackage.findComponent(context.getToolsetName()) == null) {
            throw new BadOptionValueException("the specified toolset '" + context.getToolsetName() + "' is not supported for the specified platform '" + platformName + "'.");
        }
    }

    private void setToolset(FuseContext context, CommandLine line) throws BadOptionValueException {
        String toolsetName = line.getOptionValue("toolset");
        if (toolsetName == null) {
            throw new BadOptionValueException("you must specify a toolset. Please invoke 'fuse --list-toolsets' to see what is available.");
        }
        this.verify("toolset", toolsetName, context.getAvailableToolsets());
        context.setToolsetName(toolsetName);
    }

    private Phase addTransforms(FuseContext context, CommandLine line, Phase phaseList) throws BadOptionValueException {
        String[] transformOptions = line.getOptionValues("transform");
        if (transformOptions != null) {
            for (String transformName : transformOptions) {
                this.verify("transform", transformName, context.getAvailableTransforms());
                phaseList = this.prependTransform(context, transformName, phaseList);
            }
        } else {
            throw new BadOptionValueException("you must specify a transform. Please invoke 'fuse --list-transforms' to see what is available.");
        }
        return phaseList;
    }

    private Phase prependTransform(FuseContext context, String transformName, Phase phaseList) {
        ScriptingContainer container = context.getScriptingContainer();
        container.put("phase_list", (Object)phaseList);
        EmbedEvalUnit unit = container.parse(String.format("%1$2s.new(phase_list)", transformName), new int[0]);
        IRubyObject ret = unit.run();
        return (Phase)JavaEmbedUtils.rubyToJava((IRubyObject)ret);
    }

    private void list(String header, String[] items) {
        System.out.println(header);
        for (String item : items) {
            System.out.println("   " + item);
        }
    }

    private void listVersion() {
        System.out.println("Fuse 1.1");
        System.out.println("Copyright (C) 2010 Mentor Graphics Corporation.  All rights reserved");
        System.out.println();
    }

    private void verify(String header, String itemToCheck, String[] items) throws BadOptionValueException {
        for (String item : items) {
            if (!item.equals(itemToCheck)) continue;
            return;
        }
        throw new BadOptionValueException("the specified " + header + " '" + itemToCheck + "' does not exist.");
    }

    private void setConfigurationRoot(FuseContext context) {
        File fuseJar = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile().replace("%20", " "));
        context.setConfigurationRoot(fuseJar.getParentFile());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setBuildRoot(FuseContext context, CommandLine line) throws BadOptionValueException {
        if (line.getOptionValue("build-root") != null) {
            File buildRoot = new File(line.getOptionValue("build-root"));
            if (!buildRoot.exists()) throw new BadOptionValueException("the specified build root '" + buildRoot.getName() + "' does not exist.");
            context.setBuildRoot(buildRoot);
            return;
        } else {
            context.setBuildRoot(new File(System.getProperty("user.dir")));
        }
    }

    private void loadBuiltins(FuseContext context) {
        new BuiltinLoaderPhase().execute(context);
    }

    private void buildOptionParser() {
        this.options = new Options();
        OptionBuilder.withArgName((String)"transform name");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Specifies the transform to use.");
        OptionBuilder.withLongOpt((String)"transform");
        OptionBuilder.withValueSeparator((char)':');
        Option generator = OptionBuilder.create((String)"n");
        OptionBuilder.withArgName((String)"platform name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specifies the hardware platform to use.");
        OptionBuilder.withLongOpt((String)"platform");
        Option platform = OptionBuilder.create((String)"p");
        OptionBuilder.withArgName((String)"toolset name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specifies the toolset to use.");
        OptionBuilder.withLongOpt((String)"toolset");
        Option toolset = OptionBuilder.create((String)"t");
        OptionBuilder.withArgName((String)"build root");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"build-root");
        OptionBuilder.withDescription((String)"Specifies the root of the build tree.");
        Option buildRoot = OptionBuilder.create((String)"r");
        OptionBuilder.withArgName((String)"list-platforms");
        OptionBuilder.withLongOpt((String)"list-platforms");
        OptionBuilder.withDescription((String)"List the available target platforms.");
        Option listPlatforms = OptionBuilder.create((String)"lp");
        OptionBuilder.withArgName((String)"list-toolsets");
        OptionBuilder.withLongOpt((String)"list-toolsets");
        OptionBuilder.withDescription((String)"List the available toolsets.");
        Option listToolsets = OptionBuilder.create((String)"lt");
        OptionBuilder.withArgName((String)"list-transforms");
        OptionBuilder.withLongOpt((String)"list-transforms");
        OptionBuilder.withDescription((String)"List the available transforms.");
        Option listTransforms = OptionBuilder.create((String)"ln");
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"Set value for the given property.");
        Option property = OptionBuilder.create((String)"D");
        OptionBuilder.withArgName((String)"configuration file");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"File");
        OptionBuilder.withDescription((String)"Specifies the configuration settings file.");
        Option confFile = OptionBuilder.create((String)"f");
        OptionBuilder.withArgName((String)"version");
        OptionBuilder.withLongOpt((String)"version");
        OptionBuilder.withDescription((String)"List the Fuse version and exit.");
        Option version = OptionBuilder.create((String)"V");
        OptionBuilder.withArgName((String)"filename");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"serialize");
        OptionBuilder.withDescription((String)"Serialize to file.");
        Option serialize = OptionBuilder.create((String)"s");
        OptionBuilder.withArgName((String)"filename");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"deserialize");
        OptionBuilder.withDescription((String)"Deserialize from file.");
        Option deserialize = OptionBuilder.create((String)"x");
        this.options.addOption(generator);
        this.options.addOption(platform);
        this.options.addOption(toolset);
        this.options.addOption(buildRoot);
        this.options.addOption(listPlatforms);
        this.options.addOption(listToolsets);
        this.options.addOption(listTransforms);
        this.options.addOption(property);
        this.options.addOption(confFile);
        this.options.addOption(version);
        this.options.addOption(serialize);
        this.options.addOption(deserialize);
    }
}

