/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.jruby.Ruby;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;

public class JarredScript
implements Library {
    private final LoadServiceResource resource;

    public JarredScript(LoadServiceResource resource2) {
        this.resource = resource2;
    }

    public LoadServiceResource getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Ruby runtime2, boolean wrap2) {
        try {
            String rubyInit;
            URL jarFile = this.resource.getURL();
            runtime2.getJRubyClassLoader().addURL(jarFile);
            JarInputStream in = new JarInputStream(this.resource.getInputStream());
            Manifest mf = in.getManifest();
            if (mf != null && (rubyInit = mf.getMainAttributes().getValue("Ruby-Init")) != null) {
                JarEntry entry = in.getNextJarEntry();
                while (entry != null && !entry.getName().equals(rubyInit)) {
                    entry = in.getNextJarEntry();
                }
                if (entry != null) {
                    IRubyObject old = runtime2.getGlobalVariables().isDefined("$JAR_URL") ? runtime2.getGlobalVariables().get("$JAR_URL") : runtime2.getNil();
                    try {
                        runtime2.getGlobalVariables().set("$JAR_URL", runtime2.newString("jar:" + jarFile + "!/"));
                        runtime2.loadFile("init", in, wrap2);
                    }
                    finally {
                        runtime2.getGlobalVariables().set("$JAR_URL", old);
                    }
                }
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
    }
}

