/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.SplatNode;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.lexer.yacc.Token;
import org.jruby.parser.ParserSupport;

public class ParserSupport19
extends ParserSupport {
    public AssignableNode assignable(Token lhs, Node value2) {
        this.checkExpression(value2);
        switch (lhs.getType()) {
            case 286: {
                throw new SyntaxException(SyntaxException.PID.CANNOT_CHANGE_SELF, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't change the value of self", new Object[0]);
            }
            case 287: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to nil", "nil");
            }
            case 288: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to true", "true");
            }
            case 289: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to false", "false");
            }
            case 303: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to __FILE__", "__FILE__");
            }
            case 302: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to __LINE__", "__LINE__");
            }
            case 304: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to __ENCODING__", "__ENCODING__");
            }
            case 306: {
                return this.currentScope.assign(lhs.getPosition(), (String)lhs.getValue(), this.makeNullNil(value2));
            }
            case 310: {
                if (this.isInDef() || this.isInSingle()) {
                    throw new SyntaxException(SyntaxException.PID.DYNAMIC_CONSTANT_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "dynamic constant assignment", new Object[0]);
                }
                return new ConstDeclNode(lhs.getPosition(), (String)lhs.getValue(), null, value2);
            }
            case 309: {
                return new InstAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value2);
            }
            case 311: {
                return new ClassVarAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value2);
            }
            case 308: {
                return new GlobalAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value2);
            }
        }
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, lhs.getPosition(), this.lexer.getCurrentLine(), "identifier " + (String)lhs.getValue() + " is not valid to set", lhs.getValue());
    }

    protected void getterIdentifierError(ISourcePosition position, String identifier) {
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, position, "identifier " + identifier + " is not valid to get", identifier, new Object[0]);
    }

    public Node splat_array(Node node) {
        if (node instanceof SplatNode) {
            node = ((SplatNode)node).getValue();
        }
        if (node instanceof ArrayNode) {
            return node;
        }
        return null;
    }

    public Node arg_append(Node node1, Node node2) {
        if (node1 == null) {
            return new ArrayNode(node2.getPosition(), node2);
        }
        if (node1 instanceof ListNode) {
            return ((ListNode)node1).add(node2);
        }
        if (node1 instanceof BlockPassNode) {
            return this.arg_append(((BlockPassNode)node1).getBodyNode(), node2);
        }
        if (node1 instanceof ArgsPushNode) {
            ArgsPushNode pushNode = (ArgsPushNode)node1;
            Node body = pushNode.getSecondNode();
            return new ArgsCatNode(pushNode.getPosition(), pushNode.getFirstNode(), new ArrayNode(body.getPosition(), body).add(node2));
        }
        return new ArgsPushNode(this.position(node1, node2), node1, node2);
    }

    public boolean is_local_id(Token identifier) {
        String name2 = (String)identifier.getValue();
        return this.getCurrentScope().getLocalScope().isDefined(name2) < 0;
    }

    public ListNode list_append(Node list2, Node item) {
        if (list2 == null) {
            return new ArrayNode(item.getPosition(), item);
        }
        if (!(list2 instanceof ListNode)) {
            return new ArrayNode(list2.getPosition(), list2).add(item);
        }
        return ((ListNode)list2).add(item);
    }

    public Node new_bv(Token identifier) {
        if (!this.is_local_id(identifier)) {
            this.getterIdentifierError(identifier.getPosition(), (String)identifier.getValue());
        }
        this.shadowing_lvar(identifier);
        this.arg_var(identifier);
        return null;
    }

    public int arg_var(Token identifier) {
        return this.getCurrentScope().addVariableThisScope((String)identifier.getValue());
    }

    public void shadowing_lvar(Token identifier) {
        String name2 = (String)identifier.getValue();
        if (this.getCurrentScope().isDefined(name2) > 0 && this.warnings.isVerbose()) {
            this.warnings.warning(IRubyWarnings.ID.STATEMENT_NOT_REACHED, identifier.getPosition(), "shadowing outer local variable - " + name2, new Object[0]);
        }
    }

    public ListNode list_concat(Node first2, Node second) {
        if (first2 instanceof ListNode) {
            if (second instanceof ListNode) {
                return ((ListNode)first2).addAll((ListNode)second);
            }
            return ((ListNode)first2).addAll(second);
        }
        return new ArrayNode(first2.getPosition(), first2).add(second);
    }
}

