/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.exceptions;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Member;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyString;
import org.jruby.exceptions.JumpException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RaiseException
extends JumpException {
    public static final boolean DEBUG = false;
    private static final long serialVersionUID = -7612079169559973951L;
    private RubyException exception;
    private String providedMessage;

    public RaiseException(RubyException actException) {
        this(actException, false);
    }

    public RaiseException(Ruby runtime2, RubyClass excptnClass, String msg, boolean nativeException) {
        super(msg);
        if (msg == null) {
            msg = "No message available";
        }
        this.providedMessage = msg;
        this.setException((RubyException)RuntimeHelpers.invoke(runtime2.getCurrentContext(), (IRubyObject)excptnClass, "new", RubyString.newUnicodeString(excptnClass.getRuntime(), msg)), nativeException);
    }

    public RaiseException(RubyException exception2, boolean isNativeException) {
        this.setException(exception2, isNativeException);
    }

    public static RaiseException createNativeRaiseException(Ruby runtime2, Throwable cause2) {
        return RaiseException.createNativeRaiseException(runtime2, cause2, null);
    }

    public static RaiseException createNativeRaiseException(Ruby runtime2, Throwable cause2, Member target) {
        NativeException nativeException = new NativeException(runtime2, runtime2.getClass("NativeException"), cause2);
        if (!runtime2.getDebug().isTrue()) {
            nativeException.trimStackTrace(target);
        }
        return new RaiseException(cause2, nativeException);
    }

    private static String buildMessage(Throwable exception2) {
        StringBuilder sb = new StringBuilder();
        StringWriter stackTrace = new StringWriter();
        exception2.printStackTrace(new PrintWriter(stackTrace));
        sb.append("Native Exception: '").append(exception2.getClass()).append("'; ");
        sb.append("Message: ").append(exception2.getMessage()).append("; ");
        sb.append("StackTrace: ").append(stackTrace.getBuffer().toString());
        return sb.toString();
    }

    public RaiseException(Throwable cause2, NativeException nativeException) {
        super(RaiseException.buildMessage(cause2), cause2);
        this.providedMessage = RaiseException.buildMessage(cause2);
        this.setException(nativeException, true);
    }

    public String getMessage() {
        if (this.providedMessage == null) {
            this.providedMessage = this.exception.message(this.exception.getRuntime().getCurrentContext()).asJavaString();
        }
        return this.providedMessage;
    }

    public RubyException getException() {
        return this.exception;
    }

    protected void setException(RubyException newException, boolean nativeException) {
        Ruby runtime2 = newException.getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        if (!context.isWithinDefined()) {
            runtime2.getGlobalVariables().set("$!", newException);
        }
        if (runtime2.hasEventHooks()) {
            runtime2.callEventHooks(context, RubyEvent.RAISE, context.getFile(), context.getLine(), context.getFrameName(), context.getFrameKlazz());
        }
        this.exception = newException;
        if (runtime2.getStackTraces() > 5) {
            return;
        }
        runtime2.setStackTraces(runtime2.getStackTraces() + 1);
        ThreadContext.RubyStackTraceElement[] stackTrace = newException.getBacktraceFrames();
        if (stackTrace == null) {
            stackTrace = context.createBacktrace2(0, nativeException);
            newException.setBacktraceFrames(stackTrace);
        }
        if (newException instanceof NativeException) {
            this.setStackTrace(((NativeException)newException).getCause().getStackTrace());
        } else {
            this.setStackTrace(this.javaTraceFromRubyTrace(stackTrace));
        }
        runtime2.setStackTraces(runtime2.getStackTraces() - 1);
    }

    private StackTraceElement[] javaTraceFromRubyTrace(ThreadContext.RubyStackTraceElement[] trace) {
        StackTraceElement[] newTrace = new StackTraceElement[trace.length];
        for (int i = 0; i < newTrace.length; ++i) {
            newTrace[i] = trace[i].getElement();
        }
        return newTrace;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream ps) {
        StackTraceElement[] trace = this.getStackTrace();
        int externalIndex = 0;
        int i = trace.length - 1;
        while (i > 0 && trace[i].getClassName().indexOf("org.jruby.evaluator") < 0) {
            externalIndex = i--;
        }
        IRubyObject backtrace2 = this.exception.backtrace();
        Ruby runtime2 = backtrace2.getRuntime();
        if (runtime2.getNil() != backtrace2) {
            String firstLine = backtrace2.callMethod(runtime2.getCurrentContext(), "first").convertToString().toString();
            ps.print(firstLine + ": ");
        }
        IRubyObject message2 = this.exception.message;
        ps.println((message2.isNil() ? "" : message2.convertToString()) + " (" + this.exception.getMetaClass().toString() + ")");
        this.exception.printBacktrace(ps);
        ps.println("\t...internal jruby stack elided...");
        for (int i2 = externalIndex; i2 < trace.length; ++i2) {
            ps.println("\tfrom " + trace[i2].toString());
        }
    }

    public void printStackTrace(PrintWriter pw) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.printStackTrace(new PrintStream(baos));
        pw.print(baos.toString());
    }
}

