/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import org.jruby.embed.AttributeName;
import org.jruby.embed.ScriptingContainer;

public class JRubyBindings
implements Bindings {
    private ScriptingContainer container;
    public static final String BACKED_BINDING = "org.jruby.embed.jsr223.backed_bindings";

    JRubyBindings(ScriptingContainer container) {
        this.container = container;
        container.getVarMap().clear();
    }

    public int size() {
        Set set = this.entrySet();
        return set.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private void checkKey(Object key2) {
        if (key2 == null) {
            throw new NullPointerException("key is null");
        }
        if (!(key2 instanceof String)) {
            throw new ClassCastException("key is NOT String");
        }
        if (((String)key2).length() == 0) {
            throw new IllegalArgumentException("key is empty");
        }
    }

    public boolean containsKey(Object key2) {
        boolean isExist = this.container.getVarMap().containsKey(key2);
        if (!isExist) {
            isExist = this.container.getAttributeMap().containsKey(key2);
        }
        return isExist;
    }

    public boolean containsValue(Object value2) {
        boolean isExist = this.container.getVarMap().containsValue(value2);
        if (!isExist) {
            isExist = this.container.getAttributeMap().containsValue(value2);
        }
        return isExist;
    }

    public Object get(Object key2) {
        this.checkKey(key2);
        Object obj = this.container.get((String)key2);
        if (obj == null) {
            obj = this.container.getAttribute(key2);
        }
        return obj;
    }

    public Object put(String key2, Object value2) {
        this.checkKey(key2);
        Object oldValue = this.container.put(key2, value2);
        if (this.container.get(key2) == null) {
            oldValue = this.container.setAttribute(key2, value2);
            if (this.container.getAttributeMap().containsKey(BACKED_BINDING)) {
                Bindings b = (Bindings)this.container.getAttribute(BACKED_BINDING);
                b.put(key2, value2);
            }
        }
        return oldValue;
    }

    public Object remove(Object key2) {
        this.checkKey(key2);
        Object removedObj = null;
        if (this.container.getVarMap().containsKey(key2)) {
            removedObj = this.container.getVarMap().remove(key2);
        } else if (this.container.getAttributeMap().containsKey(key2)) {
            removedObj = this.container.getAttributeMap().remove(key2);
            if (this.container.getAttributeMap().containsKey(BACKED_BINDING)) {
                Bindings b = (Bindings)this.container.getAttribute(BACKED_BINDING);
                b.remove(key2);
            }
        }
        return removedObj;
    }

    public void putAll(Map t) {
        if (t == null) {
            throw new NullPointerException("map is null");
        }
        Set set = t.keySet();
        for (Object key2 : set) {
            Object value2 = t.get(key2);
            this.put((String)key2, value2);
        }
    }

    public void clear() {
        this.container.getVarMap().clear();
        Map map = this.container.getAttributeMap();
        if (map == null) {
            return;
        }
        ArrayList eliminateList = new ArrayList();
        for (Object key2 : map.keySet()) {
            if (!this.isEligibleKey(key2)) continue;
            eliminateList.add(key2);
        }
        for (Object key2 : eliminateList) {
            map.remove(key2);
        }
    }

    public Set keySet() {
        HashSet keys2 = new HashSet();
        Set entries2 = this.entrySet();
        if (entries2 != null) {
            for (Map.Entry entry : entries2) {
                keys2.add(entry.getKey());
            }
        }
        keys2.addAll(this.container.getVarMap().keySet());
        return keys2;
    }

    public Collection values() {
        HashSet values = new HashSet();
        Set entries2 = this.entrySet();
        if (entries2 != null) {
            for (Map.Entry entry : entries2) {
                values.add(entry.getValue());
            }
        }
        values.addAll(this.container.getVarMap().values());
        return values;
    }

    public Set entrySet() {
        HashSet<Map.Entry> set = new HashSet<Map.Entry>();
        Set s = this.container.getVarMap().entrySet();
        if (s != null) {
            for (Map.Entry entry : s) {
                set.add(entry);
            }
        }
        if ((s = this.container.getAttributeMap().entrySet()) != null) {
            for (Map.Entry entry : s) {
                if (!this.isEligibleKey(entry.getKey())) continue;
                set.add(entry);
            }
        }
        return set;
    }

    private boolean isEligibleKey(Object k) {
        Object[] keys2;
        for (Object key2 : keys2 = new Object[]{BACKED_BINDING, AttributeName.READER, AttributeName.WRITER, AttributeName.ERROR_WRITER}) {
            if (k != key2) continue;
            return false;
        }
        return true;
    }
}

