/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.dataflow.analyses;

import java.util.HashMap;
import org.jruby.compiler.ir.dataflow.DataFlowProblem;
import org.jruby.compiler.ir.dataflow.DataFlowVar;
import org.jruby.compiler.ir.dataflow.FlowGraphNode;
import org.jruby.compiler.ir.dataflow.analyses.LiveVariableNode;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.BasicBlock;

public class LiveVariablesProblem
extends DataFlowProblem {
    private static HashMap<Variable, DataFlowVar> _dfVarMap = new HashMap();

    public LiveVariablesProblem() {
        super(DataFlowProblem.DF_Direction.BACKWARD);
    }

    public String getProblemName() {
        return "Live Variables Analysis";
    }

    public DataFlowVar getDFVar(Variable v) {
        return _dfVarMap.get(v);
    }

    public void addDFVar(Variable v) {
        _dfVarMap.put(v, new DataFlowVar(this));
    }

    public FlowGraphNode buildFlowGraphNode(BasicBlock bb) {
        return new LiveVariableNode(this, bb);
    }

    public String getDataFlowVarsForOutput() {
        StringBuffer buf = new StringBuffer();
        for (Variable v : _dfVarMap.keySet()) {
            buf.append("DF Var ").append(LiveVariablesProblem._dfVarMap.get((Object)v)._id).append(" = ").append(v).append("\n");
        }
        return buf.toString();
    }

    public void markDeadInstructions() {
        for (FlowGraphNode n : this._fgNodes) {
            ((LiveVariableNode)n).markDeadInstructions();
        }
    }
}

