/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.provider.Invoker;
import com.kenai.jaffl.provider.jffi.DefaultInvokerFactory;
import com.kenai.jaffl.provider.jffi.FastIntInvokerFactory;
import com.kenai.jaffl.provider.jffi.InvokerFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Library
extends com.kenai.jaffl.provider.Library {
    private final String[] libraryNames;
    private volatile List<com.kenai.jffi.Library> nativeLibraries = Collections.EMPTY_LIST;

    Library(String name2) {
        this.libraryNames = new String[]{name2};
    }

    Library(String ... names2) {
        this.libraryNames = (String[])names2.clone();
    }

    @Override
    public Invoker getInvoker(Method method2, Map<LibraryOption, ?> options2) {
        InvokerFactory factory = FastIntInvokerFactory.getInstance().isMethodSupported(method2) ? FastIntInvokerFactory.getInstance() : DefaultInvokerFactory.getInstance();
        return factory.createInvoker(method2, this, options2);
    }

    @Override
    public Object libraryLock() {
        return this;
    }

    long getSymbolAddress(String name2) {
        for (com.kenai.jffi.Library l : this.getNativeLibraries()) {
            long address2 = l.getSymbolAddress(name2);
            if (address2 == 0L) continue;
            return address2;
        }
        return 0L;
    }

    long findSymbolAddress(String name2) {
        long address2 = this.getSymbolAddress(name2);
        if (address2 == 0L) {
            throw new UnsatisfiedLinkError(name2 + " not found");
        }
        return address2;
    }

    private synchronized List<com.kenai.jffi.Library> getNativeLibraries() {
        if (!this.nativeLibraries.isEmpty()) {
            return this.nativeLibraries;
        }
        this.nativeLibraries = this.loadNativeLibraries();
        return this.nativeLibraries;
    }

    private synchronized List<com.kenai.jffi.Library> loadNativeLibraries() {
        ArrayList<com.kenai.jffi.Library> libs = new ArrayList<com.kenai.jffi.Library>();
        ArrayList errors = new ArrayList(0);
        for (String libraryName : this.libraryNames) {
            String path2;
            com.kenai.jffi.Library lib = com.kenai.jffi.Library.getCachedInstance(libraryName, 1);
            if (lib == null && libraryName != null && (path2 = Library.locateLibrary(libraryName)) != null && !libraryName.equals(path2)) {
                lib = com.kenai.jffi.Library.getCachedInstance(path2, 1);
            }
            if (lib == null) {
                throw new UnsatisfiedLinkError(com.kenai.jffi.Library.getLastError());
            }
            libs.add(lib);
        }
        return Collections.unmodifiableList(libs);
    }
}

