/*=============================================================================
 *     Copyright Texas Instruments 2002. All Rights Reserved.
 */


/**
 * Container for THIF control related utilities and functions.
 */
public var thif = new (function() {
  
  function logError(msg)
  {
    pkg.output.logError("thif control",msg);
  }
  
  /**
   * Disable all event handlers in the specified THIF build.
   *   
   * @param nodeId      the node-id to send the command to
   */
  public function disableAllEventHandlers(nodeId)
  {
    var c = services["esf connection mgr"].getConnection(nodeId);
    if( (c != null) && (c instanceof ti.chimera.esf.sut.EventHandlerControl) )
      c.sendDisableAllEventHandlers();
    else
      logError("bad nodeId: " + nodeId);
  }
  
  
  /**
   * Enable all event handlers in the specified THIF build.
   *   
   * @param nodeId      the node-id to send the command to
   */
  public function enableAllEventHandlers( nodeId )
  {
    var c = services["esf connection mgr"].getConnection(nodeId);
    if( (c != null) && (c instanceof ti.chimera.esf.sut.EventHandlerControl) )
      c.sendEnableAllEventHandlers();
    else
      logError("bad nodeId: " + nodeId);
  }
  
  
  /**
   * Disable the specified event handlers in the specified THIF build.
   *   
   * @param nodeId      the node-id to send the command to
   * @param ehId        the event handler id
   */
  public function disableEventHandler( nodeId, ehId )
  {
    var c = services["esf connection mgr"].getConnection(nodeId);
    if( (c != null) && (c instanceof ti.chimera.esf.sut.EventHandlerControl) )
      c.sendDisableEventHandler(ehId);
    else
      logError("bad nodeId: " + nodeId);
  }
  
  
  /**
   * Enable the specified event handlers in the specified THIF build.
   *   
   * @param nodeId       the node-id to send the command to
   * @param ehId         the event handler id
   */
  public function enableEventHandler( nodeId, ehId )
  {
    var c = services["esf connection mgr"].getConnection(nodeId);
    if( (c != null) && (c instanceof ti.chimera.esf.sut.EventHandlerControl) )
      c.sendEnableEventHandler(ehId);
    else
      logError("bad nodeId: " + nodeId);
  }
  
  
  /**
   * Cause the scheduler to start in the THIF build.  Before this is called,
   * no tasks in the specified THIF build will run.
   *   
   * @param nodeId       the node-id to send the command to
   */
  public function start( nodeId )
  {
    var c = services["esf connection mgr"].getConnection(nodeId);
    if( (c != null) && (c instanceof ti.chimera.esf.sut.EventHandlerControl) )
      c.sendStart();
    else
      logError("bad nodeId: " + nodeId);
  }
  
  
})();



/*
 *   Local Variables:
 *   tab-width: 2
 *   indent-tabs-mode: nil
 *   mode: java
 *   c-indentation-style: java
 *   c-basic-offset: 2
 *   eval: (c-set-offset 'statement-cont '0)
 *   eval: (c-set-offset 'substatement-open '0)
 *   eval: (c-set-offset 'case-label '+)
 *   eval: (c-set-offset 'inclass '+)
 *   eval: (c-set-offset 'inline-open '0)
 *   End:
 */
