/*=============================================================================
 *     Copyright Texas Instruments 2001. All Rights Reserved.
 */


/**
 * Base class for wrapper/non-wrapper objects.  This provides some handy
 * utility methods.
 * 
 * @param nodeId       the id of the hostbuild to send/recv to/from
 */
public function Subsystem( nodeId, name )
{
  /**
   * Log and display an informational message
   * 
   * @param msg          the error message to log
   */
  function info(msg)
  {
    output.logInfoMsg( name, msg );
  }
  
  /**
   * Log and display a warning message.
   * 
   * @param msg          the error message to log
   */
  function warning(msg)
  {
    output.logWarning( name, msg );
  }
  
  /**
   * Log and display an error message.
   * 
   * @param msg          the error message to log
   */
  function error(msg)
  {
    output.logError( name, msg );
  }
  
  /**
   * Send a primitive.
   * 
   * @param prim         the primitive to send
   */
  function sendPrim(prim)
  {
    prim.putDestinationNodeId(nodeId);
    pkg.util.sendPrim(prim);
  }
}



/*
 *   Local Variables:
 *   tab-width: 2
 *   indent-tabs-mode: nil
 *   mode: java
 *   c-indentation-style: java
 *   c-basic-offset: 2
 *   eval: (c-set-offset 'statement-cont '0)
 *   eval: (c-set-offset 'substatement-open '0)
 *   eval: (c-set-offset 'case-label '+)
 *   eval: (c-set-offset 'inclass '+)
 *   eval: (c-set-offset 'inline-open '0)
 *   End:
 */
