/*================================================================
   Description:

   intArrayToString(array) converts array to a string for display
 */

function intArrayToString(intArray)
{
    var result;
    result = "" + intArray[0];
    for (var i = 1; i < intArray.length(); i++)
    {
        result += ", " + intArray[i];
    }
    return result;
}

/*================================================================
   Description:

   displayBin(bin) takes as input an array of binary numbers and
   converts it to a string
 */

function displayBin(bin)
{
    var result = "";
    for (var i = bin.length()-1; i >= 0; --i)
    {
        result += bin[i];
    }
    return result;
}

/*================================================================
   Description:

   returns inverse of a binary number, ie, puts a 1 where there
   was a 0 and a 0 where there was a 1
 */

function inverse(bin)
{
    var result = new Array();
    for (var i = 0; i < bin.length(); i++)
    {
        if (bin[i] == 1) { result[i] = 0; }
        else             { result[i] = 1; }
    }
    return result;
}

/*================================================================
   Description:

   Absolute value.
 */

function abs(number)
{
    if (number >= 0) { return number; }
    else { return (-1 * number); }
}

/*================================================================
   Description:

   Binary and.  Takes as input two decimal numbers.
 */

function and(a, b)
{
    var binA = decToBin(a);
    var binB = decToBin(b);
    var result = new Array();
    for (var i = 0; i < binA.length(); ++i)
    {
        if (binA[i] == 1 && binB[i] == 1) { result[i] = 1; }
        else                              { result[i] = 0; }
    }
    result = binToDec(result);
    return result;
}

/*================================================================
   Description:

   binToDec(bin) takes as input a binary array such as one that
   binToDec(dec) (see below) produces and returns the equivalent
   decimal number.  Note that this only works for unsigned binary
   numbers.
 */

function binToDec(bin)
{
    var dec = 0;
    for (var i = bin.length()-1; i >= 0; --i) { dec = (2 * dec) + bin[i]; }
    return dec;
}

/*================================================================
   Description:

   decToBin(dec) does the inverse of binToDec(bin).  It takes as
   input a decimal number and returns an array of 0s and 1s that
   is equivalent to the binary representation.  The 0th element in
   the array is the least significant (left-most digit in the
   binary number.

   example:
   input  - 423
   binary - 110100111
   output - [1, 1, 1, 0, 0, 1, 0, 1, 1]
 */

function decToBin(dec)
{
    var bin = new Array();
    for (var i = 0; i < 32; ++i) { bin[i] = 0; }
    for (var i = 0; dec != 0; ++i)
    {
        bin[i] = dec % 2;
        dec /= 2;
    }
    return bin;
}

/*================================================================
   Description:

   decToHex(dec) takes as input a decimal number and returns a
   string that is equivalent to the hex representation of the
   input

   example:
   input  - 423
   output - "0x1A7"
 */

function decToHex(dec)
{
    var hex = "";
    for (var i = 0; i < 8; ++i)
    {
        hex = numberToChar(dec % 16) + hex;
        dec /= 16;
    }
    hex = "0x" + hex;
    return hex;
}

/*================================================================
   Description:

   numberToChar(dec) takes as input a number between 0 and 16 and
   outputs the equivalent hex value as a string
 */

function numberToChar(dec)
{
    if      (dec >= 0 && dec <= 9) { return ("" + dec); }
    else if (dec == 10)            { return "a"; }
    else if (dec == 11)            { return "b"; }
    else if (dec == 12)            { return "c"; }
    else if (dec == 13)            { return "d"; }
    else if (dec == 14)            { return "e"; }
    else if (dec == 15)            { return "f"; }
    else                           { return "ERROR"; }
}

/*================================================================
   Description:

   power(a, b) raises (integer) a to the (positive integer) b power.
 */

function power(a, b)
{
    var result = 1;
    for (var i = 0; i < b; i++)
    {
        result *= a;
    }
    return result;
}

