/*=============================================================================
 *     Copyright Texas Instruments 2002. All Rights Reserved.
 */


/*=============================================================================
    Description:
        This test verifies that the basic java data types involved in
        test cases and the objectscript that verifies them is correct.


    Returns:
    n/a

 */
public function TestJavaRepresentations( logWriter, warningWriter, errorWriter )
  extends pkg.tf.TestCase( "esf.obstest.TestJavaRepresentations", logWriter, warningWriter, errorWriter)
{
  //====================================================================================
  /**
   * Overrides the runTest() method in TestCase base class.
   *
   */
  public function runTest()
  {
    var prim;

    const var prefix = "TestBasic-";
    logInfo( "Beginning test of simple decode" );
    const var p = pkg.esf.obstest.util;

    // This function should act exactly like the one in the
    //   target for this struct.
    function createSampleStruct( value )
    {
      return new ti.th.prim.Obstest_SampleStructuredObservation(
          value
        , value
        , value
        , [value, value, value, value, value, value, value, value, value]
        , value
        , value
        );
    }

    // Test all varieties of
    pkg.util.forEach(
        //PADDING RULES
        [  "ti.chimera.esf.ARMPaddingRule"
        ,  "ti.chimera.esf.DefaultPaddingRule"
        ,  "ti.chimera.esf.SPARCPaddingRule"
        ]
      , // PRIMITIVE STREAMS
        [  "ti.chimera.esf.BigEndianPrimitiveStream"
        ,  "ti.chimera.esf.LittleEndianPrimitiveStream"
        ]
      ,  // VALUES
        [ 1, 100, 1000, 100000, 0x5EADBEEF, 0x5EDABABE ]
      , function( ruleName, primStreamName, value )
        {
          logInfo( "Testing with rule:" + ruleName + " ps:" + primStreamName + " value:" + value );
          const var pr;
          const var ps;
          eval( "pr = new " + ruleName + "();" );
          eval( "ps = new " + primStreamName + "( pr );" );

          const var sampleStruct = createSampleStruct( value );

          logInfo( "Stringified the structure: " + sampleStruct.stringify() );

          sampleStruct.serialize( ps );

          const var decodePs = ps.clone();

          const var decodeStruct = new ti.th.prim.Obstest_SampleStructuredObservation( decodePs );

          logInfo( "Stringified the DECODED structure: " + sampleStruct.stringify() );

          var xpList = new pkg.util.expect.ExpectationList();
          var resList = new java.util.LinkedList();

          xpList.add(
            /**/ [ "result.getLeadingUint32()", " == " + (sampleStruct.getLeadingUint32() & 0xFFFFFFFF) ]
            ,    [ "result.getAUint16()",       " == " + (sampleStruct.getAUint16()       & 0xFFFF)     ]
            ,    [ "result.getAUint8()",        " == " + (sampleStruct.getAUint8()        & 0xFF)       ]
            ,    [ "result.getSecondUint32()",  " == " + (sampleStruct.getSecondUint32()  & 0xFFFFFFFF) ]
            ,    [ "result.getTrailingUint8()", " == " + (sampleStruct.getTrailingUint8() & 0xFF)       ]
            );
          resList.add( decodeStruct );

          for (var i = 0; i < sampleStruct.getAUint8Array().length(); ++i )
          {
            xpList.add(
              /**/ [ "result.getAUint8Array()[" + i +"]", " == " + (sampleStruct.getAUint8Array()[ i ] & 0xFF) ]
              );
            resList.add( decodeStruct );
          }

          xpList.evaluate( resList, logError, logInfo );

          logInfo( "Finished basic check: now checking for decode correctness..." );
          pkg.esf.obstest.util.verifyObservationValueStructured( value, ps.clone() );
          logInfo( "Finished decode correctness check." );


        }
      );

  }

}





