/*=============================================================================
 *     Copyright Texas Instruments 2002. All Rights Reserved.
 */


/*=============================================================================
    Description:

    This test case verifies that pull mode works correctly for the
    observable event handler.

 */
public function IntegTestVerifyPullConfigurationFunction( logWriter, warningWriter, errorWriter )
  extends pkg.esf.obstest.util.IntegTestObstest(
      "esf.obstest.IntegTestVerifyPullConfigurationFunction"
    , logWriter
    , warningWriter
    , errorWriter
    )
{
  //====================================================================================
  /**
    @param rctx         the routing context to use for traffic
    @param scriptEhId   the event handler id to spoof for this test case
    @param agePkg       a package to use for age event handler convenience ops
    @param obsPkg       a package to use for obs event handler convenience ops
    @param obstestPkg   a package to use for obstest event handler convenience
    @param evList       a list into which events from the aggregate stream are
                        placed.
   */
  function runIntegTestObstest(
        rctx
      , scriptEhId
      , agePkg
      , obsPkg
      , obstestPkg
      , evList
    )
  {

    // set pull timer to zero
    obsPkg.setPull( rctx, scriptEhId, 0 );

    // The mapping between logical test observables
    //   and actual observable ids
    const var testIds = obstestPkg.getTestObservableIds( rctx, scriptEhId );

    // The evaluation functions that verify whether a particluar
    //   value was successfully set for a logical observable
    public const var testVerifyFuncs = obstestPkg.testObservableVerifyFuncs;

    var __seed = 1234;
    function next() {return (__seed += 123443) & 0xffffffff;}

    // Each row contains the set of logical test
    //  observable that are to be used in a single
    //  pull test
    const var TEST_SPECIFICATION =
      [
         [ [ 7  ],             [ next(), next(), next(), next(), next(), next() ], 1 ]
      ,  [ [ 6  ],             [ next(), next(), next(), next(), next(), next() ], 1 ]
      ,  [ [ 0, 2, 3, 4, 5 ],  [ next(), next(), next(), next(), next(), next() ], 2 ]
      ,  [ [ 0  ],             [ next(), next(), next(), next(), next(), next() ], 3 ]
      ,  [ [ 1  ],             [ next(), next(), next(), next(), next(), next() ], 8 ]
      ,  [ [ 0, 3, 2  ],       [ next(), next(), next(), next(), next(), next() ], 5 ]
      ,  [ [ 0, 1, 2, 3 ],     [ next(), next(), next(), next(), next(), next() ], 20 ]
      ,  [ [ 4, 1, 2, 3 ],     [ next(), next(), next(), next(), next(), next() ], 10 ]
      ,  [ [ 1, 4  ],          [ next(), next(), next(), next(), next(), next() ], 5 ]
      ,  [ [ 1, 4, 6 ],        [ next(), next(), next(), next(), next(), next() ], 5 ]
      ];

    pkg.util.forEach( TEST_SPECIFICATION, function( thisSpec )
    {
      const var CURRENT_TEST_PULL       = thisSpec[ 0 ];
      const var CURRENT_TEST_VALUES     = thisSpec[ 1 ];
      const var CURRENT_TEST_ITERATIONS = thisSpec[ 2 ];

      logInfo( "_____________Executing step____" + CURRENT_TEST_PULL + "_________" );

      // Clear the event list
      if (evList.size() > 0)
      {
        logWarning( "There are " + evList.size() + " elements in the list and it should be empty" );
        evList.clear();
      }

      // Expectation comparator
      const var xpList = new pkg.util.expect.ExpectationList();

      for (var j = CURRENT_TEST_PULL.length()-1; j >= 0 ; --j)
      {
        const var thisSetValue = CURRENT_TEST_VALUES[ j ];
        const var thisLogicalTestObs = CURRENT_TEST_PULL[ j ];
        const var thisTrueObsId = testIds[ thisLogicalTestObs ];

        // Set specific values
        obstestPkg.set( rctx, scriptEhId, thisLogicalTestObs, thisSetValue );

        // enable for pull
        obsPkg.configureStreamExpecting(
            rctx
          , scriptEhId
          , thisTrueObsId
          , 0
          , 1
          , 0
          , 1
        );


        // Expected result: an observation
        xpList.add(
          /**/ [ "result.getId()", "==" + thisTrueObsId, " VERIFYING INITIAL OBSERVATION " ]
          ,    [ "result instanceof ti.observable.ObservationPartialDecodeEntry" ]
          ,    [ "pkg.esf.obstest.util.testObservableVerifyFuncs[ " + thisLogicalTestObs + " ]( " + thisSetValue + ", result.getUndecoded() )" ]
          );

      }

      // Each set operation
      for (var setCounter = 0; setCounter < CURRENT_TEST_ITERATIONS; ++setCounter)
      {

        // each observable being pulled: set a value, create an expectation
        for (var logicalObs = 0; logicalObs < CURRENT_TEST_PULL.length(); ++logicalObs)
        {
          const var thisSetValue = CURRENT_TEST_VALUES[ (logicalObs + 1 + setCounter) % CURRENT_TEST_VALUES.length() ];
          const var thisLogicalTestObs = CURRENT_TEST_PULL[ logicalObs ];
          const var thisTrueObsId = testIds[ thisLogicalTestObs ];
          const var thisEvalFunc = testVerifyFuncs[ thisLogicalTestObs ];

          // Set specific values
          obstestPkg.set( rctx, scriptEhId, thisLogicalTestObs, thisSetValue );

          // Expected result: an observation
          xpList.add(
            /**/ [ "result.getId()", "==" + thisTrueObsId ]
            ,    [ "result instanceof ti.observable.ObservationPartialDecodeEntry" ]
            ,    [ "pkg.esf.obstest.util.testObservableVerifyFuncs[ " + thisLogicalTestObs + " ]( " + thisSetValue + ", result.getUndecoded() )" ]
            );

        }

        // since auto buffer refills are disabled, we'll be explicit
        agePkg.triggerBufferService( rctx, scriptEhId );

        // trigger pull
        if (!obsPkg.triggerPull(
                    rctx
                  , scriptEhId
                )
            )
        {
          logError(" Pull Failed ");
          return;
        }

      }

      for (var j = CURRENT_TEST_PULL.length()-1; j >= 0 ; --j)
      {
        const var thisSetValue = CURRENT_TEST_VALUES[ j ];
        const var thisLogicalTestObs = CURRENT_TEST_PULL[ j ];
        const var thisTrueObsId = testIds[ thisLogicalTestObs ];

        // disable pull
        obsPkg.configureStreamExpecting(
            rctx
          , scriptEhId
          , thisTrueObsId
          , 0
          , 0
          , 0
          , 0
        );
      }

      // Force stuff through age
      agePkg.forceSendAll( rctx, scriptEhId );
      
      logWarning( "NOTE: a delay was inserted here to avoid a chimera race condition."
                  + " This is not guaranteed to prevent errors after this." );
      java.lang.Thread.currentThread().sleep( 5000 );
      logInfo( "Fakie delay complete." );
      
      // compare expectations
      xpList.evaluate( evList, logError, logInfo );
      evList.clear();

    });

  }

}







