/*=============================================================================
 *     Copyright Texas Instruments 2002. All Rights Reserved.
 */


/*=============================================================================
    Description:

    This specific integration test verifies whether the creation of an observable
    is automatically eventually detected by the obs event handler and is
    automatically exported by the age event handler.

    THIS TEST USES UP SYSTEM RESOURCES THAT ARE NOT RECLAIMABLE.  IT MAY
    FAIL TO BE EFFECTIVE IF YOU RERUN IT TOO MANY TIMES.

 */
public function IntegTestStandardCreateNotify( logWriter, warningWriter, errorWriter )
  extends pkg.esf.obstest.util.IntegTestObstest(
        "esf.obstest.IntegTestStandardCreateNotify"
      , logWriter
      , warningWriter
      , errorWriter
      )
{
  //==========================================================================
  /**
    @param rctx         the routing context to use for traffic
    @param scriptEhId   the event handler id to spoof for this test case
    @param agePkg       a package to use for age event handler convenience ops
    @param obsPkg       a package to use for obs event handler convenience ops
    @param obstestPkg   a package to use for obstest event handler convenience
    @param eventList    a list into which events from the aggregate stream are
                        placed.
   */
  function runIntegTestObstest(
        rctx
      , scriptEhId
      , agePkg
      , obsPkg
      , obstestPkg
      , eventList
    )
  {
    // Enable Age (by default it isn't)
    if (!agePkg.setConfiguration( rctx, scriptEhId, 20, 1024, 500 ) )
    {
      retval = false;
      pkg.output.logError( phase + " buf cfg fail." );
    }


    const var initialStatus = obsPkg.getStatusStruct( rctx, scriptEhId );
    const var obsMax = initialStatus.getObservableMax();
    const var obsCnt = initialStatus.getObservableMaxCurrent();

    logInfo( "Count of obs=" + obsCnt + " and max is " + obsMax );
    if (obsCnt >= obsMax)
    {
      logError( " count of observables ("
        + obsCnt
        + ") cannot be greater or equal to max observable ("
        + obsMax
        + ")"
        );
    }

    if (obsCnt+1 == obsMax)
    {
      logWarning( " Test inconclusive since count of observables ("
        + obsCnt
        + ") and system can only have ("
        + (obsMax-1)
        + ") instances.  Run this test right after startup"
        + " in order to verify function.  Note that this test "
        + " must, according to the system design, use up resources "
        + " that cannot be reclaimed- the system may not run well "
        + " after running this test!!!"
        );
      return;
    }

    if (eventList.size() > 0)
    {
      logError( " eventList should be empty but has size=" + eventList.size() );
      for (var k = 0; k < eventList.size(); ++k)
      {
        logWarning(" Unexpected Element " + k + " is " + eventList.get( k ).toString() );
      }
      eventList.clear();
    }

    var createCommand = new obstestPkg.OpList();

    createCommand.addCreate();
    createCommand.perform( rctx, scriptEhId );

    var periods = 1000;
    while (periods-- > 0)
    {
      java.lang.Thread.currentThread().sleep( 100 );
      if (eventList.size() > 0) break;
    }

    if ( eventList.size() == 0)
    {
      logError( "Creation of an observable on target did not result"
               + " in notification event in entry stream." );
      return;
    }

    if ( eventList.size() > 1)
    {
      logError( "Too many notification events in the entry stream: num "
                + " is " + eventList.size() );
      return;
    }

    const var entryStatus = eventList.get( 0 );
    if ( entryStatus == null )
    {
      logError( "An invalid entry was returned by the target." );
      return;
    }

    const var entryCnt = entryStatus.getMaximumCurrentObservable();
    if (entryCnt != 1 + obsCnt)
    {
      logError( "Expected that entry returned would be "
                + (1 + obsCnt) + " but instead saw " + entryCnt
                + " ( is it getting confused with maxtotal=" + entryStatus.getMaximumObservables() + "?)" );
    }

    const var finalStatus = obsPkg.getStatusStruct( rctx, scriptEhId );
    const var finalCnt = finalStatus.getObservableMaxCurrent();
    const var finalMax = finalStatus.getObservableMax();

    if ( finalCnt != entryCnt ) logError( "final cnt should equal entry cnt" );
    if ( finalMax != obsMax ) logError( "unexpected this is and most unfortunate" );

  }

}




