/*=============================================================================
 *     Copyright Texas Instruments 2002. All Rights Reserved.
 */


/*=============================================================================
    Description:

    This test makes sure that the observation rollover counter functions
    correctly.  We expect observations to roll over even if there
    is no space in the stream for them.

 */
public function IntegTestObservationRolloverDropouts( logWriter, warningWriter, errorWriter )
  extends pkg.esf.obstest.util.IntegTestObstest(
      "esf.obstest.IntegTestObservationRolloverDropouts"
    , logWriter
    , warningWriter
    , errorWriter
    )
{
  //====================================================================================
  /**
    @param rctx         the routing context to use for traffic
    @param scriptEhId   the event handler id to spoof for this test case
    @param agePkg       a package to use for age event handler convenience ops
    @param obsPkg       a package to use for obs event handler convenience ops
    @param obstestPkg   a package to use for obstest event handler convenience
    @param evList       a list into which events from the aggregate stream are
                        placed.
   */
  function runIntegTestObstest(
        rctx
      , scriptEhId
      , agePkg
      , obsPkg
      , obstestPkg
      , evList
    )
  {

    const var BUFFER_SIZE  = 1024;
    const var BUFFER_COUNT = 10;

    // Each array entry has an arrayelements.
    //  The first element is the logical test observable number.
    //  The second element is the number of observations to
    //    trigger when buffers are available.
    //  The third element is the number of observations to trigger
    //    when buffers are not available.
    //  The fourth element is the number of observations to
    //    trigger once buffers have become available again.
    const var testConfigurationSet =
    [ [ 0, 1, 1, 1 ]
    , [ 0, 1, 2, 3 ]
    , [ 0, 5, 5, 5 ]
    ];

    // Resolution of test ids to actual observable ids
    const var testIds = obstestPkg.getTestObservableIds( rctx, scriptEhId );

    // An array indexed by logical test observable id where each
    //  entry is the expected value of the rollover counter.
    var rolloverMirror = [];
    for (var i = 0; i < obstestPkg.testObservableCount; ++i)
    {
      rolloverMirror[ i ] = 0;
    }

    // Loop once per testConfigurationSet entry:
    for (var i = 0; i < testConfigurationSet.length(); ++i)
    {
      logInfo( "_____________LOOP ITERATION=" + i + "____________" );
      const var thisRule = testConfigurationSet[ i ];

      const var thisLogicalTestId    = thisRule[ 0 ];
      const var thisFirstNotify      = thisRule[ 1 ];
      const var thisBufferlessNotify = thisRule[ 2 ];
      const var thisFinalNotify      = thisRule[ 3 ];

      const var thisActualObsId    = testIds[ thisLogicalTestId ];

      // Enable age appropriately
      agePkg.setConfiguration( rctx, scriptEhId, BUFFER_COUNT, BUFFER_SIZE, 0 );

      // Clear event queue
      evList.clear();

      // Set up expectation structure
      const var xpList = new pkg.util.expect.ExpectationList();

      // enable push for an observable
      obsPkg.configureStreamExpecting(
          rctx
        , scriptEhId
        , thisActualObsId
        , 1, 0, 1, 0
        );

      // Expect a first time observation
      xpList.add(
          /**/  [ "result", " instanceof ti.observable.ObservationPartialDecodeEntry" ]
          ,     [ "result.getId()", "==" + thisActualObsId ]
          ,     [ "result.getRolloverCounter()", "==" + rolloverMirror[ thisLogicalTestId ] ]
          );
      ++rolloverMirror[ thisLogicalTestId ];


      // trigger sequence of set/notify ops
      obstestPkg.createTriggerNTimes( thisLogicalTestId, thisFirstNotify ).perform( rctx, scriptEhId );
      for (var j = 0; j < thisFirstNotify; ++j)
      {
        xpList.add(
          /**/  [ "result", " instanceof ti.observable.ObservationPartialDecodeEntry" ]
          ,     [ "result.getId()", "==" + thisActualObsId ]
          ,     [ "result.getRolloverCounter()", "==" + rolloverMirror[ thisLogicalTestId ] ]
          );

        for (var k = 0; k < rolloverMirror.length(); ++k)
        {
          ++rolloverMirror[ k ];
        }
      }

      // Disable age (no buffers)
      agePkg.setConfiguration( rctx, scriptEhId, 0, BUFFER_SIZE, 0 );

      // trigger next set of set/notify ops
      obstestPkg.createTriggerNTimes( thisLogicalTestId, thisBufferlessNotify ).perform( rctx, scriptEhId );
      for (var k = 0; k < rolloverMirror.length(); ++k)
      {
        rolloverMirror[ k ] += thisBufferlessNotify;
      }

      // Remember: we expect nothing here... put a placeholder in
      agePkg.forceSendAll( rctx, scriptEhId );
      evList.add( 5 );
      xpList.add( [ "result", "==5" ] );

      // Enable age appropriately
      agePkg.setConfiguration( rctx, scriptEhId, BUFFER_COUNT, BUFFER_SIZE, 0 );

      // trigger sequence of set/notify ops
      obstestPkg.createTriggerNTimes( thisLogicalTestId, thisFinalNotify ).perform( rctx, scriptEhId );
      for (var j = 0; j < thisFinalNotify; ++j)
      {
        xpList.add(
          /**/  [ "result.getId()", "==" + thisActualObsId ]
          ,     [ "result instanceof ti.observable.ObservationPartialDecodeEntry" ]
          ,     [ "result.getRolloverCounter()", "==" + rolloverMirror[ thisLogicalTestId ] ]
          );
        for (var k = 0; k < rolloverMirror.length(); ++k)
        {
          ++rolloverMirror[ k ];
        }
      }
      
      logInfo( "verify that the expected number were dropped" );
      agePkg.forceSendAll( rctx, scriptEhId );
      
      logWarning( "NOTE: a delay was inserted here to avoid a chimera race condition."
                  + " This is not guaranteed to prevent errors after this." );
      java.lang.Thread.currentThread().sleep( 5000 );
      logInfo( "Fakie delay complete." );

      xpList.evaluate( evList, logError, logInfo );

    }

  }

}


