/*=============================================================================
 *     Copyright Texas Instruments 2001. All Rights Reserved.
 */

/**
 * Wrapper for the Mode Manager event handler.
 * 
 * @param nodeId       the id of the hostbuild to send/recv to/from
 */
public function MmWrapper( nodeId, taskController )
  extends pkg.util.Subsystem( nodeId, "MmWrapper" )
{
  var esf = services["esf routing"];
  var rctx = esf.getRoutingContext( esf.RCTX_MODE_EVERYTHING );
  var prim = null;
  
  public static const var ACTIVATION_MODE_BASE        = 0;
  public static const var ACTIVATION_MODE_GSM         = 1;
  public static const var ACTIVATION_MODE_WCDMA       = 2;
  
  /**
   * Error Status field indicates whether or not the event handler wants to
   * report an error
   */
  public static const var ERROR_STATUS_ERROR    = 0;
  public static const var ERROR_STATUS_NO_ERROR = 1;
  
  /**
   * This defines the different reasons for activating a particular mode.
   */
  public static const var ACTIVATION_REASON_INTER_STACK_HANDOFF = 0;
  public static const var ACTIVATION_REASON_INTER_MODE_SWITCH   = ACTIVATION_REASON_INTER_STACK_HANDOFF;
  public static const var ACTIVATION_REASON_POWER_UP            = 1;
  public static const var ACTIVATION_REASON_RESET               = 2;
  public static const var ACTIVATION_REASON_NONE                = 3;
 
  /**
   * This defines the different results of activation.
   */
  public static const var ACTIVATION_STATUS_SUCCESS      = 0;
  public static const var ACTIVATION_STATUS_INTERRUPTED  = 1;
  public static const var ACTIVATION_STATUS_UNSUCCESSFUL = 2;
  
  /**
   * This defines the different reasons for deactivating a particular mode.
   */
  public static const var DEACTIVATION_REASON_INTER_STACK_HANDOFF = 0;
  public static const var DEACTIVATION_REASON_INTER_MODE_SWITCH   = DEACTIVATION_REASON_INTER_STACK_HANDOFF;
  public static const var DEACTIVATION_REASON_POWER_DOWN          = 2;
  public static const var DEACTIVATION_REASON_RESET               = 3;
  public static const var DEACTIVATION_REASON_NONE                = 4;
  
  function waitForPrim( primToWaitFor )
  {
    taskController.run( function()
                        {
                          return( (prim == null) || !( prim instanceof primToWaitFor ) );
                        } );
    return;
  }
  
  /**
   */
  public function activateReq( activationMode,
                               activationReason )
  {
    // send MM_ACTIVATE_REQ:
    rctx.sendPrim( new MM_ACTIVATE_REQ( task.getEhId(),
                                        activationMode,
                                        activationReason ) );

    waitForPrim( MM_ACTIVATE_CNF );
  }
  
  /**
   */
  public function onlineInd( ehId,
                             activationMode,
                             activationReason )
  {
    // send MM_ONLINE_IND:
    rctx.sendPrim( new MM_ONLINE_IND( nodeId,
                                      ehId,
                                      activationMode,
                                      activationReason ) );
  }
  
  /**
   */
  public function offlineInd( ehId,
                              deactivationReason )
  {
    // send MM_OFFLINE_IND:
    rctx.sendPrim( new MM_OFFLINE_IND( nodeId,
                                       ehId,
                                       deactivationReason ) );
  }
  
  /**
   */
  function handlePrim( rxPrim )
  {
    if( rxPrim.getSourceNodeId() == nodeId )
    {
      prim = rxPrim;
    }
  }
  
  /**
   */
  function isBlocked()
  {
    return( prim == null );
  }
  
  // we want to recv certain primitives:
  taskController.addPrimHandlers( [ MM_ACTIVATE_CNF ],
                                  handlePrim );
}


/*
 *   Local Variables:
 *   tab-width: 2
 *   indent-tabs-mode: nil
 *   mode: java
 *   c-indentation-style: java
 *   c-basic-offset: 2
 *   eval: (c-set-offset 'statement-cont '0)
 *   eval: (c-set-offset 'substatement-open '0)
 *   eval: (c-set-offset 'case-label '+)
 *   eval: (c-set-offset 'inclass '+)
 *   eval: (c-set-offset 'inline-open '0)
 *   End:
 */
