/*=============================================================================
 *     Copyright Texas Instruments 2001. All Rights Reserved.
 */


/**
 * Wrapper for theLog event handler.
 * 
 * @param nodeId       the id of the hostbuild to send/recv to/from
 */
public function LogWrapper( nodeId, taskController )
  extends pkg.util.Subsystem( nodeId, "LogWrapper" )
{
  var prim = null;
  
  /**
   */
  public function disableInterfaceReq( interfaceId )
  {
    // send LOG_DISABLE_INTERFACE_REQ:
    sendPrim( new LOG_DISABLE_INTERFACE_REQ( task.getEhId(),
                                             interfaceId ) );
  }
  
  /**
   * 
   */
  public function waitForDisableInterfaceCnf()
  {
    taskController.run( function() { return ((prim == null) || !(prim instanceof LOG_DISABLE_INTERFACE_CNF)); } );
      
    prim = null;
      
    return;
  }
  
  /**
   */
  public function disableLoggingReq()
  {
    // send LOG_DISABLE_LOGGING_REQ:
    sendPrim( new LOG_DISABLE_LOGGING_REQ( task.getEhId() ) );
  }
  
  /**
   * 
   */
  public function waitForDisableLoggingCnf()
  {
    taskController.run( function() { return ((prim == null) || !(prim instanceof LOG_DISABLE_LOGGING_CNF)); } );
      
    prim = null;
      
    return;
  }
  
  /**
   */
  public function enableInterfaceReq( interfaceId )
  {
    // send LOG_ENABLE_INTERFACE_REQ:
    sendPrim( new LOG_ENABLE_INTERFACE_REQ( task.getEhId(),
                                            interfaceId ) );
  }
  
  /**
   * 
   */
  public function waitForEnableInterfaceCnf()
  {
    taskController.run( function() { return ((prim == null) || !(prim instanceof LOG_ENABLE_INTERFACE_CNF)); } );
      
    prim = null;
      
    return;
  }
  
  /**
   */
  public function enableLoggingReq()
  {
    // send LOG_ENABLE_LOGGING_REQ:
    sendPrim( new LOG_ENABLE_LOGGING_REQ( task.getEhId() ) );
  }
  
  /**
   * 
   */
  public function waitForEnableLoggingCnf()
  {
    taskController.run( function() { return ((prim == null) || !(prim instanceof LOG_ENABLE_LOGGING_CNF)); } );
      
    prim = null;
      
    return;
  }
  
  /**
   */
  public function statusReq()
  {
    // send LOG_STATUS_REQ:
    sendPrim( new LOG_STATUS_REQ( task.getEhId() ) );
  }
  
  /**
   * 
   */
  public function waitForStatusCnf()
  {
    taskController.run( function() { return ((prim == null) || !(prim instanceof LOG_STATUS_CNF)); } );
      
    prim = null;
      
    return;
  }
  
  /**
   */
  function handlePrim( prim )
  {
    if( prim.getSourceNodeId() == nodeId )
    {
      this.prim = prim;
    }
  }
  
  
  // we want to recv certain primitives:
  taskController.addPrimHandlers( [ LOG_STATUS_CNF,
                                    LOG_ENABLE_LOGGING_CNF,
                                    LOG_ENABLE_INTERFACE_CNF,
                                    LOG_DISABLE_LOGGING_CNF,
                                    LOG_DISABLE_INTERFACE_CNF ],
                                  handlePrim );
}




/*
 *   Local Variables:
 *   tab-width: 2
 *   indent-tabs-mode: nil
 *   mode: java
 *   c-indentation-style: java
 *   c-basic-offset: 2
 *   eval: (c-set-offset 'statement-cont '0)
 *   eval: (c-set-offset 'substatement-open '0)
 *   eval: (c-set-offset 'case-label '+)
 *   eval: (c-set-offset 'inclass '+)
 *   eval: (c-set-offset 'inline-open '0)
 *   End:
 */
