/*=============================================================================
 *     Copyright Texas Instruments 2001. All Rights Reserved.
 */

const var DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS = 1;
const var DEV_HOST_INTC_BASE_ADDRESS               = 0x0A000000;

const var HOST_INTC_REG_IRQ_STATUS_0_ADDR        = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x000 * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_STATUS_1_ADDR        = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x004 * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_STATUS_2_ADDR        = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x008 * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_STATUS_3_ADDR        = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x00C * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_STATUS_4_ADDR        = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x010 * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_STATUS_5_ADDR        = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x014 * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_STATUS_6_ADDR        = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x018 * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_STATUS_7_ADDR        = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x01C * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );

const var HOST_INTC_REG_IRQ_ENABLE_0_ADDR        = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x020 * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_ENABLE_1_ADDR        = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x024 * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_ENABLE_2_ADDR        = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x028 * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_ENABLE_3_ADDR        = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x02C * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_ENABLE_4_ADDR        = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x030 * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_ENABLE_5_ADDR        = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x034 * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_ENABLE_6_ADDR        = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x038 * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_ENABLE_7_ADDR        = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x03C * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );

const var HOST_INTC_REG_IRQ_CLEAR_0_ADDR         = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x040 * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_CLEAR_1_ADDR         = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x044 * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_CLEAR_2_ADDR         = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x048 * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_CLEAR_3_ADDR         = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x04C * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_CLEAR_4_ADDR         = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x050 * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_CLEAR_5_ADDR         = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x054 * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_CLEAR_6_ADDR         = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x058 * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );
const var HOST_INTC_REG_IRQ_CLEAR_7_ADDR         = ( DEV_HOST_INTC_BASE_ADDRESS + ( 0x05C * DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS ) );



const var HOST_INTC_REG_IRQ_STATUS_0_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_STATUS_1_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_STATUS_2_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_STATUS_3_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_STATUS_4_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_STATUS_5_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_STATUS_6_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_STATUS_7_INITIAL_VALUE      = ( 0x00000000 );

const var HOST_INTC_REG_IRQ_ENABLE_0_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_ENABLE_1_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_ENABLE_2_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_ENABLE_3_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_ENABLE_4_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_ENABLE_5_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_ENABLE_6_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_ENABLE_7_INITIAL_VALUE      = ( 0x00000000 );

const var HOST_INTC_REG_IRQ_CLEAR_0_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_CLEAR_1_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_CLEAR_2_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_CLEAR_3_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_CLEAR_4_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_CLEAR_5_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_CLEAR_6_INITIAL_VALUE      = ( 0x00000000 );
const var HOST_INTC_REG_IRQ_CLEAR_7_INITIAL_VALUE      = ( 0x00000000 );

/*
 * For now this list of registers must be ordered from lowest address to highest address
 */
public const var regBlock = 
  new pkg.esf.dev.RegisterBlock( "HostIntC",
                     (DEV_HOST_INTC_BASE_ADDRESS),
                     DEV_HOST_INTC_MIN_ADDRESSABLE_DATA_UNITS,
                     [
                       new pkg.esf.dev.Register( "STATUS_0",
                                     HOST_INTC_REG_IRQ_STATUS_0_ADDR,
                                     HOST_INTC_REG_IRQ_STATUS_0_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source31", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source30", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source29", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source28", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source27", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source26", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source25", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source24", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source23", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source22", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source21", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source20", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source19", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source18", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source17", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source16", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source15", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source14", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source13", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source12", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source11", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source10", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source9", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source8", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source7", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source6", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source5", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source4", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source3", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source2", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source1", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source0", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "STATUS_1",
                                     HOST_INTC_REG_IRQ_STATUS_1_ADDR,
                                     HOST_INTC_REG_IRQ_STATUS_1_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source63", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source62", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source61", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source60", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source59", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source58", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source57", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source56", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source55", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source54", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source53", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source52", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source51", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source50", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source49", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source48", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source47", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source46", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source45", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source44", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source43", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source42", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source41", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source40", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source39", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source38", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source37", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source36", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source35", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source34", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source33", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source32", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "STATUS_2",
                                     HOST_INTC_REG_IRQ_STATUS_2_ADDR,
                                     HOST_INTC_REG_IRQ_STATUS_2_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source95", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source94", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source93", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source92", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source91", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source90", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source89", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source88", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source87", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source86", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source85", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source84", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source83", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source82", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source81", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source80", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source79", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source78", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source77", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source76", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source75", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source74", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source73", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source72", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source71", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source70", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source69", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source68", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source67", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source66", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source65", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source64", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "STATUS_3",
                                     HOST_INTC_REG_IRQ_STATUS_3_ADDR,
                                     HOST_INTC_REG_IRQ_STATUS_3_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source127", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source126", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source125", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source124", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source123", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source122", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source121", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source120", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source119", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source118", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source117", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source116", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source115", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source114", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source113", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source112", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source111", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source110", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source109", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source108", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source107", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source106", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source105", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source104", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source103", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source102", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source101", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source100", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source99", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source98", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source97", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source96", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "STATUS_4",
                                     HOST_INTC_REG_IRQ_STATUS_4_ADDR,
                                     HOST_INTC_REG_IRQ_STATUS_4_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source159", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source158", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source157", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source156", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source155", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source154", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source153", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source152", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source151", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source150", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source149", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source148", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source147", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source146", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source145", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source144", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source143", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source142", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source141", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source140", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source139", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source138", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source137", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source136", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source135", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source134", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source133", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source132", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source131", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source130", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source129", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source128", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "STATUS_5",
                                     HOST_INTC_REG_IRQ_STATUS_5_ADDR,
                                     HOST_INTC_REG_IRQ_STATUS_5_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source191", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source190", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source189", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source188", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source187", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source186", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source185", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source184", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source183", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source182", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source181", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source180", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source179", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source178", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source177", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source176", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source175", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source174", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source173", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source172", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source171", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source170", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source169", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source168", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source167", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source166", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source165", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source164", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source163", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source162", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source161", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source160", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "STATUS_6",
                                     HOST_INTC_REG_IRQ_STATUS_6_ADDR,
                                     HOST_INTC_REG_IRQ_STATUS_6_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source223", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source222", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source221", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source220", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source219", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source218", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source217", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source216", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source215", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source214", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source213", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source212", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source211", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source210", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source209", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source208", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source207", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source206", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source205", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source204", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source203", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source202", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source201", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source200", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source199", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source198", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source197", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source196", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source195", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source194", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source193", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source192", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "STATUS_7",
                                     HOST_INTC_REG_IRQ_STATUS_7_ADDR,
                                     HOST_INTC_REG_IRQ_STATUS_7_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source255", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source254", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source253", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source252", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source251", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source250", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source249", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source248", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source247", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source246", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source245", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source244", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source243", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source242", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source241", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source240", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source239", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source238", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source237", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source236", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source235", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source234", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source233", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source232", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source231", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source230", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source229", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source228", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source227", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source226", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source225", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source224", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "ENABLE_0",
                                     HOST_INTC_REG_IRQ_ENABLE_0_ADDR,
                                     HOST_INTC_REG_IRQ_ENABLE_0_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source31", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source30", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source29", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source28", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source27", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source26", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source25", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source24", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source23", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source22", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source21", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source20", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source19", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source18", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source17", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source16", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source15", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source14", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source13", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source12", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source11", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source10", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source9", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source8", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source7", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source6", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source5", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source4", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source3", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source2", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source1", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source0", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "ENABLE_1",
                                     HOST_INTC_REG_IRQ_ENABLE_1_ADDR,
                                     HOST_INTC_REG_IRQ_ENABLE_1_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source63", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source62", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source61", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source60", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source59", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source58", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source57", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source56", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source55", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source54", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source53", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source52", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source51", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source50", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source49", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source48", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source47", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source46", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source45", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source44", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source43", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source42", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source41", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source40", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source39", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source38", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source37", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source36", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source35", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source34", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source33", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source32", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "ENABLE_2",
                                     HOST_INTC_REG_IRQ_ENABLE_2_ADDR,
                                     HOST_INTC_REG_IRQ_ENABLE_2_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source95", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source94", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source93", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source92", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source91", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source90", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source89", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source88", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source87", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source86", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source85", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source84", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source83", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source82", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source81", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source80", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source79", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source78", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source77", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source76", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source75", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source74", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source73", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source72", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source71", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source70", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source69", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source68", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source67", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source66", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source65", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source64", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "ENABLE_3",
                                     HOST_INTC_REG_IRQ_ENABLE_3_ADDR,
                                     HOST_INTC_REG_IRQ_ENABLE_3_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source127", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source126", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source125", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source124", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source123", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source122", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source121", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source120", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source119", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source118", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source117", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source116", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source115", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source114", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source113", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source112", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source111", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source110", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source109", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source108", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source107", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source106", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source105", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source104", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source103", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source102", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source101", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source100", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source99", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source98", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source97", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source96", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "ENABLE_4",
                                     HOST_INTC_REG_IRQ_ENABLE_4_ADDR,
                                     HOST_INTC_REG_IRQ_ENABLE_4_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source159", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source158", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source157", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source156", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source155", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source154", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source153", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source152", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source151", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source150", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source149", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source148", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source147", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source146", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source145", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source144", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source143", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source142", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source141", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source140", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source139", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source138", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source137", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source136", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source135", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source134", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source133", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source132", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source131", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source130", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source129", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source128", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "ENABLE_5",
                                     HOST_INTC_REG_IRQ_ENABLE_5_ADDR,
                                     HOST_INTC_REG_IRQ_ENABLE_5_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source191", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source190", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source189", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source188", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source187", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source186", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source185", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source184", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source183", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source182", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source181", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source180", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source179", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source178", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source177", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source176", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source175", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source174", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source173", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source172", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source171", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source170", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source169", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source168", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source167", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source166", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source165", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source164", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source163", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source162", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source161", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source160", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "ENABLE_6",
                                     HOST_INTC_REG_IRQ_ENABLE_6_ADDR,
                                     HOST_INTC_REG_IRQ_ENABLE_6_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source223", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source222", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source221", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source220", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source219", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source218", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source217", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source216", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source215", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source214", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source213", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source212", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source211", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source210", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source209", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source208", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source207", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source206", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source205", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source204", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source203", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source202", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source201", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source200", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source199", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source198", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source197", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source196", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source195", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source194", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source193", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source192", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "ENABLE_7",
                                     HOST_INTC_REG_IRQ_ENABLE_7_ADDR,
                                     HOST_INTC_REG_IRQ_ENABLE_7_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source255", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source254", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source253", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source252", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source251", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source250", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source249", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source248", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source247", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source246", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source245", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source244", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source243", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source242", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source241", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source240", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source239", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source238", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source237", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source236", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source235", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source234", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source233", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source232", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source231", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source230", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source229", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source228", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source227", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source226", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source225", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source224", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "CLEAR_0",
                                     HOST_INTC_REG_IRQ_CLEAR_0_ADDR,
                                     HOST_INTC_REG_IRQ_CLEAR_0_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source31", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source30", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source29", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source28", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source27", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source26", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source25", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source24", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source23", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source22", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source21", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source20", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source19", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source18", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source17", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source16", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source15", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source14", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source13", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source12", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source11", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source10", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source9", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source8", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source7", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source6", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source5", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source4", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source3", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source2", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source1", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source0", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "CLEAR_1",
                                     HOST_INTC_REG_IRQ_CLEAR_1_ADDR,
                                     HOST_INTC_REG_IRQ_CLEAR_1_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source63", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source62", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source61", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source60", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source59", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source58", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source57", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source56", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source55", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source54", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source53", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source52", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source51", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source50", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source49", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source48", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source47", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source46", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source45", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source44", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source43", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source42", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source41", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source40", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source39", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source38", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source37", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source36", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source35", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source34", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source33", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source32", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "CLEAR_2",
                                     HOST_INTC_REG_IRQ_CLEAR_2_ADDR,
                                     HOST_INTC_REG_IRQ_CLEAR_2_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source95", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source94", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source93", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source92", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source91", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source90", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source89", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source88", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source87", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source86", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source85", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source84", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source83", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source82", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source81", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source80", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source79", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source78", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source77", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source76", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source75", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source74", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source73", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source72", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source71", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source70", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source69", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source68", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source67", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source66", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source65", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source64", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "CLEAR_3",
                                     HOST_INTC_REG_IRQ_CLEAR_3_ADDR,
                                     HOST_INTC_REG_IRQ_CLEAR_3_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source127", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source126", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source125", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source124", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source123", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source122", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source121", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source120", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source119", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source118", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source117", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source116", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source115", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source114", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source113", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source112", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source111", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source110", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source109", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source108", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source107", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source106", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source105", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source104", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source103", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source102", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source101", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source100", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source99", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source98", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source97", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source96", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "CLEAR_4",
                                     HOST_INTC_REG_IRQ_CLEAR_4_ADDR,
                                     HOST_INTC_REG_IRQ_CLEAR_4_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source159", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source158", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source157", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source156", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source155", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source154", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source153", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source152", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source151", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source150", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source149", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source148", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source147", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source146", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source145", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source144", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source143", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source142", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source141", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source140", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source139", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source138", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source137", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source136", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source135", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source134", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source133", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source132", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source131", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source130", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source129", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source128", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "CLEAR_5",
                                     HOST_INTC_REG_IRQ_CLEAR_5_ADDR,
                                     HOST_INTC_REG_IRQ_CLEAR_5_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source191", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source190", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source189", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source188", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source187", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source186", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source185", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source184", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source183", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source182", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source181", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source180", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source179", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source178", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source177", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source176", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source175", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source174", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source173", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source172", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source171", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source170", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source169", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source168", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source167", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source166", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source165", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source164", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source163", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source162", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source161", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source160", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "CLEAR_6",
                                     HOST_INTC_REG_IRQ_CLEAR_6_ADDR,
                                     HOST_INTC_REG_IRQ_CLEAR_6_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source223", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source222", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source221", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source220", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source219", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source218", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source217", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source216", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source215", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source214", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source213", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source212", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source211", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source210", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source209", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source208", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source207", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source206", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source205", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source204", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source203", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source202", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source201", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source200", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source199", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source198", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source197", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source196", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source195", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source194", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source193", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source192", 0, 1, true ) ] ),
                       new pkg.esf.dev.Register( "CLEAR_7",
                                     HOST_INTC_REG_IRQ_CLEAR_7_ADDR,
                                     HOST_INTC_REG_IRQ_CLEAR_7_INITIAL_VALUE,
                                     true,
                                     true,
                                     [ new pkg.esf.dev.RegisterField( "Source255", 31, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source254", 30, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source253", 29, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source252", 28, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source251", 27, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source250", 26, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source249", 25, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source248", 24, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source247", 23, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source246", 22, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source245", 21, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source244", 20, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source243", 19, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source242", 18, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source241", 17, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source240", 16, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source239", 15, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source238", 14, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source237", 13, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source236", 12, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source235", 11, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source234", 10, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source233", 9, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source232", 8, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source231", 7, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source230", 6, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source229", 5, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source228", 4, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source227", 3, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source226", 2, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source225", 1, 1, true ),
                                       new pkg.esf.dev.RegisterField( "Source224", 0, 1, true ) ] )
                       ] );

/*
 *   Local Variables:
 *   tab-width: 2
 *   indent-tabs-mode: nil
 *   mode: java
 *   c-indentation-style: java
 *   c-basic-offset: 2
 *   eval: (c-set-offset 'statement-cont '0)
 *   eval: (c-set-offset 'substatement-open '0)
 *   eval: (c-set-offset 'case-label '+)
 *   eval: (c-set-offset 'inclass '+)
 *   eval: (c-set-offset 'inline-open '0)
 *   End:
 */
