
public var util = new (function() {


  /** A boilerplate function that is used to start all unit tests.  It
      puts the AGE event handler into a known, isolated state from
      which it can be tested without messing with the rest of the
      system.
   */
  public function unitTestStart (
        rctx
      , scriptEhId
      , phase
      , preallocCount
      , preallocSize
      , refreshPeriod
    )
  {
    return testStart(
          rctx
        , scriptEhId
        , phase
        , preallocCount
        , preallocSize
        , refreshPeriod
        , true
      );
  }


  /** A boilerplate function that is used to start all unit tests.  It
      puts the AGE event handler into a known, isolated state from
      which it can be tested without messing with the rest of the
      system.
   */
  public function integTestStart (
        rctx
      , scriptEhId
      , phase
      , preallocCount
      , preallocSize
      , refreshPeriod
    )
  {
    return testStart(
          rctx
        , scriptEhId
        , phase
        , preallocCount
        , preallocSize
        , refreshPeriod
        , false
      );
  }


  function testStart (
        rctx
      , scriptEhId
      , phase
      , preallocCount
      , preallocSize
      , refreshPeriod
      , debugMode
    )
  {
    var retval = true;
    if (!reset( rctx, scriptEhId, debugMode ))
    {
      retval = false;
      pkg.output.logError( phase + "Reset debug fail." );
    }
    if (!verifySubscriber( rctx, scriptEhId, false, -1 ) )
    {
      pkg.output.logWarning( phase + "Subscriber Exists! (Note: this warning" );
      pkg.output.logWarning( phase + "    is very likely if a test was interrupted" );
      pkg.output.logWarning( phase + "    prior to running this one)" );
    }
    if (!unsetSubscriber( rctx, scriptEhId ) )
    {
      retval = false;
      pkg.output.logError( phase + "Unsubscribe fail." );
    }
    if (!setSubscriber( rctx, scriptEhId ) )
    {
      retval = false;
      pkg.output.logError( phase + "Subscribe fail." );
    }
    if (!setConfiguration( rctx, scriptEhId, preallocCount, preallocSize, refreshPeriod ) )
    {
      retval = false;
      pkg.output.logError( phase + " buf cfg fail." );
    }
    if (!forceSendAll( rctx, scriptEhId ) )
    {
      retval = false;
      pkg.output.logError( phase + "AGE eh not in a good state." );
    }

    return retval;
  }



  /** A boilerplate function that is used to complete an integration test.  It
      allows the AGE event handler to go back into system mode.
   */
  public function integTestEnd(
        rctx
      , scriptEhId
      , phase
    )
  {
    return testEnd( rctx, scriptEhId, phase );
  }



  /** A boilerplate function that is used to complete a unit test.  It
      allows the AGE event handler to go back into system mode.
   */
  public function unitTestEnd(
        rctx
      , scriptEhId
      , phase
    )
  {
    return testEnd( rctx, scriptEhId, phase );
  }



  function testEnd(
        rctx
      , scriptEhId
      , phase
    )
  {
    var retval = true;
    if (!unsetSubscriber( rctx, scriptEhId ) )
    {
      retval = false;
      pkg.output.logError( phase + "Unsubscribe fail." );
    }

    if (!reset( rctx, scriptEhId, false ))
    {
      retval = false;
      pkg.output.logError( phase + "Reset debug fail." );
    }

    return retval;
  }



  /** A wrapper for the reset primitive transaction.  */
  public function reset(
          rctx
        , scriptEhId
        , debugMode
      )
  {
    const var prim = rctx.sendAndWaitForPrim(
          new AGE_RESET_REQ(
            /* source ehId */          scriptEhId,
            /* isolationModeEnable */  (debugMode?1:0)
          )
        , rctx.type( AGE_RESET_CNF )
        );

    if (!(prim instanceof AGE_RESET_CNF ) )
    {
      pkg.output.logError( "PRIM IS OF WRONG TYPE" );
    }

    return true;
  }



  /** Verifies that the current subscriber to this event handler
      is who is expected.
    */
  public function verifySubscriber(
        rctx
      , scriptEhId
      , isSubscriber
      , subscriberId
      )
  {
    const var prim = rctx.sendAndWaitForPrim(
          new AGE_QUERY_SUBSCRIPTION_STATE_REQ(
            /* source ehId */          scriptEhId
          )
        , rctx.type( AGE_SUBSCRIPTION_STATE_CNF )
        );

    if (!(prim instanceof AGE_SUBSCRIPTION_STATE_CNF ) )
    {
      pkg.output.logError( "PRIM IS OF WRONG TYPE" );
    }

    if (
            isSubscriber
        &&  prim.getSubscribersCount() > 0
        &&  prim.getSubscribers()[0] == subscriberId
      )  return true;

    if (
            !isSubscriber
        &&  prim.getSubscribersCount() == 0
    ) return true;

    return false;
  }



  /** Regardless of whether anyone in the system is currently
      subscribed to this event handler, this operation ensures
      that no subscriber is currently attached.
   */
  public function unsetSubscriber(
      rctx
    , scriptEhId
    )
  {
    pkg.output.logInfoMsg( "Insure no subscribers..." );
    var prim = rctx.sendAndWaitForPrim(
          new AGE_QUERY_SUBSCRIPTION_STATE_REQ(
            /* source ehId */          scriptEhId
          )
        , rctx.type( AGE_SUBSCRIPTION_STATE_CNF )
        );

    if (!(prim instanceof AGE_SUBSCRIPTION_STATE_CNF ) )
    {
      pkg.output.logError( "PRIM IS OF WRONG TYPE" );
    }

    if ( prim.getSubscribersCount() > 0 ) {
      var currSubscriber = prim.getSubscribers()[0];

      pkg.output.logInfoMsg( "Unset the current subscriber..." );
      prim = rctx.sendAndWaitForPrim(
            new AGE_SET_SUBSCRIPTION_STATE_REQ(
              /* source ehId */          currSubscriber,
              /* nextSubscriptionSt.. */ 0
            )
          , rctx.type( AGE_SUBSCRIPTION_STATE_CNF )
          );
      if (!(prim instanceof AGE_SUBSCRIPTION_STATE_CNF ) )
      {
        pkg.output.logError( "PRIM IS OF WRONG TYPE" );
      }

      if ( prim.getSubscribersCount() > 0 ) {
        pkg.output.logError("Unset Subscriber failed!" );
        return false;
      }
      pkg.output.logInfoMsg( "  Unset subscriber complete." );
    }
    pkg.output.logInfoMsg( "  no current subscribers." );

    return true;
  }


  /** Attempts to set the subscriber that should receive messages
      from this event handler.
   */
  public function setSubscriber(
          rctx
        , scriptEhId
      )
  {
    var prim = rctx.sendAndWaitForPrim(
          new AGE_SET_SUBSCRIPTION_STATE_REQ(
            /* source ehId */          scriptEhId,
            /* nextSubscriptionSt.. */ 1
          )
        , rctx.type( AGE_SUBSCRIPTION_STATE_CNF )
        );

    if (!(prim instanceof AGE_SUBSCRIPTION_STATE_CNF ) )
    {
      pkg.output.logError( "PRIM IS OF WRONG TYPE" );
    }

    if ( prim.getSubscribersCount() == 0 ) {
      pkg.output.logError( "Set Subscriber failed!" );
      return false;
    }

    return true;
  }


  public function setConfiguration(
          rctx
        , scriptEhId
        , preallocCount
        , preallocSize
        , refreshPeriod
      )
  {
    var prim = rctx.sendAndWaitForPrim(
          new AGE_SET_CONFIG_REQ(
            /* source ehId */          scriptEhId,
            /* preallocatedCount */    preallocCount,
            /* preallocatedSize */     preallocSize,
            /* refreshPeriod */        refreshPeriod
          )
        , rctx.type( AGE_CONFIG_CNF )
        );

    if (!(prim instanceof AGE_CONFIG_CNF ) )
    {
      pkg.output.logError( "PRIM IS OF WRONG TYPE" );
    }


    return __verifyConfiguration(
          prim
        , preallocCount
        , preallocSize
        , refreshPeriod
        );
  }



  public function verifyConfiguration(
          rctx
        , scriptEhId
        , preallocCount
        , preallocSize
        , refreshPeriod
      )
  {
    var prim = rctx.sendAndWaitForPrim(
          new AGE_QUERY_CONFIG_REQ(
            /* source ehId */          scriptEhId
          )
        , rctx.type( AGE_CONFIG_CNF )
        );

    if (!(prim instanceof AGE_CONFIG_CNF ) )
    {
      pkg.output.logError( "PRIM IS OF WRONG TYPE" );
    }

    return __verifyConfiguration(
          prim
        , preallocCount
        , preallocSize
        , refreshPeriod
        );
  }



  public function __verifyConfiguration(
          prim
        , preallocCount
        , preallocSize
        , refreshPeriod
      )
  {
    var retval = true;

    if (prim.getPreallocatedCount() != preallocCount )
    {
      pkg.output.logError( "preallocCount request was " + preallocCount
                          + " but set value was " + prim.getPreallocatedCount()  );
      retval = false;
    }

    if (prim.getPreallocatedSize() != preallocSize )
    {
      pkg.output.logError( "preallocSize request was " + preallocSize
                          + " but set value was " + prim.getPreallocatedSize()  );
      retval = false;
    }

    if (prim.getRefreshPeriod() != refreshPeriod )
    {
      pkg.output.logError( "refreshPeriod request was " + refreshPeriod
                          + " but set value was " + prim.getRefreshPeriod()  );
      retval = false;
    }

    return retval;
  }


  public function queryStats(
          rctx
        , scriptEhId
      )
  {
    var prim = rctx.sendAndWaitForPrim(
          new AGE_QUERY_STATUS_REQ(
            /* source ehId */          scriptEhId
          )
        , rctx.type( AGE_STATUS_CNF )
        );

    if (!(prim instanceof AGE_STATUS_CNF ) )
    {
      pkg.output.logError( "PRIM IS OF WRONG TYPE" );
    }

    return prim;
  }


  public function clearStats(
          rctx
        , scriptEhId
      )
  {
    var prim = rctx.sendAndWaitForPrim(
          new AGE_CLEAR_STATS_REQ(
            /* source ehId */          scriptEhId
          )
        , rctx.type( AGE_STATUS_CNF )
        );

    if (!(prim instanceof AGE_STATUS_CNF ) )
    {
      pkg.output.logError( "PRIM IS OF WRONG TYPE" );
    }

    return prim;
  }


  public function triggerBufferService(
        rctx
      , scriptEhId
    )
  {
    var prim = rctx.sendAndWaitForPrim(
           new AGE_TRIGGER_BUFFER_SERVICE_REQ(
             /* source ehId */          scriptEhId
           )
         , rctx.type( AGE_TRIGGER_BUFFER_SERVICE_CNF )
         );

    if (!(prim instanceof AGE_TRIGGER_BUFFER_SERVICE_CNF ) )
    {
      pkg.output.logError( "PRIM IS OF WRONG TYPE" );
    }

    return true;
  }



  public function forceRelinquish(
        rctx
      , scriptEhId
    )
  {
    var prim = rctx.sendAndWaitForPrim(
        new AGE_TRIGGER_AGGREGATE_ENTRY_IND_REQ(
              /* source ehId */ scriptEhId
            )
          , rctx.type( AGE_TRIGGER_AGGREGATE_ENTRY_IND_CNF )
          );

    if (!(prim instanceof AGE_TRIGGER_AGGREGATE_ENTRY_IND_CNF ) )
    {
      pkg.output.logError( "PRIM IS OF WRONG TYPE" );
    }

    return true;
  }


  public function forceSendAll(
        rctx
      , scriptEhId
    )
  {
    var retval = true;
    retval = forceRelinquish( rctx, scriptEhId ) && retval;
    if (!retval) pkg.output.logWarning( "forceSendAll fail: relinquish failure" );
    retval = triggerBufferService( rctx, scriptEhId ) && retval;
    if (!retval) pkg.output.logWarning( "forceSendAll fail: buffer service failure" );
    return retval;
  }


  public function OSEntry( )
  {
    var uint32Arr ;
    var uint16Arr ;
    var uint8Arr  ;
    var tag ;

    public function clear()
    {
      uint32Arr = [];
      uint16Arr = [];
      uint8Arr  = [];
      tag = 0;
    }


    public function randomize( n32, n16, n8, seed )
    {
      clear();
      const var rand = new java.util.Random( seed );
      tag = rand.nextInt( 65536 );
      for (var i = 0; i < n32; ++i ) uint32Arr[ i ] = rand.nextInt();
      for (var i = 0; i < n16; ++i ) uint16Arr[ i ] = rand.nextInt( 65536 );
      for (var i = 0; i < n8;  ++i ) uint8Arr[  i ] = rand.nextInt( 256 );
    }


    public function set( newtag, a32, a16, a8 )
    {
      clear();
      tag = newtag;
      uint32Arr = a32;
      uint16Arr = a16;
      uint8Arr = a8;
    }

    public function setTag( newTag ) { tag = newTag; }

    public function get32() { return uint32Arr; }
    public function get16() { return uint16Arr; }
    public function get8()  { return uint8Arr;  }
    public function getTag() { return tag; }

    public function toString()
    {
      return "Entry< Tag=" + tag
              + ",Size=" + (uint32Arr.length()*4 + uint16Arr.length()*2 + uint8Arr.length())
              + ",32s=" + uint32Arr
              + ",16s=" + uint16Arr
              + ",8s="  + uint8Arr
              + ">";
    }

  }


  public function acquireEntryDecoder( logInfo, logWarning, logError )
  {
    logInfo( "Finding the connection" );

    const var thisConn;
    {
      const var cxnIter = services[ "esf connection mgr" ].getConnections();
      if (!cxnIter.hasNext()) logError( "Test case requires a single SUTConnection; there are none" );
      thisConn = cxnIter.next();
      if (cxnIter.hasNext()) logWarning( "Test case expects a single SUTConnection; there is more than one" );
    }

    logInfo( "Bound to connection '" + thisConn.getName() + "'" );

    return new ti.age.EntryDecoder( main, thisConn );
  }


  public function createInsertEntryReq( scriptEhId, osentry )
  {
    const var c32 = osentry.get32().length();
    const var c16 = osentry.get16().length();
    const var c8  = osentry.get8().length();

    const var local32Arr = [];
    const var local16Arr = [];
    const var local8Arr  = [];

    /* Needs to stay synched with the primitive interface */
    const var AGE_AGEEH_INSERT_ENTRY_REQ_MAX_SIZE = 64;

    for (var i = 0; i < 64; ++i )
    {
      local32Arr [ i ] = (i < c32) ? osentry.get32() [ i ] : 0;
      local16Arr [ i ] = (i < c16) ? osentry.get16() [ i ] : 0;
      local8Arr  [ i ] = (i < c8)  ? osentry.get8()  [ i ] : 0;
    }


    const var a1 = scriptEhId               ;
    const var a2 = osentry.getTag()         ;
    const var a3 = osentry.get32().length() ;
    const var a4 = osentry.get16().length() ;
    const var a5 = osentry.get8().length()  ;
    const var a6 = osentry.get32()          ;
    const var a7 = osentry.get16()          ;
    const var a8 = osentry.get8()           ;

    return new AGE_INSERT_ENTRY_REQ(
          scriptEhId
        , osentry.getTag()
        , osentry.get32().length()
        , osentry.get16().length()
        , osentry.get8().length()
        , local32Arr
        , local16Arr
        , local8Arr
    );

  }


  public function writeBasicEntry(
        rctx
      , scriptEhId
      , osentry
      , expectedResult
    )
  {
    var retval = true;

    pkg.output.logInfoMsg( "Trigger an Entry-->" + osentry.toString() );

    var insertReq = createInsertEntryReq( scriptEhId, osentry );

    var prim = rctx.sendAndWaitForPrim(
          insertReq
        , rctx.type( AGE_INSERT_ENTRY_CNF )
        );

    if (!(prim instanceof AGE_INSERT_ENTRY_CNF ) )
    {
      pkg.output.logError( "PRIM IS OF WRONG TYPE" );
    }

    if (prim.getResult().longValue() != expectedResult.longValue())
    {
      pkg.output.logWarning(
          " Expected '" + expectedResult
        + "' but got '" + prim.getResult()
        + "'"
        );
      retval = false;
    }

    pkg.output.logInfoMsg( "  Entry triggered." );

    return retval;
  }



  public function verifyBasicEntry(
        entry
      , osentry
    )
  {
    var retval = true;

    if (entry.getTag() != osentry.getTag())
    {
      pkg.output.logError(
          "Entry tag mismatch:"
        + " expected " + osentry.getTag()
        + " but got "  + entry.getTag()
        );

      retval = false;
    }

    const var arrs = [ osentry.get32(), osentry.get16(), osentry.get8() ];
    const var nams = [ "s32",           "u16",           "u8"           ];
    const var mths = [ "getS4",         "getU2",         "getU1"        ];

    const var primitiveStream = entry.getBody();

    for (var i = 0; i < arrs.length(); ++i )
      for (var j = 0; j < arrs[ i ].length(); ++j)
      {
        const var expected = arrs[ i ][ j ];
        const var found;
        eval( "found = primitiveStream." + mths[ i ] + "();" );
        if ( found != expected )
        {
          pkg.output.logWarning(
              "This array has " + arrs[ i ].length() + " elements "
            );

          pkg.output.logWarning(
              "    cmp " + nams[ i ] + "[" + j + "]:"
              + " expected " + expected
              + " and found " + found
              );

          pkg.output.logError( " Mismatch! " );

          retval = false;
        }
      }

      return retval;
  }



  public function attachTrap(
        rctx
      , scriptEhId
    )
  {
    var trap = new function() extends
      ti.chimera.service.RoutingService.RoutingContext.PrimHandler()
    {
      const var list = new java.util.LinkedList();
      public function handlePrim( prim ) {list.add( prim );}
      public function getList() {return list;}
    } ();

    rctx.addPrimHandler(
        trap
      , rctx.and(
            rctx.type( AGE_AGGREGATE_ENTRY_IND )
          , rctx.destination( scriptEhId )
          )
      );

    return trap;
  }



  public function detachDecodeTrap(
      rctx
    , trap
    , entryDecoder
  )
  {
    rctx.removePrimHandler( trap );

    while (trap.getList().size() > 0)
    {
      var prim = trap.getList().remove( 0 );
      pkg.output.logInfoMsg(
          "This prim has " + prim.getLength() + " elements "
        );

      entryDecoder.addAggregateEntryInd( prim );
    }

    return entryDecoder;
  }



  public function getStats(
      rctx
    , scriptEhId
    , previous
  )
  {

    function statsStruct(
            aggregateAllocs
          , aggregateSends
          , aggregateDeletes
          , fullWatermark
          , writtenEntries
          , missedEntries
          , previous
          )
      {
        var aggregateAllocsDiff  = aggregateAllocs  ;
        var aggregateSendsDiff   = aggregateSends   ;
        var aggregateDeletesDiff = aggregateDeletes ;
        var fullWatermarkDiff    = fullWatermark    ;
        var writtenEntriesDiff   = writtenEntries   ;
        var missedEntriesDiff    = missedEntries    ;

        if (previous != null) {
          aggregateAllocsDiff  -= previous.getAggregateAllocs  ();
          aggregateSendsDiff   -= previous.getAggregateSends   ();
          aggregateDeletesDiff -= previous.getAggregateDeletes ();
          fullWatermarkDiff    -= previous.getFullWatermark    ();
          writtenEntriesDiff   -= previous.getWrittenEntries   ();
          missedEntriesDiff    -= previous.getMissedEntries    ();
        }

        public function getAggregateAllocs  () {return aggregateAllocs  ;}
        public function getAggregateSends   () {return aggregateSends   ;}
        public function getAggregateDeletes () {return aggregateDeletes ;}
        public function getFullWatermark    () {return fullWatermark    ;}
        public function getWrittenEntries   () {return writtenEntries   ;}
        public function getMissedEntries    () {return missedEntries    ;}

        public function getDiffAggregateAllocs  () {return aggregateAllocsDiff  ;}
        public function getDiffAggregateSends   () {return aggregateSendsDiff   ;}
        public function getDiffAggregateDeletes () {return aggregateDeletesDiff ;}
        public function getDiffFullWatermark    () {return fullWatermarkDiff    ;}
        public function getDiffWrittenEntries   () {return writtenEntriesDiff   ;}
        public function getDiffMissedEntries    () {return missedEntriesDiff    ;}

        public function getInstantaneousAllocatedCount ()
        {
          return getAggregateAllocs() - getAggregateSends() - getAggregateDeletes();
        }

        public function toString()
        {
          return
            "aggregateAllocs:"  + aggregateAllocs  + " (" + aggregateAllocsDiff  + ") " +
            "aggregateSends:"   + aggregateSends   + " (" + aggregateSendsDiff   + ") " +
            "aggregateDeletes:" + aggregateDeletes + " (" + aggregateDeletesDiff + ") " +
            "fullWatermark:"    + fullWatermark    + " (" + fullWatermarkDiff    + ") " +
            "writtenEntries:"   + writtenEntries   + " (" + writtenEntriesDiff   + ") " +
            "missedEntries:"    + missedEntries    + " (" + missedEntriesDiff    + ") " ;
        }

      }

      var prim = rctx.sendAndWaitForPrim(
            new AGE_QUERY_STATUS_REQ(
              /* source ehId */          scriptEhId
            )
          , rctx.type( AGE_STATUS_CNF )
          );

      if (!(prim instanceof AGE_STATUS_CNF ) )
      {
        pkg.output.logError( "PRIM IS OF WRONG TYPE" );
      }

      return new statsStruct(
          prim.getNumAggregateAllocs()
        , prim.getNumAggregateSends()
        , prim.getNumAggregateDeletes()
        , prim.getQueuedAggregateWatermark()
        , prim.getNumWrittenEntries()
        , prim.getNumMissedEntries()
        , previous
        );
  }


}) ();
