/*=============================================================================
 *     Copyright Texas Instruments 2002. All Rights Reserved.
 */


/*=============================================================================
    Description:
    This test is derived from the TestCase base class.

    Specifically, this test puts the age event handler into a situation that
    is more or less like the one it will encounter in a real target.

    Args:
    logWriter        -  A writer object that is used to log any messages.
                        User can either pass in a writer object or null.

    warningWriter    -  A writer object that is used to log any warning messages.
                        User can either pass in a writer object or null.

    errorWriter      -  A writer object that is used to log any error messages
                        User can either pass in a writer object or null.

    Returns:
    n/a

 */
public function TestStandardScenario( logWriter, warningWriter, errorWriter )
  extends pkg.tf.TestCase( "esf.age.TestStandardScenario", logWriter, warningWriter, errorWriter)
{
  /****************************************************************
   * Global variable initionalizations.
   ****************************************************************/
  const var scriptEhId = 0x101;

  const var rctx = services["esf routing"].getRoutingContext();


  //====================================================================================
  /**
   * Overrides the runTest() method in TestCase base class.
   *
   */
  public function runTest()
  {
    var prim;

    logInfo( "Beginning Age Event Handler Unit Test- TestStandardScenario" );
    const var p = pkg.esf.age.util;
    var phase;

    // TODO make sure that nothing else is using this event handler

    // Make the system quiet

    phase = "Init:";
    if (!p.unitTestStart( rctx, scriptEhId, phase, 8, 1000, 0 )) return;



    phase = "TestStandardScenario:";
    const var osEntries = [];
    const var osEntryCount = 64;
    for (var i = 0; i < osEntryCount; ++i)
    {
      osEntries[ i ] = new p.OSEntry();
      osEntries[ i ].randomize( (5 + i) % 4 , (3 + i) % 3 , (7 + i ) % 7 , i );
      osEntries[ i ].setTag( 0xAA00 + (i % 0xFF) );

      if (!p.writeBasicEntry(
            rctx
          , scriptEhId
          , osEntries[ i ]
          , ti.th.prim.Age_AgeEh_InsertEntryResult.AGE_AGEEH_INSERT_ENTRY_SUCCESS
        ) ) logError( phase + "Entry write fail." );
    }


    phase = "VerifyEntry:";
    if (!p.forceRelinquish( rctx, scriptEhId ) ) logError( phase + "Relinquish Fail." );
    var trap = p.attachTrap( rctx, scriptEhId );
    if (!p.triggerBufferService( rctx, scriptEhId) ) logError( phase + "Buffer Service Fail." );
    var decoder = pkg.esf.age.util.acquireEntryDecoder( logInfo, logWarning, logError );
    decoder.setTestReporter( new function () extends ti.test.TestReporter() {
        public function report( string ) {
          logInfo( "TR: " + string );
        }
      } ()
    );
    
    logWarning( "NOTE: a delay was inserted here to avoid a chimera race condition."
                + " This is not guaranteed to prevent errors after this." );
    java.lang.Thread.currentThread().sleep( 5000 );
    logInfo( "Fakie delay complete." );
    
    p.detachDecodeTrap( rctx, trap, decoder );
    const var decodedEntryCount = decoder.entryCount();
    logInfo( "Decoded entry count was " + decodedEntryCount
             + " and osEntryCount is " + osEntryCount );
    if (decodedEntryCount != osEntryCount)
    {
      logError( phase + "Expected " + osEntryCount
                + " entries but found " + decoder.entryCount() );
    }
    for (var i = 0; i < decodedEntryCount; ++i) {
      logInfo( "Inspecting entry i= " + i + ": Expected is " + osEntries[ i ].toString() );
      const var decodedEntry = decoder.get();
      if (!p.verifyBasicEntry( decodedEntry, osEntries[ i ] ) )
      {
        logError( phase + "Entry verify fail." );
      }
    }
    while( decoder.entryCount() > 0) {
      const var unhandled = decoder.get();
      logError( phase + "Unhandled Entry!" + unhandled );
    }
    for (
          var lostEntryIndex = decodedEntryCount
        ; lostEntryIndex < osEntryCount
        ; ++lostEntryIndex
        )
    {
      logError(" Lost the entry " + osEntries[ lostEntryIndex ] );
    }

    phase = "Cleanup:";
    p.unitTestEnd( rctx, scriptEhId, phase );

  }

}




