/*=============================================================================
 *     Copyright Texas Instruments 2002. All Rights Reserved.
 */


/*=============================================================================
    Description:
    This test is derived from the TestCase base class.

    Args:
    logWriter        -  A writer object that is used to log any messages.
                        User can either pass in a writer object or null.

    warningWriter    -  A writer object that is used to log any warning messages.
                        User can either pass in a writer object or null.

    errorWriter      -  A writer object that is used to log any error messages
                        User can either pass in a writer object or null.

    Returns:
    n/a

 */
public function TestMultiEntry( logWriter, warningWriter, errorWriter )
  extends pkg.tf.TestCase( "esf.age.TestMultiEntry", logWriter, warningWriter, errorWriter)
{
  /****************************************************************
   * Global variable initionalizations.
   ****************************************************************/
  const var scriptEhId = 0x101;

  const var rctx = services["esf routing"].getRoutingContext();


  //====================================================================================
  /**
   * Overrides the runTest() method in TestCase base class.
   *
   */
  public function runTest()
  {
    var prim;

    logInfo( "Beginning Age Event Handler Unit Test" );
    const var p = pkg.esf.age.util;
    var phase;

    // Make the system quiet
    phase = "Init:";
    if (!p.unitTestStart( rctx, scriptEhId, phase, 8, 500, 0 )) return;


    phase = "TestMultiEntry:";
    const var osEntries = [];
    const var osEntryCount = 8;
    for (var i = 0; i < osEntryCount; ++i)
    {
      osEntries[ i ] = new p.OSEntry();
      osEntries[ i ].randomize( (5 + i) , (3 + 2 * i)  , (7 + 5 * i ) , i );
      osEntries[ i ].setTag( 0xAAAA );

      if (!p.writeBasicEntry(
            rctx
          , scriptEhId
          , osEntries[ i ]
          , ti.th.prim.Age_AgeEh_InsertEntryResult.AGE_AGEEH_INSERT_ENTRY_SUCCESS
        ) ) logError( phase + "Entry write fail." );
    }


    phase = "VerifyEntry:";
    if (!p.forceRelinquish( rctx, scriptEhId ) ) logError( phase + "Relinquish Fail." );
    var trap = p.attachTrap( rctx, scriptEhId );
    if (!p.triggerBufferService( rctx, scriptEhId) ) logError( phase + "Buffer Service Fail." );
    var decoder = pkg.esf.age.util.acquireEntryDecoder( logInfo, logWarning, logError );

    decoder.setTestReporter( new function () extends ti.test.TestReporter() {
        public function report( string ) {
          logInfo( "TR: " + string );
        }
      } ()
        );
    
    logWarning( "NOTE: a delay was inserted here to avoid a chimera race condition."
                + " This is not guaranteed to prevent errors after this." );
    java.lang.Thread.currentThread().sleep( 5000 );
    logInfo( "Fakie delay complete." );
        
    p.detachDecodeTrap( rctx, trap, decoder );
    if (decoder.entryCount() != osEntryCount) logError( phase + "Expected " + osEntryCount + " entry but found " + decoder.entryCount() );
    for (var i = 0; i < osEntryCount; ++i) {
      if (!p.verifyBasicEntry( decoder.get(), osEntries[ i ] ) )
      {
        logError( phase + "Entry verify fail." );
      }
    }

    phase = "Cleanup:";
    p.unitTestEnd( rctx, scriptEhId, phase );

  }

}




