/*=============================================================================
 *     Copyright Texas Instruments 2002. All Rights Reserved.
 */


/*=============================================================================
    Description:
    This test is derived from the TestCase base class.

    This test case verifies that edge cases concerning the size of entries
    and the sizes of primitives are handled well.


    Args:
    logWriter        -  A writer object that is used to log any messages.
                        User can either pass in a writer object or null.

    warningWriter    -  A writer object that is used to log any warning messages.
                        User can either pass in a writer object or null.

    errorWriter      -  A writer object that is used to log any error messages
                        User can either pass in a writer object or null.

    Returns:
    n/a

 */
public function TestAutoTimer( logWriter, warningWriter, errorWriter )
  extends pkg.tf.TestCase( "esf.age.TestBufferExhaustion", logWriter, warningWriter, errorWriter)
{
  /****************************************************************
   * Global variable initionalizations.
   ****************************************************************/
  const var scriptEhId = 0x101;

  const var rctx = services["esf routing"].getRoutingContext();


  //====================================================================================
  /**
   * Overrides the runTest() method in TestCase base class.
   *
   */
  public function runTest()
  {
    var prim;

    logInfo( "Beginning Age Event Handler Unit Test- TestBufferExhaustion" );
    const var p = pkg.esf.age.util;
    var phase;
    const var preallocSize  = 20;
    const var preallocCount = 4;
    const var refreshPeriod = 100;


    // TODO make sure that nothing else is using this event handler



    // Make the system quiet

    phase = "Init:";
    if (!p.unitTestStart( rctx, scriptEhId, phase, preallocCount, preallocSize, 0 )) return;

    phase = "testAutoTimer:";

    for (var i = 0; i < 50; ++i)
    {
      var osentry = new p.OSEntry();
      osentry.set( i, [12], [], [] );
      var insertReq = p.createInsertEntryReq( scriptEhId, osentry );

      var acceptCount = 0;
      var prim = rctx.sendAndWaitForPrim(
            insertReq
          , function( prim ) {acceptCount++; return acceptCount == 2;}
          , rctx.or(
                    rctx.type( AGE_INSERT_ENTRY_CNF )
                  , rctx.type( AGE_AGGREGATE_ENTRY_IND )
                  )
          );
    }

    phase = "Cleanup:";
    p.unitTestEnd( rctx, scriptEhId, phase );

  }

}




