/*=============================================================================
 *     Copyright Texas Instruments, Inc., 2002.  All Rights Reserved.
 */


/**
 * Simple script to check the seqnChecker to verify that it doesn't have any
 * false positive or false negative conditions.
 */
public function seqnCheckerChecker()
{
  /* We have a hard-coded local out of order of 10, so this must be a multiple
   * of 10 and >= 20.
   */
  var tableSize = 100;
  var repeatCount = 20;
  
  var rctx = services["esf routing"].getRoutingContext();
  
  pkg.output.writeln("Initializing seqnChecker");
  pkg.seqnChecker(tableSize);
  
  function send(seqn)
  {
    var prim = new MM_ONLINE_IND(
                 /* destination ehId */     0x101,
                 /* activationMode */       0,
                 /* activationReason */     0
               );
    prim.putSequenceNumber(seqn);
    rctx.sendPrim(prim);
  }
  
  pkg.output.writeln("Test 1:  sequential primitives");
  var base = 0;
  for( var i=0; i<repeatCount; i++ )
  {
    for( var j=0; j<tableSize; j++ )
    {
      send( base + (i * tableSize) + j );
    }
  }
  
  pkg.output.writeln("Test 2:  local out of order");
  base = repeatCount * tableSize;
  for( var i=0; i<repeatCount; i++ )
  {
    for( var j=0; j<tableSize; j+=10 )
    {
      send( base + (i * tableSize) + j + 9 );
      send( base + (i * tableSize) + j + 1 );
      send( base + (i * tableSize) + j + 5 );
      send( base + (i * tableSize) + j + 2 );
      send( base + (i * tableSize) + j + 0 );
      send( base + (i * tableSize) + j + 8 );
      send( base + (i * tableSize) + j + 4 );
      send( base + (i * tableSize) + j + 6 );
      send( base + (i * tableSize) + j + 3 );
      send( base + (i * tableSize) + j + 7 );
    }
  }
  
  pkg.output.writeln("Test 3:  local out of order and missing seqn");
  base = 2 * repeatCount * tableSize;
  for( var i=0; i<repeatCount; i++ )
  {
    for( var j=0; j<tableSize; j+=10 )
    {
      send( base + (i * tableSize) + j + 9 );
      send( base + (i * tableSize) + j + 1 );
      send( base + (i * tableSize) + j + 5 );
      send( base + (i * tableSize) + j + 2 );
      //send( base + (i * tableSize) + j + 0 );   The missing seqn!!
      send( base + (i * tableSize) + j + 8 );
      send( base + (i * tableSize) + j + 4 );
      send( base + (i * tableSize) + j + 6 );
      send( base + (i * tableSize) + j + 3 );
      send( base + (i * tableSize) + j + 7 );
    }
  }
  
}


/*
 *   Local Variables:
 *   tab-width: 2
 *   indent-tabs-mode: nil
 *   mode: java
 *   c-indentation-style: java
 *   c-basic-offset: 2
 *   eval: (c-set-offset 'statement-cont '0)
 *   eval: (c-set-offset 'substatement-open '0)
 *   eval: (c-set-offset 'case-label '+)
 *   eval: (c-set-offset 'inclass '+)
 *   eval: (c-set-offset 'inline-open '0)
 *   End:
 */
