/******************************************************************************
 *        Copyright Texas Instruments 2004. All Rights Reserved.
 */

/**
 * Test THIF socket in the TX and RX direction.  The test uses some ETS primitives
 * to invoke target-side code to read from or write to a socket, and the 
 * local sut APIs for writing to or reading from the other end of the socket.
 */
public function ThifSocketTest(args...)
  extends pkg.tf.TestCase("THIF Socket Test")
{
  private function toBytes(str)
  {
    var bos = new java.io.ByteArrayOutputStream();
    (new java.io.DataOutputStream(bos)).writeBytes(str);
    return bos.toByteArray();
  }
  
  /**
   * The entry point to the test is this method.
   */
  public function runTest()
  {
    var pattern = [];
    for( var i=0; i<991; i++ )   // use prime # larger than buf size on target
      pattern.push( i & 0xff );
    
    var name = [].concat( toBytes("read") );
    for( var i=name.length(); i<8; i++ )
      name[i] = 0;
    
    rctx.sendPrim( 
      new ETS_THIF_SOCKET_WRITE_REQ(
        /* source ehId */          0x0101,
        name,
        pattern
      ) 
    );
    
    function getSocket(name)
    {
      var sut = services["esf connection mgr"].getConnections().next();
      return sut.openSocket(name);
    }
    
    var s;
    var is;
    var os;
    
    function readFromSocket()
    {
      writeln("starting read");
      s = getSocket("read");
      is = s.getInputStream();
      var val = 0;
      for( var i=0; i<pattern.length(); i++ )
      {
        var b;
        if( (b=(is.read() & 0xff)) != val )
        {
          writeln(i + ": " + b + " vs " + val);
          val = b;
        }
        val = (val+1) & 0xff;
      }
      writeln("done");
    }
    
    readFromSocket();
    
    
    var name = [].concat( toBytes("write") );
    for( var i=name.length(); i<8; i++ )
      name[i] = 0;
    
    var cnf = null;
    
    // register primitive handler for ETS_THIF_SOCKET_READ_CNF:
    addPrimHandler( function(prim) {
      cnf = prim;
    }, rctx.type(ETS_THIF_SOCKET_READ_CNF) );
    
    rctx.sendPrim( new ETS_THIF_SOCKET_READ_REQ(
                     /* source ehId */          0x0101,
                     name,
                     /* patternCount */         991
                   ) );
    
    function writeToSocket()
    {
      writeln("starting write");
      s = getSocket("write");
      os = s.getOutputStream();
      
      for( var i=0; i<pattern.length(); i++ )
        os.write(pattern[i]);
      
      writeln("done");
    }
    
    writeToSocket();
    
    while( cnf == null )
      Thread.sleep(100);
    
    {
      var cnfPattern = cnf.getPattern();
      if( cnfPattern.length() != pattern.length() )
        writeln("output wrong size");
      else for( var i=0; i<pattern.length(); i++ )
        if( cnfPattern[i] != pattern[i] )
          writeln("mismatch at: " + i + ": " + cnfPattern[i] + " vs " + pattern[i]);
    }
    
    // unregister primitive handlers:
    removePrimHandlers();
  }
  
}

