/*=============================================================================
 *     Copyright Texas Instruments, Inc., 2003.  All Rights Reserved.
 */


/**
 * The Padding Rule test sends an ETS_PADDING_TEST_REQ to ETS, which validates
 * that the primitive has been properly encoded for the padding and endianess
 * of the target, and then send back an ETS_PADDING_TEST_CNF at which point 
 * the script performs the same validation to verify the decoding of the
 * primitive.  These primitives are designed to test each different scenario
 * where the compiler inserts padding into the ``C'' struct.
 */
public function PaddingRuleTest(args...)
  extends pkg.tf.TestCase("Padding Rule Test")
{
  /**
   * The entry-point to the test code
   */
  public function runTest()
  {
    var cur = 0;
    
    /**
     * Get the next value in the sequence of values for checking/setting
     * fields in ETS_PADDING_TEST_CNF/ETS_PADDING_TEST_REQ (respectively)
     */
    function getNextVal()
    {
      cur++;
      
      if( (cur <= 0) || (cur >= 256) )
        cur = 1;
      
      return cur;
    }
    
    /**
     * Check that <code>val</code> is the next value in the expected
     * sequence of values... calls logError if it does not match.
     * 
     * @param val  the value to compare to the next in the sequence
     */
    function checkVal(val)
    {
      var expected = getNextVal();
      
      if( val != expected )
        pkg.output.logError();
    }
    
    pkg.output.logInfoMsg("sending ETS_PADDING_TEST_REQ");
    
    var req = new ETS_PADDING_TEST_REQ(
                /* source ehId */          0x0101,
                /* f1 */                   getNextVal(),
                /* f2 */                   getNextVal(),
                /* f3 */                   getNextVal(),
                new ti.th.prim.Ets_EtsEh_PaddingSize1Align1(
                  /* f1 */                 getNextVal()
                ),
                new ti.th.prim.Ets_EtsEh_PaddingSize3Align2(
                  /* f1 */                 getNextVal(),
                  /* f2 */                 getNextVal()
                ),
                new ti.th.prim.Ets_EtsEh_PaddingSize6Align4(
                  /* f1 */                 getNextVal(),
                  /* f2 */                 getNextVal()
                ),
                new ti.th.prim.Ets_EtsEh_PaddingArrSize3Align4(
                  /* f1 */                 getNextVal(),
                  [
                    /* f2[0] */            getNextVal(),
                    /* f2[1] */            getNextVal()
                  ]
                ),
                [
                  new ti.th.prim.Ets_EtsEh_PaddingArrSize3Align4(
                    /* f1 */               getNextVal(),
                    [
                      /* f2[0] */          getNextVal(),
                      /* f2[1] */          getNextVal()
                    ]
                  ),
                  new ti.th.prim.Ets_EtsEh_PaddingArrSize3Align4(
                    /* f1 */               getNextVal(),
                    [
                      /* f2[0] */          getNextVal(),
                      /* f2[1] */          getNextVal()
                    ]
                  )
                ],
                new ti.th.prim.Ets_EtsEh_PaddingStructSize7Align4(
                  /* f1 */                 getNextVal(),
                  new ti.th.prim.Ets_EtsEh_PaddingSize6Align4(
                    /* f1 */               getNextVal(),
                    /* f2 */               getNextVal()
                  )
                ),
                [
                  /* f10[0] */             getNextVal(),
                  /* f10[1] */             getNextVal()
                ]
              );
    
    rctx.sendAndWaitForPrim(
      req,
      function(prim) {
        
        if( prim instanceof ETS_PADDING_TEST_CNF )
        {
          pkg.output.logInfoMsg("received ETS_PADDING_TEST_CNF");
          
          // reset current value:
          cur = 0;
          
          checkVal( prim.getF1() );
          checkVal( prim.getF2() );
          checkVal( prim.getF3() );
          checkVal( prim.getF4().getF1() );
          checkVal( prim.getF5().getF1() );
          checkVal( prim.getF5().getF2() );
          checkVal( prim.getF6().getF1() );
          checkVal( prim.getF6().getF2() );
          checkVal( prim.getF7().getF1() );
          checkVal( prim.getF7().getF2()[0] );
          checkVal( prim.getF7().getF2()[1] );
          checkVal( prim.getF8()[0].getF1() );
          checkVal( prim.getF8()[0].getF2()[0] );
          checkVal( prim.getF8()[0].getF2()[1] );
          checkVal( prim.getF8()[1].getF1() );
          checkVal( prim.getF8()[1].getF2()[0] );
          checkVal( prim.getF8()[1].getF2()[1] );
          checkVal( prim.getF9().getF1() );
          checkVal( prim.getF9().getF2().getF1() );
          checkVal( prim.getF9().getF2().getF2() );
          checkVal( prim.getF10()[0] );
          checkVal( prim.getF10()[1] );
          
          return false;
        }
        else if( prim instanceof ETS_PADDING_TEST_ERROR_IND )
        {
          pkg.output.logInfoMsg("received ETS_PADDING_TEST_ERROR_IND");
          
          pkg.output.logError("error, firstErrorVal: " + prim.getFirstErrorVal());
          return false;
        }
        
      },
      rctx.or( rctx.type(ETS_PADDING_TEST_CNF), rctx.type(ETS_PADDING_TEST_ERROR_IND) )
    );
    
  }
}

