/******************************************************************************
 *        Copyright Texas Instruments 2003. All Rights Reserved.
 */

/**
 * Run a loopback bandwidth test.  This consists of sending a number of
 * <code>ETS_LOOPBACK_REQ</code> primitives, and waiting for the response
 * <code>ETS_LOOPBACK_CNF</code>.  This keeps track of the average amount of
 * time spent waiting for the confirmation primitive, as well as the total 
 * time elapsed in order to generate some bandwidth and latency stats.
 */
public function LoopbackBandwidthTest(args...)
  extends pkg.tf.TestCase("Loopback Bandwidth")
{
  /**
   * The entry point to the test is this method.
   */
  public function runTest()
  {
    pkg.chimera.routing.loopbackTest(   10, 40, 0 );
    pkg.chimera.routing.loopbackTest(  100, 20, 0 );
    pkg.chimera.routing.loopbackTest( 1000, 10, 0 );
  }
}

