@rem ----------------------------------------------------------------------------- 
@rem  Project :  
@rem  Modul   :  initvars.bat
@rem ----------------------------------------------------------------------------- 
@rem  Copyright 2004 Texas Instruments Deutschland GmbH 
@rem                 All rights reserved. 
@rem 
@rem                 This file is confidential and a trade secret of Texas 
@rem                 Instruments Deutschland GmbH.
@rem                 The receipt of or possession of this file does not convey 
@rem                 any rights to reproduce or disclose its contents or to 
@rem                 manufacture, use, or sell anything it may describe, in 
@rem                 whole, or in part, without the specific written consent of 
@rem                 Texas Instruments Deutschland GmbH. 
@rem ----------------------------------------------------------------------------- 
@rem |  Purpose :  Setting environment variables for work on GPF, G23M, UMTS etc. 
@rem ----------------------------------------------------------------------------- 

@if x%_4ver% == x goto Need4NT

@rem At least so many parameters must be given!
@if x%4 == x goto How2Use

@rem Set the project name!
@if x%1 == x goto How2Use
set PROST=%1

@rem Check if the SIDE option is given!
@if x%2 == xMS goto ParametersOK
@if x%2 == xBS goto ParametersOK
@goto How2Use

:ParametersOK

@rem Set the network side as mobile or base station!
set SIDE=%2

@rem Set the drive and directories where sources, test files, word
@rem documents, ccd table files are to find!
set TESTDRIVE=%3
set TESTROOT=%3%4
set GSMDIR=%3%4

@if not exist "C:\iar\ew23\cr16\bin\icccr16.exe" goto setDEV
@set IARDIR=C:/iar/ew23/cr16
set PATH=%PATH%;%IARDIR%/bin;

:setDEV
@rem Drive and Directory for local development!
set DEV=%3%4

@rem set path for Codecheck rules!
set CCRULES=%3%4\TOOLS\CODECHECK\RULES

@rem PROGDIR : where application have been installed.
@if x%5 == x goto notPROGDIR
@set PROGDIR=%5
@goto ProgDirExit

:notPROGDIR

@if not exist "C:\PROGRAMME\Microsoft Office" goto notPROGRAMME
@set PROGDIR=C:\PROGRAMME
@goto ProgDirExit
:notPROGRAMME

@iff exist "C:\PROGRAM FILES\Microsoft Office" then
@set PROGDIR=C:\PROGRAM FILES
@goto ProgDirExit

@else
@goto notPROGRAMMFILES
@endiff

:notPROGRAMMFILES

@echo "Error: cannot set Application Directory"
@goto How2Use


:ProgDirExit


@rem Call VCVARS!
call vcvars32
@set ret= %_?
@if %ret% == 0 goto vcVarsOk
@rem investigating MsDev installations, descending from 7 to 5:
@iff exist "%PROGDIR%\Microsoft Visual Studio .net\vc7" then
call "%PROGDIR%\Microsoft Visual Studio .net\vc7\bin\vcvars32.bat"
@else
@iff exist "%PROGDIR%\Microsoft Visual Studio\VC98" then
call "%PROGDIR%\Microsoft Visual Studio\vc98\bin\vcvars32.bat"
@else
call "%PROGDIR%\DevStudio\vc\bin\vcvars32.bat"
@endiff
@endiff


:vcVarsOk
@iff exist %TESTDRIVE%\gpf then
set GPF=%TESTDRIVE%\gpf
@else
@iff exist %TESTROOT%\..\..\gpf then
set GPF=%TESTROOT%\..\..\gpf
@else
@echo Can't locate your gpf-Directory
@endiff
@endiff

@iff "x%GPF%" != "x" then
@if %@index[%path%,%GPF%\tools\bin;]% LT 0 set PATH=%GPF%\tools\bin;%PATH%;
@if %@index[%path%,%GPF%\bin;]% LT 0 set PATH=%GPF%\bin;%PATH%;

@endiff

@if x%1 == xg23net goto IsG23NET
@if x%1 == xgeneric goto IsGeneric

@rem Drive and directory for release generation!
set TDSDIR=%TESTROOT%\%SIDE%\tds
set TSTDOCDIR=%TESTROOT%\%SIDE%\doc\test
set TSTBINDIR=%TESTROOT%\int\bin

@rem TI Software Development Environment!
set C_OPTION=

@rem Add BIN to PATH!
@if %@index[%path%,%TSTBINDIR;]% LT 0 set PATH=%PATH%;%TSTBINDIR;

@rem This variable will disappear when gprs makefiles do not use it any more!
set GTESTROOT=%TESTROOT%

@rem Set paths for auto code generation!
set CDGINCDIR=%3%4\ms\CDGINC

@goto end

:IsG23NET

@rem set paths for auto code generation:
set CDGINC=%3%4\CDGINC
set PRIMDIR=%3%4\TEMP
set MSGDIR=%3%4\TEMP
set SAPDOCDIR=%3%4\DOC\SAP
set MSGDOCDIR=%3%4\DOC\MSG
set TSTDOCDIR=%3%4\DOC\TEST
set TDSDIR=%3%4\TEMP
set TESTDIR=%3%4\TESTDLL
set BINDIR=%3%4\bin


@rem Set the directory for tools!
set TOOLS=%3%4\TOOLS
@if %@index[%path%,%TOOLS%;]% LT 0 set PATH=%PATH%;%TOOLS%;


:pSOS
@rem Set Envirment for pSOS2.5!
@rem =========================
@rem : install directory of pSOS+ and board support package
@SET ISIX86=C:\ISIX86
set PSS_ROOT=%ISIX86%/pssx86.250
set PSS_BSP=%PSS_ROOT%/bsps/pc
set SNIFF_MAKE_CMD=snf_gnu

set LM_LICENSE_FILE=%ISIX86%\licenses\license.dat
set PATH=%PATH%;%ISIX86%\licenses\bin\win32;%ISIX86%\cadul\bin;%PSS_ROOT%\bin\win32;%PSS_ROOT%\bin\win32\gnu;%ISIX86%\sniff\mks\mks-6.1\mksnt

:---- WindRiver stuff ---------------------------------------------
@echos Adding WindRiver stuff.. 
@set WIND_BASE=
@set WIND_HOST_TYPE=x86-win32
@iff exist c:\tornado then
  set WIND_BASE=c:\tornado
@else
  @for %drive IN (d e f g h i j k l m n o p q r s t u v w x y z) do (
    @iff exist %drive%:\host\%WIND_HOST_TYPE% then
      set WIND_BASE=%drive%:
      echo WIND_BASE is %WIND_BASE% WIND_HOST_TYPE: %WIND_HOST_TYPE%
    endiff
  )
@endiff
@iff "%WIND_BASE%"=="" then
  @echo FAILED !!!
  @echo Connect a network drive to the server installed TORNADO directory.
  @echo Afterwards you should have e.g. T:\host\...
else
rem  set PATH=%WIND_BASE%\host\%WIND_HOST_TYPE%\bin;%PATH%
  set PATH=%PATH%;%WIND_BASE%\host\%WIND_HOST_TYPE%\bin
endiff
:---- End of WindRiver stuff --------------------------------------

@goto end

:IsGeneric

@rem include directotries
set PROSTINCDIR=%3%4\INC
set CDGINCDIR=%3%4\INC\CDGINC

@rem primitive directotries
set SAPDOCDIR=%3%4\SPEC\SAP
set PRIMDIR=%3%4\OBJ\ENTITY\PDF

@rem air message directotries
set MSGDOCDIR=%3%4\SPEC\MSG
set MSGDIR=%3%4\OBJ\ENTITY\MDF

@rem test directotries
set TSTDOCDIR=%3%4\SPEC\TEST
set TDSDIR=%3%4\OBJ\ENTITY\TDS
set TCDIR=%3%4\BIN

@rem those should not be needed anymore
unset GSMDIR

@goto end


:Need4NT
@echo "Error: 4DOS or 4NT is needed
@goto end

:How2Use
@echo "Usage:   initvars <project> <MS|BS> <drive> <path> [<prog dir> | <path>]
@echo "Example1: initvars  gsm         MS  D:  \g23m\Condat `C:\Program Files`
@echo "Example2: initvars  gprs        MS  Z:  \g23m\Condat
@echo "Example3: initvars  g23net      BS  V:  \g23net\Dev  `C:\Program Files`
@echo "Example4: initvars  generic     MS  X:  \gpf\UTIL\TESTSTACK"

:end
quit 0