#-----------------------------------------------------------------------------#
# PROJECT: XPANEL (8446)                $Workfile:: TARGET_csample_mfw_lo.tcl$#
# Author:: RK  CONDAT GmbH              $Revision:: 1                        $#
# CREATED: 29.06.00                     $Modtime:: 16.02.00 15:17            $#
# STATE  : code                                                               #
#-----------------------------------------------------------------------------#

#  MODULE  : CSAMPLE_LAYOUT (mfw/bmi)

#  PURPOSE : This modul provides specific layout file for a csample
#            running a MFW/BMI version.

#*==== CONSTANTS ===================================================*#

# specify text display colors
set DISPL_BG black
set DISPL_FG white

# key count
set COLUMNS 3
set ROWS 7

# key IDs
set KEY_NOKEY     -1
set KEY_0         1
set KEY_1         2 
set KEY_2         3
set KEY_3         4
set KEY_4         5
set KEY_5         6
set KEY_6         7
set KEY_7         8
set KEY_8         9
set KEY_9         10
set KEY_MNUUP     11
set KEY_MNUDOWN   12
set KEY_LEFT      13
set KEY_RIGHT     14
set KEY_CALL      15
set KEY_HUP       16
set KEY_STAR      17
set KEY_HASH      18
set KEY_POWER     19

# not used
set KEY_VOLUP     254
set KEY_VOLDOWN   254
set KEY_OK        254
set KEY_CLEAR     254
set KEY_ABC       254
set KEY_F1        254
set KEY_F2        254
set KEY_F3        254
set KEY_F4        254
set KEY_MAX       254

# keys with their IDs
set KEY_ID { $KEY_LEFT  $KEY_MNUUP    $KEY_RIGHT  
             $KEY_CALL  $KEY_MNUDOWN  $KEY_HUP   
             $KEY_NOKEY $KEY_POWER    $KEY_NOKEY    
             $KEY_1     $KEY_2        $KEY_3    
             $KEY_4     $KEY_5        $KEY_6  
             $KEY_7     $KEY_8        $KEY_9 
             $KEY_STAR  $KEY_0        $KEY_HASH }

# keys with their second IDs, activated after pressing 3 sec
set KEY_ID2 { $KEY_NOKEY  $KEY_NOKEY  $KEY_NOKEY
              $KEY_NOKEY  $KEY_NOKEY  $KEY_POWER
              $KEY_NOKEY  $KEY_NOKEY  $KEY_NOKEY
              $KEY_NOKEY  $KEY_NOKEY  $KEY_NOKEY
              $KEY_NOKEY  $KEY_NOKEY  $KEY_NOKEY
              $KEY_NOKEY  $KEY_NOKEY  $KEY_NOKEY
              $KEY_NOKEY  $KEY_NOKEY  $KEY_NOKEY}

# key labels
set KEY_LABEL {"----"    "/\\"     "----"   
               "CALL"    "\\/"     "HUP"    
               ""        "POWER"   ""    
               "1\nl__l"  "2\nabc" "3\ndef" 
               "4\nghi"  "5\njkl"  "6\nmno" 
               "7\npqrs" "8\ntuv"  "9\nwxyz"
               "*"       "0\n+"    "#"      }

# optional key images instead of labels
set KEY_IMG {""           ""     ""       
             ""           ""     ""       
             ""           ""     ""       
             ""           ""     ""      
             ""           ""     ""     
             ""           ""     ""    
             ""           ""     ""  } 

# key sizes
set KEY_HEIGHT {3  3  3 
                3  3  3
                2  2  2
                2  2  2
                2  2  2
                2  2  2
                2  2  2}

set KEY_WIDTH  {5  5  5
                5  5  5
                0  5  0
                4  4  4
                4  4  4
                4  4  4
                4  4  4}

# key positions
set KEY_STICKY {"" "" "" 
                "" "" "" 
                "" "" ""
                "" "" ""
                "" "" ""
                "" "" ""
                "" "" ""}

# key relief style (raised, sunken, flat, ridge, solid, groove)
set RELIEF  raised



#*==== IMPLEMENTATION ==============================================*#

frame .keys
pack .keys -side bottom -pady 2 -anchor center

for {set q 0} {$q<$ROWS} {incr q} {	
  for {set w 1} {$w<=$COLUMNS} {incr w} {	
    set nr [expr $q*$COLUMNS+$w-1]
    if {[subst [lindex $KEY_ID $nr]] == [subst $KEY_NOKEY]} continue

    set key [format ".keys.no%s" $nr] 
    set imgFile [lindex $KEY_IMG $nr]
    if {$imgFile == ""} {
      button $key \
        -text [lindex $KEY_LABEL $nr] \
        -width [lindex $KEY_WIDTH $nr] -height [lindex $KEY_HEIGHT $nr] \
        -relief $RELIEF
    } else {
      set img [format "%s%s" $imgFile $nr]
      image create photo $img -file $imgFile
      button $key -image $img \
        -relief $RELIEF
#        -width [expr 7*[lindex $KEY_WIDTH $nr]] \
#        -height [expr 13*[lindex $KEY_HEIGHT $nr]] \
    }
    set st [lindex $KEY_STICKY $nr]
    if {$st == ""} {
      if {$w == 1} {
        set st w
      }  
      if {$w == $COLUMNS} {
        set st e
      }
    }
    grid $key -row $q -column $w -sticky $st

    if {[subst [lindex $KEY_ID2 $nr]] == [subst $KEY_NOKEY]} {
      set cmd [format "c_onkey %s 0" [subst [lindex $KEY_ID $nr]]]
    } else {
      set cmd [format "c_onkey %s 0 %s" [subst [lindex $KEY_ID $nr]] \
                                        [subst [lindex $KEY_ID2 $nr]]]
    }
    bind $key <ButtonPress> $cmd
    set cmd [format "c_onkey %s 1" [subst [lindex $KEY_ID $nr]]]
    bind $key <ButtonRelease> $cmd
  }
}
