@echo off
rem --------------------------------------------------------------------------- 
rem  Project :  
rem  Modul   : globs.bat 
rem --------------------------------------------------------------------------- 
rem  Copyright 2002 Texas Instruments Berlin, AG 
rem                 All rights reserved. 
rem 
rem                 This file is confidential and a trade secret of Texas 
rem                 Instruments Berlin, AG 
rem                 The receipt of or possession of this file does not convey 
rem                 any rights to reproduce or disclose its contents or to 
rem                 manufacture, use, or sell anything it may describe, in 
rem                 whole, or in part, without the specific written consent of 
rem                 Texas Instruments Berlin, AG. 
rem --------------------------------------------------------------------------- 
rem  Purpose : Find out the amount of memory needed for a globs strucure.
rem --------------------------------------------------------------------------- 

rem arm7 no Trace
if exist ccd.asm del /q ccd.asm > nul
echo Memory needed for an entity requiring reentrancy for CCD (in Bytes)...
gnumake -r -C .. ASM_ONLY=1 TARGET=nuc PLATFORM=arm7 DEBUG=1 MEMSUPER=1 TRACE=0 OBJDIR=%_CWD% ccd.asm > nul
iff %? != 0 then
  echo Can't generate ccd.asm 
  goto error
endiff
echos - for a non-tracing CCD on ARM7:
echos ^s^s
grep globs_all ccd.asm | grep .bss | gawk -F, "{ print $2 } "

rem arm7 Trace
del /q ccd.asm > nul
gnumake -r -C .. ASM_ONLY=1 TARGET=nuc PLATFORM=arm7 DEBUG=1 MEMSUPER=1 TRACE=1 OBJDIR=%_CWD% ccd.asm > nul
iff %? != 0 then
  echo Can't generate ccd.asm 
  goto error
endiff

echos - for a     tracing CCD on ARM7:
echos ^s^s
grep globs_all ccd.asm | grep .bss | gawk -F, "{ print $2 } "
del /q ccd.asm > nul

rem arm9 no Trace
if exist ccd.asm del /q ccd.asm > nul
gnumake -r -C .. ASM_ONLY=1 TARGET=nuc PLATFORM=arm9 DEBUG=1 MEMSUPER=1 TRACE=0 OBJDIR=%_CWD% ccd.asm > nul
iff %? != 0 then
  echo Can't generate ccd.asm 
  goto error
endiff
echos - for a non-tracing CCD on ARM9:
echos ^s^s
grep globs_all ccd.asm | grep .bss | gawk -F, "{ print $2 } "

rem arm9 Trace
del /q ccd.asm > nul
gnumake -r -C .. ASM_ONLY=1 TARGET=nuc PLATFORM=arm9 DEBUG=1 MEMSUPER=1 TRACE=1 OBJDIR=%_CWD% ccd.asm > nul
iff %? != 0 then
  echo Can't generate ccd.asm 
  goto error
endiff

echos - for a     tracing CCD on ARM9:
echos ^s^s
grep globs_all ccd.asm | grep .bss | gawk -F, "{ print $2 } "
del /q ccd.asm > nul

:foo
rem pc no Trace
if exist pc_globs.exe del /q pc_globs.exe > nul
if exist pc_globs.obj del /q pc_globs.obj > nul
gnumake -r -C .. GLOBS=1 TARGET=nuc PLATFORM=pc DEBUG=1 MEMSUPER=1 TRACE=0 OBJDIR=%@NAME[%_CWD%] > nul
iff %? != 0 then
  echo Can't generate pc_globs
  goto error
endiff

echos - for a non-tracing CCD on PC:
echos ^s^s^s^s
pc_globs

rem pc Trace
del /q pc_globs.exe pc_globs.obj > nul
gnumake -r -C .. GLOBS=1 TARGET=nuc PLATFORM=pc DEBUG=1 MEMSUPER=1 TRACE=1 OBJDIR=%@NAME[%_CWD%] > nul
iff %? != 0 then
  echo Can't generate pc_globs
  goto error
endiff

echos - for a     tracing CCD on PC:
echos ^s^s^s^s
pc_globs

del /q pc_globs.exe pc_globs.obj > nul
:error
