/*
+-----------------------------------------------------------------------------
|  Project :  G23NET
|  Modul   :  freq_fun.h
+-----------------------------------------------------------------------------
|  Copyright 1999-2001 Condat AG
|                 All rights reserved.
|
|                 This file is confidential and a trade secret of Condat AG
|                 The receipt of or possession of this file does not convey
|                 any rights to reproduce or disclose its contents or to
|                 manufacture, use, or sell anything it may describe, in
|                 whole, or in part, without the specific written consent of
|                 Condat AG.
+-----------------------------------------------------------------------------
|  Purpose :  This file provides functions for coding and decoding frequency lists
|
+-----------------------------------------------------------------------------
*/
typedef unsigned char UBYTE;

extern int explain;            /* activate tracing */

/* 
 * prototypes
 */

/*
 * rr_freq_decode decodes a information element with a frequency list
 * ignoring bits with different meaning for different IEs and delivers
 * a list ARFCNs
 *
 * ie   in:  address of FORMAT-ID (octet 3) of IE to decode; there were always
 *           decoded 16 Bytes
 * freq out: address of decoded frequency list
 * *c_f out: address of number of decoded frequencies 
 *
 * return value TRUE if FORMAT_ID decoded as bit map0, variable bit map or 
 *              one of the ranges 1024, 512, 256, 128
 *              FALSE otherwise
 */
USHORT rr_freq_decode(USHORT *freq, USHORT *c_f, UBYTE *ie);

/*
 * rr_freq_encode encodes one, two or three information elements with frequency lists
 * bits with different meanings for different IEs are handled as spares
 *
 * freq_l in: address of a sorted list of ARFCNs without copies
 * c_f    in: number of frequencies
 * ie1    in: address of (first) information element to code into
 * ie2    in: address of second information element to code into or NULL
 * ie3    in: address of third information element to code into or NULL
 *
 * return value 0 coding isn't possible
 *              1 the list of frequencies is coded in ie1 
 *              2 the list of frequencies is coded in ie1 and ie2 together 
 *              3 the list of frequencies is coded in ie1, ie2 and ie3 together 
 */
USHORT rr_freq_encode(USHORT *freq_l, USHORT c_f, UBYTE *ie1, UBYTE *ie2, UBYTE *ie3);

/* 
 * function to produce tracing information
 * tracing may switched on or off by setting the variable explain to TRUE or FALSE
 */
void print_txt(char *fmt, ...);
