/*
+-----------------------------------------------------------------------------
|  Project :  G23NET
|  Modul   :  dich.h
+-----------------------------------------------------------------------------
|  Copyright 2000-2001 Condat AG
|                 All rights reserved.
|
|                 This file is confidential and a trade secret of Condat AG
|                 The receipt of or possession of this file does not convey
|                 any rights to reproduce or disclose its contents or to
|                 manufacture, use, or sell anything it may describe, in
|                 whole, or in part, without the specific written consent of
|                 Condat AG.
+-----------------------------------------------------------------------------
|  Purpose :  Test of Dichotomy algorithms
+-----------------------------------------------------------------------------
*/

#define SHORT  short int

#define DICH_RANGE_1024    1024
#define DICH_RANGE_512     512
#define DICH_RANGE_256     256
#define DICH_RANGE_128     128

extern int op_mod ( int x, int y );

/*
+------------------------------------------------------------------------------
|  Function    : rr_dichotomy_encode
+------------------------------------------------------------------------------
|  Description :  The encoding part of the dichotomy algorithm.
|                 On return w[0] contains 'ORIG-ARFCN' (format 128, 256, 512)
|                   or the 'frequency F0 indicator' (format 1024).
|                   The 'frequency F0 indicator' is either
|                   0  if F0 is not part of the frequency set or
|                   -1 if F0 is     part of the frequency set.
|                 The other w's contain the W(i) (refer description of 
|                 rr_dichotomy_encode_rec)
|
|                 The array 'w' should have a size of at least nf+1 elements.
|                 The array 'f' should have a size of at least 2*nf+1 elements.
|
|  Parameters  :  f                - the frequencies   (refer 'Description:')
|                 c_f              - number of frequencies, maximum is NF_MAX.
|                 w                - the W(i)s 
|                 c_w              - pointer the number of 'w's is written to
|                 fmt              - the used encoding format
|
|  Return      :  number of elements in w
|
+------------------------------------------------------------------------------
*/

extern USHORT rr_dichotomy_encode ( USHORT *f, USHORT c_f, USHORT *w, USHORT *c_w, USHORT fmt );

/*
+------------------------------------------------------------------------------
|  Function    : rr_dichotomy_decode
+------------------------------------------------------------------------------
|  Description :  The decoding part of the dichotomy algorithm.
|                 The algorithm is described in GSM 04.08 Annex J and 
|                 e. g. in section 10.5.1.13
|
|  Parameters  :  f                - the frequencies
|                 c_f              - pointer the number of frequencies is written to
|                 w                - the encoded W(i)s 
|                 c_w              - number of elements in 'w'
|                 fmt              - the used decoding format
|
|  Return      :  number of elements in f
|
+------------------------------------------------------------------------------
*/

extern USHORT rr_dichotomy_decode ( USHORT *f, USHORT *c_f, USHORT *w, USHORT c_w, USHORT fmt );

/*
+------------------------------------------------------------------------------
|  Function    : rr_dich_range_to_ncell_fmt
+------------------------------------------------------------------------------
|  Description :  conversion
|
|  Parameters  :  a DICH_RANGE_* constant
|
|  Return      :  a NCELL_FMT_* constant
|
+------------------------------------------------------------------------------
*/

extern USHORT rr_dich_range_to_ncell_fmt ( USHORT range );
