@echo off
iff x%RUNALLTC_NO_SETLOCAL% == x then
  setlocal
endiff
loadbtm on
rem --------------------------------------------------------------------------- 
rem  Project :  
rem  Modul   : runalltc.bat
rem --------------------------------------------------------------------------- 
rem  Copyright 2002 Texas Instruments Berlin, AG 
rem                 All rights reserved. 
rem 
rem                 This file is confidential and a trade secret of Texas 
rem                 Instruments Berlin, AG 
rem                 The receipt of or possession of this file does not convey 
rem                 any rights to reproduce or disclose its contents or to 
rem                 manufacture, use, or sell anything it may describe, in 
rem                 whole, or in part, without the specific written consent of 
rem                 Texas Instruments Berlin, AG. 
rem --------------------------------------------------------------------------- 
rem   Purpose : Runs all test cases belonging to a given test specification
rem --------------------------------------------------------------------------- 
pushd
if x%_4ver% == x goto Need4NT

rem Check %PROST
iff x%PROST == x then
echo Which Protocol Stack shall be tested?
echo set the environment variable PROST to the name of the stack.
echo e.g. set PROST=gsm or set PROST=g23net will work
goto end
endiff

iff %PROST == gprs then
  iff x%PS_EXE% == x then
    set rtc_psexe=%TESTROOT%\ms\bin\g23_smi_gprs.exe
  else
    set rtc_psexe=%PS_EXE%
  endiff
elseiff %PROST == gsm then
  iff x%PS_EXE% == x then
    set rtc_psexe=%TESTROOT%\ms\bin\MS_TI_VC.exe
  else
    set rtc_psexe=%PS_EXE%
  endiff
elseiff %PROST% == g23net .OR. %PROST% == g23n then
  iff x%PS_EXE% == x then
    set rtc_psexe=%TESTROOT%\bin\nucwin\g23net.exe
  else
    set rtc_psexe=%PS_EXE%
  endiff
elseiff %PROST% == generic then
  iff x%PS_EXE% == x then
    set rtc_psexe=%TESTROOT%\bin\teststack.exe
  else
    set rtc_psexe=%PS_EXE%
  endiff
else
  text
  Unknown project. Set environment variable PROST to gsm, gprs, g23net,
    or generic (i.e. use \GPF\initvars.bat).
  endtext
  goto end
endiff

set rtc_tcfailed=0
set ret_iboe=0
set tc_firsttc=
set tc_lasttc=
set rtc_tappara=
set rtc_oldtappara=H
set rtc_pspara=/INV
set rtc_summary=0
set rtc_tee=
set rtc_delay=5
set rtc_tapexe=
set rtc_bindir=%GPF%/BIN
set rtc_showtrc=0
set rtc_pcolog=1
set rtc_startstack=1
set rtc_starttst=1
set rtc_exitsoon=0
set rtc_testenv=unknown
set rtc_allin1=0
set rtc_exec_suites=0
set rtc_exec_tc=1
set rtc_suifilehdl=-1
set rtc_doasif=0
set rtc_enti=
set rtc_prefix=
set rtc_rangeset=0
set rtc_blacklist=
set rtc_retry=0
set rtc_try=0
set rtc_tap_exitcode=
set rtc_tccount=0
set rtc_tc_executed=
set rtc_echo=
set rtc_case=
set rtc_monthlist=Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec
set rtc_enverror=Can't mix option -oe with -n, -b, -v, -e, -pcon, -oth, -notst, -wtmo, -stmo, -l, -ctb, -cr, -pref or -q

:check_options
rem Check Parameters
if "x%1" == "x" goto How2Use
iff "%1" == "-debug" then
  echo on
  shift 1
  goto check_options
elseiff "%1" == "-r" then
  if "x%2" == "x" (echo Missing range for "-r" & goto How2Use)
  set tc_dash=%@INDEX[%2,-]
  iff %tc_dash == -1 then
    set tc_firsttc=%2
    set tc_lasttc=%2
  else
    set tc_firsttc=%@INSTR[0,%tc_dash,%2]
    set tc_lasttc=%@SUBSTR[%2,%@eval[1+%tc_dash%]]
  endiff
  set rtc_rangeset=1
  shift 2
  goto check_options
elseiff "%1" == "-t" then
  if "x%2" == "x" (echo Missing name of tap-exe for "-t" & goto How2Use)
  set rtc_tapexe=%2
  shift 2
  goto check_options
elseiff "%1" == "-b" then
  iff %rtc_testenv% == old then
    echo Error: %rtc_enverror%
    goto How2Use
  endiff
  set rtc_testenv=new
  if "x%2" == "x" (echo Missing name of bin directory for "-b" & goto How2Use)
  set rtc_bindir=%2
  shift 2
  goto check_options
elseiff "%1" == "-p" then
  if "x%2" == "x" (echo Missing name of ps-exe for "-p" & goto How2Use)
  set rtc_psexe=%2
  shift 2
  goto check_options
elseiff "%1" == "-n" then
  iff %rtc_testenv% == old then
    echo Error: %rtc_enverror%
    goto How2Use
  endiff
  set rtc_doasif=1
  set rtc_testenv=new
  set rtc_pcolog=0
  set rtc_tappara=%rtc_tappara% %1 -v
  set rtc_startstack=0
  shift 1
  goto check_options
elseiff "%1" == "-q" then
  iff %rtc_testenv% == old then
    echo Error: %rtc_enverror%
    goto How2Use
  endiff
  set rtc_testenv=new
  set rtc_pcolog=0
  shift 1
  goto check_options
elseiff "%1" == "-s" then
  set rtc_exec_suites=1
  set rtc_exec_tc=0
  shift 1
  goto check_options
elseiff "%1" == "+s" then
  set rtc_exec_suites=1
  shift 1
  goto check_options
elseiff "%1" == "-st" then
  set rtc_oldtappara=T
  set rtc_showtrc=1
  shift 1
  goto check_options
elseiff "%1" == "-sp" then
  set rtc_pspara=
  shift 1
  goto check_options
elseiff "%1" == "-ib" then
  set rtc_iboe=1
  shift 1
  goto check_options
elseiff "%1" == "-e" then
  iff %rtc_testenv% == old then
    echo Error: %rtc_enverror%
    goto How2Use
  endiff
  set rtc_testenv=new
  if "x%2" == "x" (echo Missing name of entity for "-e" & goto How2Use)
  set rtc_tappara=%rtc_tappara% %1 %2
  set rtc_enti=%2
  shift 2
  goto check_options
elseiff "%1" == "-pref" then
  iff %rtc_testenv% == old then
    echo Error: %rtc_enverror%
    goto How2Use
  endiff
  set rtc_testenv=new
  if "x%2" == "x" (echo Missing prefix of entity for "-pref" & goto How2Use)
  set rtc_prefix=%2
  shift 2
  goto check_options
elseiff "%1" == "-echo" then
  set rtc_echo=echo
  set rtc_startstack=0
  set rtc_pcolog=0
  set rtc_starttst=0
  shift 1
  goto check_options
elseiff "%1" == "-pcon" then
  iff %rtc_testenv% == old then
    echo Error: %rtc_enverror%
    goto How2Use
  endiff
  set rtc_testenv=new
  set rtc_tappara=%rtc_tappara% -pcon
  shift 1
  goto check_options
elseiff "%1" == "-ctb" then
  iff %rtc_testenv% == old then
    echo Error: %rtc_enverror%
    goto How2Use
  endiff
  set rtc_testenv=new
  set rtc_tappara=%rtc_tappara% -ctb
  shift 1
  goto check_options
elseiff "%1" == "-cr" then
  iff %rtc_testenv% == old then
    echo Error: %rtc_enverror%
    goto How2Use
  endiff
  set rtc_testenv=new
  set rtc_tappara=%rtc_tappara% -cr
  shift 1
  goto check_options
elseiff "%1" == "-oth" then
  iff %rtc_testenv% == old then
    echo Error: %rtc_enverror%
    goto How2Use
  endiff
  set rtc_testenv=new
  set rtc_tappara=%rtc_tappara% -oth
  shift 1
  goto check_options
elseiff "%1" == "-v" then
  iff %rtc_testenv% == old then
    echo Error: %rtc_enverror%
    goto How2Use
  endiff
  set rtc_testenv=new
  set rtc_tappara=%rtc_tappara% -v
  shift 1
  goto check_options
elseiff "%1" == "-sum" then
  set rtc_summary=1
  shift 1
  goto check_options
elseiff "%1" == "-notst" then
  iff %rtc_testenv% == old then
    echo Error: %rtc_enverror%
    goto How2Use
  endiff
  set rtc_starttst=0
  shift 1
  goto check_options
elseiff "%1" == "-nop" then
  set rtc_startstack=0
  shift 1
  goto check_options
elseiff "%1" == "-d" then
  if "x%2" == "x" (echo Missing delay for "-d" & goto How2Use)
  set rtc_delay=%2
  shift 2
  goto check_options
elseiff "%1" == "-c" then
  if "x%2" == "x" (echo Missing name for "-c" & goto How2Use)
  set rtc_case=%2
  shift 2
  goto check_options
elseiff "%1" == "-retry" then
  if "x%2" == "x" (echo Missing repetitions for "-retry" & goto How2Use)
  set rtc_retry=%2
  shift 2
  goto check_options
elseiff "%1" == "-stmo" then
  iff %rtc_testenv% == old then
    echo Error: %rtc_enverror%
    goto How2Use
  endiff
  set rtc_testenv=new
  if "x%2" == "x" (echo Missing timeout for "-stmo" & goto How2Use)
  set rtc_tappara=%rtc_tappara% -tsync %@eval[%2*1000]
  shift 2
  goto check_options
elseiff "%1" == "-l" then
  iff %rtc_testenv% == old then
    echo Error: %rtc_enverror%
    goto How2Use
  endiff
  set rtc_testenv=new
  if "x%2" == "x" (echo Missing ccddata_dll for "-l" & goto How2Use)
  if NOT exist %2 (echo %2 not found & goto end)
  set rtc_tappara=%rtc_tappara% -l %@FULL[%2]
  shift 2
  goto check_options
elseiff "%1" == "-wtmo" then
  iff %rtc_testenv% == old then
    echo Error: %rtc_enverror%
    goto How2Use
  endiff
  set rtc_testenv=new
  if "x%2" == "x" (echo Missing timeout for "-wtmo" & goto How2Use)
  set rtc_tappara=%rtc_tappara% -t %@eval[%2*1000]
  shift 2
  goto check_options
elseiff "%1" == "-tp" then
  shift
:tap_param  
  iff x"%1" == x"" then
    goto How2use
  elseiff "%1" == "--" then
    shift
    goto check_options
  else
    set rtc_tappara=%rtc_tappara% %1
    shift
    goto tap_param
  endiff
elseiff "%1" == "-oe" then
  iff %rtc_testenv% == new then
    echo Error: %rtc_enverror%
    goto How2Use
  endiff
  set rtc_testenv=old
  shift 1
  goto check_options
elseiff "%1" == "-xf" then
  if "x%2" == "x" (echo Missing file for "-xf" & goto How2Use)
  set rtc_blacklist=%2
  shift 2
  goto check_options
endiff

iff %rtc_testenv% == unknown then
  iff "x%rtc_tapexe%" == "x" then
    iff exist %GPF%\BIN\tap2_%PROST%.exe then
      set rtc_tapexe=%GPF%\BIN\tap2_%PROST%.exe
      set rtc_testenv=old
    else
      set rtc_tapexe=tap2.exe
      set rtc_testenv=new
    endiff
  else
    iff %@INDEX[%rtc_tapexe%,%PROST%] == -1 then
      set rtc_testenv=new
    else
      set rtc_testenv=old
    endiff
  endiff
  echo Guess %rtc_testenv test environment
else
  iff %rtc_testenv% == new then
    iff "x%rtc_tapexe%" == "x" then
      set rtc_tapexe=tap2.exe
    endiff 
  else
    iff "x%rtc_tapexe%" == "x" then
      set rtc_tapexe=%GPF%\BIN\tap2_%PROST%.exe
    endiff 
  endiff
  echo Use %rtc_testenv test environment
endiff

iff %rtc_testenv% == new .AND. %rtc_showtrc == 1 then
  echo Option -st is not supported in this version for new test environment
  set rtc_showtrc=0
endiff

if "%@INSTR[0,1,%1]" == "-" goto unknown_option
if %#% GT 1 goto How2Use

set rtc_localdir=%_CWD
if %rtc_testenv% == new cdd %rtc_bindir%

iff NOT exist %rtc_tapexe% then
  echo %rtc_tapexe%: not found
  goto end
endiff
iff NOT exist %rtc_psexe% .AND. %rtc_startstack% != 0 then
  echo %rtc_psexe%: not found
  goto end
endiff
set rtc_psexe=%@FULL[%rtc_psexe%]

set ENTI=%1
if x"%rtc_enti%" == x"" set rtc_enti=%ENTI%
if x"%rtc_prefix%" == x"" set rtc_prefix=%ENTI%

rem Stack-Specifics
iff "x%TCDIR%" == "x" then
  iff "%PROST" == "WARP" then
    set TCDIR=%BINDIR%
  else
    set TCDIR=%TESTROOT%\%SIDE%\TEST
  endiff
endiff

%TESTDRIVE%

rem check if test case directory is substructured
iff "x%TCNOTSUBSTRUCT" == "x" then
  set TESTDLLDIR=%TCDIR%\%ENTI%_test
  iff NOT exist %TESTDLLDIR%\*.dll then
    set TESTDLLDIR=%TCDIR%\TEST_%ENTI%
  endiff
else
  set TESTDLLDIR=%TCDIR%
endiff

iff NOT exist %TESTDLLDIR% then
  echo %TESTDLLDIR% does not exist
  goto end
endiff

rem check for blacklist
iff "x%rtc_blacklist%" != "x" then
  iff %@INSTR[0,1,%rtc_blacklist%] == \ .OR. %@INSTR[1,1,%rtc_blacklist%] == : then
    iff exist %rtc_blacklist% then
        set rtc_blacklist=%@FULL["%rtc_blacklist%"]
    else
      echo Cannot open %rtc_blacklist%
      goto end
    endiff
  elseiff %@INDEX[%rtc_blacklist%,\] != -1 then
    iff exist %rtc_localdir%\%rtc_blacklist% then
      set rtc_blacklist=%rtc_localdir%\%rtc_blacklist%
    else
      echo Cannot open %rtc_blacklist%
      goto end
    endiff
  else
      iff exist %rtc_localdir%\%rtc_blacklist% then
        set rtc_blacklist=%rtc_localdir%\%rtc_blacklist%
      elseiff exist %TESTDLLDIR%\%rtc_blacklist% then
        set rtc_blacklist=%TESTDLLDIR%\%rtc_blacklist%
      elseiff exist %TCDIR%\%rtc_blacklist% then
        set rtc_blacklist=%TCDIR%\%rtc_blacklist%
      else
        echo Cannot open %rtc_blacklist%
        goto end
      endiff
  endiff
endiff

iff %rtc_testenv% == new then
  set rtc_tappara=%rtc_tappara% -tb %ENTI%
  set tcerr=TEST_TAP.prt
else
  cdd %TESTDLLDIR%
  set tcerr=Test_%ENTI%.prt
endiff

iff NOT exist %TESTDLLDIR%\*.dll then
  echo no testcases in %TESTDLLDIR%
  goto end
endiff

set grep=%GPF%\tools\bin\grep.exe
iff NOT exist %grep% then
  echo You need %grep% to execute runalltc
  goto end
endiff
set clickbtn=%GPF%\BIN\clickbtn.exe
iff NOT exist %clickbtn% then
  echo You need %clickbtn% to execute runalltc
  goto end
endiff
iff exist %TESTDLLDIR%\%ENTI%.dll .AND. %rtc_exec_tc% == 1 then
  set rtc_allin1=1
  set gawk=%GPF%\tools\bin\gawk.exe
  iff NOT exist %gawk% then
    echo You need %gawk% to run allin1 tests
    goto end
  endiff
  set dumpbin=%@SEARCH[dumpbin.exe]
  iff NOT exist %dumpbin% then
    echo You need dumpbin.exe to run allin1 tests
    goto end
  endiff
  set rtc_expfile=%TESTDLLDIR%\%ENTI%_exp.txt
  "%dumpbin%" /EXPORTS %TESTDLLDIR%\%ENTI%.dll | %gawk% "/ +[0-9]+ +[0-9A-F]+ [0-9A-F]+ %@UPPER[%rtc_prefix%]/ {print $4}" > %rtc_expfile%
endiff
iff %rtc_exec_suites% == 1 .AND. %rtc_allin1% != 1 then
  set gawk=%GPF%\tools\bin\gawk.exe
  iff NOT exist %gawk% then
    echo You need %gawk% to run suites
    goto end
  endiff
endiff
rem Check ranges
iff %rtc_exec_tc% == 1 then
  iff %rtc_allin1% == 1 then
    set rtc_filehdl=%@FILEOPEN[%rtc_expfile%,read]
    set tc_exmp=%@FILEREAD[%rtc_filehdl%]
    set tcase=%tc_exmp
  else
    set tc_exmp_=%@FINDFIRST[%TESTDLLDIR%\*.dll]
    set tc_exmp=%@NAME[%tc_exmp_]
    set tc_exmp_=%@FINDCLOSE[%TESTDLLDIR%\*.dll]
  endiff
  set tc_ords=%@SUBSTR[%tc_exmp,%@LEN[%rtc_prefix%]]
  set tc_len=%@LEN[%tc_ords]
  if %@NUMERIC[%tc_ords] == 0 set tc_len=%@DEC[%tc_len%]
  iff x%tc_firsttc% == x then
    iff %tc_len% == 5 then
      set tc_firsttc=00000
    elseiff %tc_len% == 4 then
      set tc_firsttc=0000
    else
      set tc_firsttc=000
    endiff
  else
    set tc_len_=%@LEN[%tc_firsttc]
    if %@NUMERIC[%tc_firsttc] == 0 set tc_len_=%@DEC[%tc_len_%]
    if %tc_len != %tc_len_ echo Warning: your range "%tc_firsttc" is ambigious (there are not only %tc_len_%-digit test cases)
  endiff
  iff x%tc_lasttc == x then
    iff %tc_len% == 5 then
      set tc_lasttc=99999Z
    elseiff %tc_len% == 4 then
      set tc_lasttc=9999Z
    else
      set tc_lasttc=999Z
    endiff
  else
    set tc_len_=%@LEN[%tc_lasttc]
    if %@NUMERIC[%tc_lasttc] == 0 set tc_len_=%@DEC[%tc_len_%]
    if %tc_len != %tc_len_ echo Warning: your range "%tc_lasttc" is ambigious (there are not only %tc_len_%-digit test cases)
endiff
endiff

iff %rtc_summary% == 1 then
  set rtc_sumfile=%@FULL[%ENTI%.txt]
  echo Start testing of %ENTI% on %@WORD[%@DEC[%_MONTH],%rtc_monthlist%] %_DAY% %_YEAR% at %_TIME >%rtc_sumfile%
  set rtc_tee=%=|tee /a %rtc_sumfile%
endiff

on break gosub on_break

iff %rtc_exec_suites% == 1 .AND. not exist %TESTDLLDIR%\%ENTI%.sui then
  echo No suites file %TESTDLLDIR%\%ENTI%.sui
  set rtc_exec_suites=0
  if %rtc_exec_tc% == 0 goto end
endiff

iff %rtc_testenv% == new .AND. %rtc_starttst == 1 then
  start /MIN tst sim
  delay 2
  iff %rtc_pcolog% == 1 then
    start /MIN /LOW pco_srv
    delay 2
  else
    set rtc_showtrc=0
  endiff
  rem iff %rtc_showtrc% == 1 then
    rem start /LOW pco_view.exe
  rem endiff
endiff

iff x"%rtc_case" != x"" then
  set tcase=%rtc_case%
  gosub run_test
  goto epilogue
endiff

iff %rtc_exec_tc% == 1 then
  iff %rtc_allin1% == 1 then
    do while %tcase% != **EOF**
      gosub run_test
      iff %rtc_tcfailed% == 1 then
        echo Testcase failed: exiting.
        goto end
      endiff
      iff %rtc_tap_exitcode% == 8 .AND. %rtc_retry% != 0 then
        set rtc_try=%@INC[%rtc_try%]
        if %rtc_try% LE %rtc_retry% ITERATE
        iff %rtc_tccount% == 0 then
          echo Stack synchronization error on 1. test case in %rtc_try% retries - giving up %rtc_tee%
          goto epilogue
        endiff
      endiff
      if %rtc_exitsoon% == 1 goto epilogue
      set tcase=%@FILEREAD[%rtc_filehdl%]
      set rtc_try=0
      if %rtc_tc_executed% == 1 set rtc_tccount=%@INC[%rtc_tccount%]
    enddo
  else
    FOR %tcase IN (%TESTDLLDIR%\*.dll) do (
      gosub run_test
      iff %rtc_tcfailed% == 1 then
        echo Testcase failed: exiting.
        goto end
      endiff
      if %rtc_exitsoon% == 1 goto epilogue
    )
  endiff
endiff

iff %rtc_exec_suites% == 1 then
  set rtc_suilist=%TESTDLLDIR%\%ENTI%_sui_list.txt
  set sed=%GPF%\tools\bin\sed.exe
  iff NOT exist %sed% then
    echo You need %sed% to execute suites with runalltc
    goto end
  endiff
  gosub mk_sui_list
  iff %@FILESIZE[%rtc_suilist%,b] == 0 then
    echo No suites in %TESTDLLDIR%\%ENTI%.sui
    goto epilogue
  endiff
  set rtc_suifilehdl=%@FILEOPEN[%rtc_suilist%,read]
  set tcase=#%@FILEREAD[%rtc_suifilehdl%]
  do while %tcase% != #**EOF**
    gosub run_test
    if %rtc_exitsoon% == 1 goto epilogue
    set tcase=#%@FILEREAD[%rtc_suifilehdl%]
  enddo
endiff
goto epilogue

:mk_sui_list
%grep% "SUI_.*:" %TESTDLLDIR%\%ENTI%.sui | %sed% -e "s/\(SUI_[a-zA-Z0-9_]*\):/\1/g" | %gawk% -- " /SUI_/ {print $1 } " > %rtc_suilist%
return

:epilogue
iff %rtc_testenv% == new then
  iff %rtc_pcolog% == 1 then
    pcoc exit > nul
    delay 2
    pkill pco_srv > nul
    rem pkill pco_view > nul
  endiff
  if %rtc_starttst == 1 pkill tst > nul
  iff %rtc_summary% == 1 then
    echo End testing of %ENTI% on %@WORD[%@DEC[%_MONTH],%rtc_monthlist%] %_DAY% %_YEAR% at %_TIME >>%rtc_sumfile%
    move /q %rtc_sumfile% %TESTDLLDIR%
  endiff
  iff %rtc_allin1% == 1 then
    set rtc_filehdl=%@FILECLOSE[%rtc_filehdl%]
    del /q %rtc_expfile%
  endiff
  iff %rtc_exec_suites% == 1 then
    if %rtc_suifilehdl% != -1 set rtc_suifilehdl=%@FILECLOSE[%rtc_suifilehdl%]
    del /q %rtc_suilist%
  endiff
endiff

goto end

:run_test
iff %@INSTR[0,1,%tcase%] == #  then
  set rtc_issuite=#
  set tcase=%@SUBSTR[%tcase%,1]
else
  set rtc_issuite=
endiff
set tcname=%@NAME[%tcase]
set tc_ords=%@SUBSTR[%tcname,%@LEN[%rtc_prefix%]]
iff %rtc_rangeset% == 0 then
  set rtc_inrange=1
else iff %tc_ords% GE %tc_firsttc% .AND. %tc_ords% LE %tc_lasttc% then
  set rtc_inrange=1
else
  set rtc_inrange=0
endiff
iff %rtc_inrange% == 1 .AND.  "x%rtc_blacklist%" != "x" then
  %grep% -w %tcname% %rtc_blacklist% > nul
  iff %? == 0 then
    set rtc_inrange=0
    echo Test case %tcname% excluded by %rtc_blacklist% %rtc_tee%
  endiff
endiff
set rtc_tc_executed=0
iff x%rtc_issuite% == x#  .OR. %rtc_inrange == 1 then
  iff x"%rtc_echo%" == x"" .AND. not exist %TESTDLLDIR%\%tcname% then
    mkdir %TESTDLLDIR%\%tcname%
  endiff
  iff %rtc_testenv% == new then
    rem start /MIN tst sim
    rem delay 2
    iff %rtc_pcolog% == 1 then
      pcoc spath %TESTDLLDIR%\%tcname% > nul
      pcoc start %tcname% > nul
    endiff
    rem iff %rtc_showtrc% == 1 then
      rem start /LOW pco_view.exe
      rem delay 2
    rem endiff
  else
    cd %tcname%
  endiff
  iff %rtc_startstack% == 1 then
    start %rtc_pspara% %rtc_psexe%
    delay  %rtc_delay%
  endiff
  iff %rtc_testenv% == new then
    iff "%rtc_doasif%" == "1" then 
      %rtc_echo% %rtc_tapexe% %rtc_tappara% %TESTDLLDIR% %rtc_issuite%%tcname > %TESTDLLDIR%\%tcname%\%ENTI%.dbg
    else
      %rtc_echo% %rtc_tapexe% %rtc_tappara% %TESTDLLDIR% %rtc_issuite%%tcname
    endiff
  else
    %rtc_tapexe% Test 1 2 N %enti %TESTDLLDIR% %rtc_issuite%%tcname %rtc_oldtappara%
  endiff
  iff x"%rtc_echo%" == x"" then
    set rtc_tap_exitcode=%?
    set rtc_tc_executed=1
    if %rtc_tap_exitcode% != 0 .AND. %rtc_iboe% == 1 set rtc_tcfailed=1
    iff exist %ENTI%.dbg then
      move /q %ENTI%.dbg %TESTDLLDIR%\%tcname%
    endiff
    iff exist %TESTDLLDIR%\%tcerr% then
      move /q %TESTDLLDIR%\%tcerr% %TESTDLLDIR%\%tcname%
      rem Check for stack sync error (exit code 8)
      iff %rtc_tap_exitcode% != 8 .OR. %rtc_try% == %rtc_retry% then
        %grep% -i %tcname% %TESTDLLDIR%\%tcname%\%tcerr% %rtc_tee%
      endiff
    endiff
  endiff
  if %rtc_tcfailed% == 1 return
  iff %rtc_startstack% == 1 then
    %clickbtn% "%@FILENAME[%rtc_psexe%] - Application Error" OK > nul
    iff %? == 0 then
      echo Testcase %tcname% Failed: %rtc_psexe% crashed. %rtc_tee%
    else
      pkill %@NAME[%rtc_psexe%] > nul
    endiff
  endiff
  iff %rtc_testenv% == new then
    rem kill p TST RCV EXTR > nul
    rem kill q PQTST STQTST PQRCV STQRCV > nul
    rem pkill tst > nul
    rem delay 1
    iff %rtc_pcolog% == 1 then
      pcoc stop > nul
    endiff
    rem iff %rtc_showtrc% == 1 then
      rem kill r data_ > nul
      rem pkill pco_view > nul
    rem endiff
    rem delay 1
  else
    cd ..
  endiff
endiff
return

:on_break
set rtc_exitsoon=1
Echo Will exit after the next test case
return

:Need4NT
echo "Error: 4DOS or 4NT is needed
goto end

:unknown_option
echo Unknown Option: %1

:How2Use
text
runalltc   : Run test cases
Usage      : runalltc [-r [<first>]-[<last>]] [-p <ps_exe>] [-t <tap_exe>] [-sp]
                      [-st] [-sum] [-d <delay_time>] [-b <dir>] [-v] [-pcon]
                      [-q] [-e <entity>] [-notst] [-wtmo <time>] [-stmo <time>]
                      [-ib] [-n] [-l <ccddata>] [-ctb] [-tp ... --] [-c <tcase>]
                      [-xf <file>] [-pref <prefix>] [-retry <#retries>] testname
Example    : runalltc GMM -  runs all existing test cases for GMM
with -r    : run range from <first> to <last>
with +s    : run all test cases including suites
with -s    : run (only) all suites
with -p    : take <ps_exe> as protocol stack
with -t    : take <tap_exe> as tap
with -tp --: pass all options between -tp and -- to tap
with -nop  : don't start protocol stack
with -notst: don't start tst.exe
with -sp   : show window of protocol stack (default: don't show)
with -st   : show trace windows (default: don't show)
with -sum  : write summary for each test case in <testname>.txt
with -wtmo : set Tap's default wait timeout to <time> seconds
with -stmo : set Tap's initial synchronization timeout to <time> seconds
with -d    : set <delay_time> (in seconds) after protocal stack starting
with -b    : set <dir> as directory for binaries to start
with -v    : let Tap be verbose on execution
with -n    : let Tap only should what should happen without executing test case
with -l    : load <ccddata> instead of the default one
with -pcon : use pcon for primitive conversion
with -ctb  : let Tap enable common timer base
with -cr   : let Tap check ranges of base type
with -oth  : let Tap configure TST to use the old header format
with -e    : set <entity> name; necessary e.g. for suites
with -q    : quick execution: don't log with pco
with -ib   : immediate break on error (without stopping anything, e.g. stack)
with -oe   : use old frame test environment
with -c    : execute only test case <tcase>
with -xf   : don't execute test cases that are listed in <file>
with -pref : testcase names are named <prefix> + number
with -retry: set number of retries for stack synchronization error
endtext

:end
iff x%RUNALLTC_NO_SETLOCAL% == x then
  endlocal
endiff
popd
