@echo off
setlocal
rem ----------------------------------------------------------------------------- 
rem  Project :  PCO
rem  Modul   :  
rem ----------------------------------------------------------------------------- 
rem  Copyright 2005 Texas Instruments Deutschland GmbH 
rem                 All rights reserved. 
rem 
rem                 This file is confidential and a trade secret of Texas 
rem                 Instruments Berlin, AG 
rem                 The receipt of or possession of this file does not convey 
rem                 any rights to reproduce or disclose its contents or to 
rem                 manufacture, use, or sell anything it may describe, in 
rem                 whole, or in part, without the specific written consent of 
rem                 Texas Instruments Berlin, AG. 
rem ----------------------------------------------------------------------------- 
rem |  Purpose :  PCO installer
rem ----------------------------------------------------------------------------- 

@if x%1 == x-h goto usage

set PATH=%PATH%;..\tools\bin;..\..\tools\bin
pushd .
cd \GPF\assist

set CP=\GPF\tools\bin\cp.exe
set MKLNK=\GPF\BIN\mklnk.exe

set inst_dir=%1
@if x%1 == x set inst_dir=c:\Programme\pco

rem check other params
set official=0
@if x%2 == xofficial set official=1 && shift
set slim=0
@if x%2 == xslim set slim=1 && shift
set delivery=0
@if x%2 == xdelivery set delivery=1
rem echo official=%official%
rem echo slim=%slim%
rem echo delivery=%delivery%

if EXIST %inst_dir% goto update 
@echo Installing into %inst_dir% ...
mkdir %inst_dir% 2>nul
set xtra_dir=%inst_dir%
@if %delivery% == 1 set xtra_dir=%inst_dir%\xtra
mkdir %xtra_dir% 2>nul
set gentle_dir=%inst_dir%
@if %delivery% == 1 set gentle_dir=%inst_dir%\gentle
mkdir %gentle_dir% 2>nul
set tcgen_dir=%inst_dir%
@if %delivery% == 1 set tcgen_dir=%inst_dir%\tcgen
mkdir %tcgen_dir% 2>nul
set tap_dir=%inst_dir%
@if %delivery% == 1 set tap_dir=%inst_dir%\tap
mkdir %tap_dir% 2>nul
goto copy

:update
@echo Updating %inst_dir% ...

:copy

@rem copy pco
if EXIST %inst_dir%\BIN attrib /S -R %inst_dir%\*.* 2> nul
call files_pco B "%CP% -f -P -R" %inst_dir%
call files_pco N "%CP% -f -P -R" %inst_dir%
%CP% -f \gpfdoc\components\readme_pco.txt %inst_dir%

@rem copy xpanel
attrib /S -R %inst_dir%\*.* 2> nul 2> nul
call files_xpan B "%CP% -f -P -R" %inst_dir%
call files_xpan N "%CP% -f -P -R" %inst_dir%
%CP% -f \gpfdoc\components\readme_xpan.txt %inst_dir%

@if %delivery% == 1 goto no_links
@rem create win32 links
%MKLNK% %inst_dir%\bin\pco2.bat "%inst_dir%\Start PCO.lnk" %inst_dir%\bin "" %inst_dir%\bin\pco_srv.exe
%MKLNK% %inst_dir%\doc\pco\pco_intro.pps "%inst_dir%\PCO introduction.lnk" %inst_dir%\doc "" 

:no_links
@if %official% == 1 goto official

@rem copy moanbtn
attrib /S -R %inst_dir%\*.* 2> nul
call files_mbtn B "%CP% -f -P -R" %inst_dir%

rem copy tcgen ...
@rem copy tcgen
call files_tcgen B "%CP% -f -P -R" %tcgen_dir%

rem copy tap ...
@rem copy tap
call files_tap B "%CP% -f -P -R" %tap_dir%
call files_tapcaller B "%CP% -f -P -R" %tap_dir%

:official
rem copy gentle ...
@rem copy gentle
call files_gentle B "%CP% -f -P -R" %gentle_dir%
%CP% -f \gpf\util\pco\cfg\gentle* %gentle_dir%\cfg

rem create ccddata-dir
mkdir %inst_dir%\ccddata
echo "" > %inst_dir%\ccddata\ccddata_example.dll
%CP% -f \gpf\BIN\ccddata_dll.dll %inst_dir%\ccddata\ccddata_example.dll

@if %slim% == 1 goto slim_xtra

rem copy ccddata prebuilds
%CP% -f \gpf\BIN\ccddata\*.dll %inst_dir%\ccddata

:slim_xtra
rem copy xtra tools ...
if EXIST %xtra_dir%\BIN attrib /S -R %xtra_dir%\*.*  2> nul

@rem copy mscview
call files_mscview B "%CP% -f -P -R" %xtra_dir%

@if %slim% == 1 goto slim

if EXIST cond_decoder.exe %CP% -f cond_decoder.exe %xtra_dir%\BIN
if NOT EXIST %xtra_dir%\BIN\cond_decoder.exe %CP% -f \\dbgs2\deveng\cc\gpf\projects\pco\delivery\L1_trace_decoder\cond_decoder.exe %xtra_dir%\BIN

call files_emw B "%CP% -f -P -R" %xtra_dir%
call files_emw N "%CP% -f -P -R" %xtra_dir%

:slim
popd
@rem copy ccddata and multiplexer (if existing)
attrib /S -R %inst_dir%\*.* 2> nul
if EXIST %inst_dir%\BIN\ccddata_dll.dll goto noccddata
if EXIST ccddata_dll.dll %CP% -f ccddata_dll.dll %inst_dir%\BIN
:noccddata

@if %delivery% == 1 goto end
@echo. 
@echo Installation/Update finished ;-) 
if NOT EXIST %inst_dir%\BIN\ccddata_dll.dll @echo  You still need a ccddata_dll.dll in %inst_dir%\bin ! (use \GPF\BIN\xm.bat after "makcdg ... ARM")
@echo.
@echo To start with default config just run pco2.bat in %inst_dir%\bin ... 
@echo (call "pco2 -h" from command line for more options)
@echo.
@echo Please find some preconfigured win32-links in %inst_dir% for your convenience ;-)
@echo.
@echo Have fun ! 
pause

goto end

:usage
@echo usage: 
@echo "pco_install [-h|"
@echo "             <install directory> [official]]"

:end
endlocal
