@echo off
setlocal
rem ----------------------------------------------------------------------------- 
rem  Project :  PCO
rem  Modul   :  
rem ----------------------------------------------------------------------------- 
rem  Copyright 2005 Texas Instruments Deutschland GmbH 
rem                 All rights reserved. 
rem 
rem                 This file is confidential and a trade secret of Texas 
rem                 Instruments Berlin, AG 
rem                 The receipt of or possession of this file does not convey 
rem                 any rights to reproduce or disclose its contents or to 
rem                 manufacture, use, or sell anything it may describe, in 
rem                 whole, or in part, without the specific written consent of 
rem                 Texas Instruments Berlin, AG. 
rem ----------------------------------------------------------------------------- 
rem |  Purpose :  general start batch file
rem ----------------------------------------------------------------------------- 

set PATH=..\tools\bin;..\..\tools\bin\debug;..\..\tools\bin;%PATH%

@if x%1 == x-h goto usage

rem	start /min cms -n

@if x%1 == xgui goto gui
@if x%1 == xnogui goto nogui
@if x%1 == xguidebug goto gui_start

:gui
@if x%GPF% == x goto gui_direct
if EXIST pco.ini goto gui_direct
if EXIST pco2.bat goto gui_direct
echo starting from %GPF%\BIN
cd %GPF%\BIN

:gui_direct
@if x%1 == xgui shift
rem set cfg directory
set cfg_dir=..\cfg
if NOT EXIST ..\cfg\main.svc.default set cfg_dir=..\..\cfg

@if x%1 == x goto gui_start
set pco_cfg=%1

:gui_start
rem  copy default configs
if NOT EXIST %cfg_dir%\main.svc copy %cfg_dir%\main.svc.default %cfg_dir%\main.svc
if NOT EXIST %cfg_dir%\syst.svc copy %cfg_dir%\syst.svc.default %cfg_dir%\syst.svc
if NOT EXIST Multiplexer.ini copy %cfg_dir%\Multiplexer.ini.default Multiplexer.ini
if NOT EXIST TraceMultiplexer.ini copy %cfg_dir%\TraceMultiplexer.ini.default TraceMultiplexer.ini
grep -c "\[Application\]" TraceMultiplexer.ini >nul
if "%ERRORLEVEL%" == "1" type %cfg_dir%\TraceMultiplexer.ini.default >> TraceMultiplexer.ini 

if EXIST ..\ccddata\ccddata_G23M_333_S64.dll goto ccddata_ok
rem copy precompiled ccddata-DLLs
mkdir ..\ccddata 2>nul
copy \\dbgs2\deveng\cc\gpf\projects\pco\ccddata\*.* ..\ccddata 2>nul >nul

:ccddata_ok
rem copy cond_decoder
if NOT EXIST cond_decoder.exe copy \\dbgs2\deveng\cc\gpf\projects\pco\delivery\L1_trace_decoder\cond_decoder.exe cond_decoder.exe 2>nul >nul

if EXIST TestHarnessPCO.bat goto testharness_ok
rem unzip testharness
unzip TestHarnessPCO.zip >nul

:testharness_ok
rem  call controller with environment and evtl. default config options
start pco_ctrl -env %pco_cfg%
goto end

:nogui
start pcod
sleep 3
@if x%2 == x goto defstart
@if x%2 == xreplay goto replay
pcoc start %2 
goto view
:replay
@if x%3 == x goto defreplay
pcoc open %3
goto view
:defreplay
pcoc open pcotest
goto view
:defstart
pcoc start pcotest
:view
start pco_view
goto end

:usage
@echo usage: 
@echo "pco2 [-h|"
@echo "     [gui|guidebug] |" 
@echo "     [nogui [[replay] [<test-case-name>]]]" 

:end
endlocal
