@echo off
setlocal
rem --------------------------------------------------------------------------- 
rem  Project :  
rem  Modul   : mktchier.bat 
rem --------------------------------------------------------------------------- 
rem  Copyright 2002 Texas Instruments Berlin, AG 
rem                 All rights reserved. 
rem 
rem                 This file is confidential and a trade secret of Texas 
rem                 Instruments Berlin, AG 
rem                 The receipt of or possession of this file does not convey 
rem                 any rights to reproduce or disclose its contents or to 
rem                 manufacture, use, or sell anything it may describe, in 
rem                 whole, or in part, without the specific written consent of 
rem                 Texas Instruments Berlin, AG. 
rem --------------------------------------------------------------------------- 
rem  Purpose : Generate test case hierarchy.
rem --------------------------------------------------------------------------- 
set tc_exitcode=0
loadbtm on
@pushd
@if x%_4ver% == x goto Need4NT

@rem Check %PROST
@iff x%PROST == x then
@echo Set the environment variable PROST to the name of the stack.
@echo e.g. set PROST=GSM or set PROST=WARP will work
goto error
@endiff

@rem Check for gnumake and grep
set grep=%GPF%\tools\bin\grep.exe
iff NOT exist %grep% then
  echo You need %grep% to generate a test hierarchy
  goto error
endiff
set sed=%GPF%\tools\bin\sed.exe
iff NOT exist %sed% then
  echo You need %sed% to generate a test hierarchy
  goto error
endiff
rem set gawk but check it later only if it is needed
set gawk=%GPF%\tools\bin\gawk.exe

set TC_FINALTESTS=0
:check_options
iff "%1" == "-f" then
  rem Check for several tools in %PATH
  set uniq=%GPF%\tools\bin\uniq.exe
  set sort=%GPF%\tools\bin\sort.exe
  iff NOT exist %uniq% then
    echo You need %uniq% to generate a test hierarchy for final tests
    goto error
  endiff
  iff NOT exist %sort% then
    echo You need %sort% to generate a test hierarchy for final tests
    goto error
  endiff
  iff NOT exist %gawk% then
    echo You need %gawk% to generate a test hierarchy for final tests
    goto error
  endiff
  iff %tc_gen_only% == 1 then
    echo Use of "-f" ignored because "-to" was set
  else
    set TC_FINALTESTS=1
  endiff
  shift 1
  goto check_options
endiff

@if %#% != 1 goto How2Use
if "%@INSTR[0,1,%1]" == "-" goto unknown_option

set ENTI=%@LOWER[%1]
if "x%tc_bnam%" == "x" set tc_bnam=%ENTI%

@rem Stack-Specifics
iff "x%TCDIR%" == "x" then
  iff "%PROST" == "WARP" .OR. "%PROST%" == "g23net" then
    set TCDIR=%BINDIR%
  else
    set TCDIR=%TESTROOT%\%SIDE%\TEST
  endiff
endiff

%TESTDRIVE%

@if NOT exist %TDSDIR%\%ENTI%\*.tds goto NoTds
cd %TDSDIR%\%ENTI%
set tc_pream=%ENTI%_pream.txt
set tc_hier=%ENTI%_hier.txt
if exist %tc_hier% del /q %tc_hier%

iff %TC_FINALTESTS% == 1 then
set tc_nonfdummy=%ENTI%_nonfdummy.txt
if exist %tc_nonfdummy% del /q %tc_nonfdummy
%grep% -hi "#include.*tds" *.tds | %sed% -e "s/#include \"\([a-zA-Z0-9]*\).*\"/\1.td_/" > %tc_nonfdummy%
%grep% -Li "#include.*tds" *.tds | %sed% -e "s/.*\\//" -e "s/tds/td_/" >> %tc_nonfdummy
%sort% < %tc_nonfdummy% | %uniq% | %gawk% -- "{ print $1 > $1 }"
del /q %tc_nonfdummy
endiff

FOR %tcase IN (*.tds) do (
  set act_file=%tcase%
  gosub print_hier
)

goto clean_up

:print_hier
set tcname=%@NAME[%act_file%]
if EXIST %tcname%.td_ return

echo. >> %tc_hier%
echos %tcname% >> %tc_hier%
%grep% TITLE %act_file% | %sed% -e "s/TITLE://" >> %tc_hier%
:next_file
%grep% -hi "#include.*tds" %act_file% | %sed% -e "s/#include \"\([a-zA-Z0-9]*.*\)\"/\1/" > %tc_pream%
set file_handle=%@FILEOPEN[%tc_pream%,read]
if %file_handle == -1 return
set act_file=%@FILEREAD[%file_handle%]
set file_handle=%@FILECLOSE[%file_handle%]
iff %act_file% == **EOF** then
  return
else
  echos ^s^s%@NAME[%act_file%] >> %tc_hier%
  %grep% TITLE %act_file% | %sed% -e "s/TITLE://" >> %tc_hier%
  goto next_file
endiff

:clean_up
echo Generated test case hierarchy in %TDSDIR%\%ENTI%\%tc_hier% 
if exist %tc_pream% del /q %tc_pream%
if exist *.td_ del /q *.td_
goto end

:NoDoc
@echo "%TSTDOCDIR%\%ENTI%.doc does not exist"
goto error

:NoTds
@echo "No tds-Files in %TDSDIR%\%ENTI%"
goto error

:Need4NT
@echo "Error: 4DOS or 4NT is needed
goto error

:unknown_option
echo Unknown Option: %1

:How2Use
text
mktchier : Get test case hierarchy
Usage   : mktchier [-f] <TDOC>
Example : mktchier CC  -  creates test case hierarchy for CC
      -f: consider final tests only
endtext

:error
set tc_exitcode=1

:end
endlocal
popd
quit %tc_exitcode%
