@setlocal
@echo off
loadbtm on

@if x%_4ver% == x goto need4NT

@rem initialize vars
set dest=%DEV%\com\doc
set sap_root=
set aim_root=
set pdfcmdline=
set action=-help
set debug=false

@rem check command line options
:check_options
@rem Check Parameters
if "x%1" == "x" goto create_action
iff "%1" == "-sr" then
  if "x%2" == "x" (echo Missing root directory information for SAP docs for "-sr" & goto useerror)
  set sap_root=%2
  shift 2
  goto check_options
elseiff "%1" == "-ar" then
  if "x%2" == "x" (echo Missing root directory information for AIM docs for "-ar" & goto useerror)
  set aim_root=%2
  shift 2
  goto check_options
elseiff "%1" == "-d" then
  if "x%2" == "x" (echo Missing destination directory information for documentation for "-d" & goto useerror)
  set dest=%2
  shift 2
  goto check_options
elseiff "%1" == "--debug" then
  echo mkdoc.bat script is running in debug mode now!
  set DELETE=rem
  echo on
  shift 1
  set debug=true
  goto check_options
elseiff "%1" == "-pdf" .or. "%1" == "-pdf1" .or. "%1" == "-reviewdoc" then
  if not "%action%"=="-help" (echo Only one action can be executed at a time & goto useerror)
  if "x%2" == "x" (echo Missing name of document for which documentation is to be created & goto useerror)
  if not "%3"=="sap" .and. not "%3"=="aim" (echo Missing type of document for which documentation is to be created ("sap" or "aim") & goto useerror)
  set action=%1
  set convdoc=%2
  set convdoctype=%3
  shift 3
  goto check_options
elseiff "%1" == "--?" .or. "%1" == "-help" .or. "%1" == "-h" then
  gosub how2use
  goto end
elseiff "%1" == "-html" then
  if not "%action%"=="-help" (echo Only one action can be executed at a time & goto useerror)
  set action=%1
  shift 1
else
  echo Unknown parameter: %1
  goto useerror
endiff

:create_action

set errorlevel=0

iff not isdir %dest%\sapedoc then
  mkdir %dest%\sapedoc
endiff
set dest=%dest%\sapedoc

iff "%action%"=="-help" then
  gosub how2use
  goto end
elseiff "%action%"=="-html" .or. "%action%"=="-pdf1" then

@rem ********** Legacy code - begin **********

@rem Create html documentation.
if not "x%sap_root%" == "x" set htmlcmdline=%htmlcmdline% -sr %sap_root%
if not "x%aim_root%" == "x" set htmlcmdline=%htmlcmdline% -ar %aim_root%

@rem Sub process of pdf generation?
iff not "x%convdoc%" == "x" then
  if "x%dest%" == "x" set dest=%DEV%\com\doc
  set htmlcmdline=%htmlcmdline% -d %dest%\__sapehtml_tmp %convdoc% %convdoctype%
else
  if not "x%dest%" == "x" set htmlcmdline=%htmlcmdline% -d %dest%
endiff

echo Calling "mkhtmldoc.bat" to generate html documentation:
call %GPF%\util\sape\bin\mkhtmldoc.bat %htmlcmdline%
if "%errorlevel%"!="0" goto end

@rem Create ps/pdf documentation.
iff not "x%convdoc%" == "x" then
  set errorlevel=0
  if not "x%dest%" == "x" set pscmdline=%pscmdline% -hr %dest%\__sapehtml_tmp\sapehtml -d %dest%
  set pscmdline=%pscmdline% %convdoc% %convdoctype%
  echo.
  echo Calling "mkpsdoc.bat" to generate ps and pdf documentation:
  call %GPF%\util\sape\bin\mkpsdoc.bat %pscmdline%
  set mkpsdoc_err=%errorlevel%
  iff not "x%dest%" == "x" then
    echo Deleting temporary html version of documentation..
    del /QESXY %dest%\__sapehtml_tmp
  endiff
  if "%mkpsdoc_err%"!="0" goto end
endiff

@rem ********** Legacy code - end **********

elseiff "%action%"=="-pdf" then
  @rem Create pdf documentation.
  set errorlevel=0
  if not "x%sap_root%" == "x" set pdfcmdline=%pdfcmdline% -sr %sap_root%
  if not "x%aim_root%" == "x" set pdfcmdline=%pdfcmdline% -ar %aim_root%
  if not "x%dest%" == "x" set pdfcmdline=%pdfcmdline% -d %dest%
  if "%debug%" == "true" set pdfcmdline=%pdfcmdline% --debug
  set pdfcmdline=%pdfcmdline% %convdoc% %convdoctype%
  echo.
  echo Calling "mkpdfdoc.bat" to generate pdf documentation:
  call %GPF%\util\sape\bin\mkpdfdoc.bat %pdfcmdline%
  set mkpdfdoc_err=%errorlevel%
  if "%mkpdfdoc_err%"!="0" goto end
elseiff "%action%"=="-reviewdoc" then
  @rem Create doc documentation.
  set errorlevel=0
  if not "x%sap_root%" == "x" set pdfcmdline=%pdfcmdline% -sr %sap_root%
  if not "x%aim_root%" == "x" set pdfcmdline=%pdfcmdline% -ar %aim_root%
  if not "x%dest%" == "x" set pdfcmdline=%pdfcmdline% -d %dest%
  if "%debug%" == "true" set pdfcmdline=%pdfcmdline% --debug
  set pdfcmdline=%pdfcmdline% %convdoc% %convdoctype%
  echo.
  echo Calling "mkrtfdoc.bat" to generate rtf/doc documentation:
  call %GPF%\util\sape\bin\mkrtfdoc.bat %pdfcmdline%
  set mkpdfdoc_err=%errorlevel%
  if "%mkpdfdoc_err%"!="0" goto end
else
  (echo Unknown type of action. & goto useerror)
endiff

if "x%dest%" == "x" set dest=%DEV%\com\doc
echo Generated documentation can be found in "%dest%".

goto end

:need4NT
echo This script only runs under 4NT shell environment!
goto error

:end
endlocal
quit 0

:useerror
gosub how2Use

:error
endlocal
quit 1

:how2Use
text
mkdoc    : Create SAP and AIM documentation
Usage    : mkdoc [-sr <sapRootDir>] [-ar <aimRootDir>] [-d <destDir>]
                 [-help | ((-pdf | -pdf1 | -reviewdoc) <docName> (sap|aim)) | -html]
Example  : mkdoc -sr .\SAP -ar .\AIM -pdf DTI2 sap
             ;creates pdf documentation for DTI2 in sapepdf directory 
    -sr  : set <sapRootDir> as directory for the SAP documents (*.sap)
    -ar  : set <aimRootDir> as directory for the AIM documents (*.aim)
    -d   : set <destDir> as root directory for the documentation
    -pdf : generate pdf format documentation.
    -pdf1: generate legacy version of ps/pdf format documentation.
    -reviewdoc:
           generate Word document format version of documentation
           for review purposes.
    <docName>
           Name of the document for which documentation is to be generated,
           without suffix.
    -html: generate HTML version of documentation for all SAP/AIM documents.
    -help: display this message

    --debug : run script in debug mode
endtext
echo.
return