@echo off
setlocal
rem --------------------------------------------------------------------------- 
rem  Project :  
rem  Modul   : mkalltc.bat
rem --------------------------------------------------------------------------- 
rem  Copyright 2002 Texas Instruments Berlin, AG 
rem                 All rights reserved. 
rem 
rem                 This file is confidential and a trade secret of Texas 
rem                 Instruments Berlin, AG 
rem                 The receipt of or possession of this file does not convey 
rem                 any rights to reproduce or disclose its contents or to 
rem                 manufacture, use, or sell anything it may describe, in 
rem                 whole, or in part, without the specific written consent of 
rem                 Texas Instruments Berlin, AG. 
rem --------------------------------------------------------------------------- 
rem   Purpose : Generate all test cases for a given test specification
rem --------------------------------------------------------------------------- 
set tc_exitcode=0
loadbtm on
@pushd
@if x%_4ver% == x goto Need4NT

@rem Check %PROST
@iff x%PROST == x then
@echo Which Protocol Stack shall be tested?
@echo set the environment variable PROST to the name of the stack.
@echo e.g. set PROST=GSM or set PROST=WARP will work
goto error
@endiff

@rem Check for gnumake and grep
set grep=%GPF%\tools\bin\grep.exe
iff NOT exist %grep% then
  echo You need %grep% to generate test cases
  goto error
endiff
set gnumake=%GPF%\tools\bin\gnumake.exe
iff NOT exist %gnumake% then
  echo You need %gnumake% to generate test cases
  goto error
endiff
set sed=%GPF%\tools\bin\sed.exe
iff NOT exist %sed% then
  echo You need %sed% to generate tests
  goto error
endiff
rem set gawk but check it later only if it is needed
set gawk=%GPF%\tools\bin\gawk.exe

@set TC_COMPILE_ONLY=0
@set TC_FINALTESTS=0
iff "x%TDSCHECK_ENABLED" == "x" then
set enable_check=0
else
set enable_check=1
endiff
set tc_firsttc=
set tc_lasttc=
set tc_delete_olds=1
set tc_cons_output=0
set tc_bnam=
set tc_furtherincludes=
set tc_gen_only=0
set tc_range_supplied=0
set tc_testconfig=
set tc_testdlldir=
set tc_testenv=new
set tc_gendir=%GPF%\util\tap\gen
set tc_tap_errfunc=tap_get_exitcode 
set tc_testpref=
set tc_allin1=0
set tc_genc=0
set tc_tdc=0

:check_options
@rem Check Parameters
@if "x%1" == "x" goto How2Use
iff "%1" == "-to" then
  iff %tc_compile_only% == 1 .OR. %TC_FINALTESTS% == 1 then
    echo Use of "-to" ignored because "-co" or "-f" was set
  else
    set tc_gen_only=1
  endiff
  shift 1
  goto check_options
elseiff "%1" == "-co" then
  iff %tc_gen_only% == 1 then
    echo Use of "-co" ignored because "-to" was set
  else
    set TC_COMPILE_ONLY=1
  endiff
  shift 1
goto check_options
elseiff "%1" == "-eut" then
  set tc_testconfig=EUT=%@UPPER[%2]
  set tc_tdcenti=%@LOWER[%2]
  shift 2
  goto check_options
elseiff "%1" == "-f" then
  rem Check for several tools in %PATH
  set uniq=%GPF%\tools\bin\uniq.exe
  set sort=%GPF%\tools\bin\sort.exe
  iff NOT exist %uniq% then
    echo You need %uniq% to generate final tests
    goto error
  endiff
  iff NOT exist %sort% then
    echo You need %sort% to generate final tests
    goto error
  endiff
  iff NOT exist %gawk% then
    echo You need %gawk% to generate final tests
    goto error
  endiff
  iff %tc_gen_only% == 1 then
    echo Use of "-f" ignored because "-to" was set
  else
    set TC_FINALTESTS=1
  endiff
  shift 1
  goto check_options
elseiff "%1" == "-tty" then
  set tc_cons_output=1
  shift 1
  goto check_options
elseiff "%1" == "-oe" then
  set tc_tap_errfunc=!tcd_errorOccured
  set tc_gendir=%GPF%\tap
  set tc_testenv=old
  shift 1
  goto check_options
elseiff "%1" == "-oed" then
  set tc_tap_errfunc=!tcd_errorOccured
  set tc_gendir=%GPF%\tap
  set tc_testenv=old
  set tc_testpref=oe_
  shift 1
  goto check_options
elseiff "%1" == "-debug" then
  echo on
  shift 1
  goto check_options
elseiff "%1" == "-k" then
  set tc_delete_olds=0
  shift 1
  goto check_options
elseiff "%1" == "-tc" then
  if "x%2" == "x" (echo Missing name of testcases for "-tc" & goto How2Use)
  set tc_bnam=%2
  shift 2
  goto check_options
elseiff "%1" == "-r" then
  if "x%2" == "x" (echo Missing range for "-r" & goto How2Use)
  set tc_dash=%@INDEX[%2,-]
  if %tc_dash == -1 (echo Invalid range "%2" & goto How2Use)
  set tc_firsttc=%@INSTR[0,%tc_dash,%2]
  set tc_lasttc=%@SUBSTR[%2,%@eval[1+%tc_dash%]]
  set tc_range_supplied=1
  shift 2
  goto check_options
elseiff "%1" == "-chk" then
  rem Call TDSCheck after generating tds files
  set enable_check=1
  shift 1
  goto check_options
elseiff "%1" == "-td" then
  if "x%2" == "x" (echo Missing testdll directory  for "-td" & goto How2Use)
  set tc_testdlldir=%2
  shift 2
  goto check_options
elseiff "%1" == "-genc" then
  set tc_genc=1
  set tc_allin1=1
  shift 1
  goto check_options
elseiff "%1" == "-1" then
  set tc_allin1=1
  shift 1
  goto check_options
elseiff "%1" == "-tdc" then
  set tc_tdc=1
  shift 1
  goto check_options
elseiff "%1" == "-i" then
  if "x%2" == "x" (echo Miissing include directory  for "-i" & goto How2Use)
  iff "%@INSTR[0,1,%2]" == "." .OR. "%@INSTR[0,1,%2]" == "/" .OR. "%@INSTR[0,1,%2]" == "\" .OR. "%@INSTR[1,1,%2]" == ":" then
    set tc_furtherincludes=%tc_furtherincludes% -I %2
  else
    set tc_furtherincludes=%tc_furtherincludes% -I %TDSDIR%/%2
  endiff
  shift 2
  goto check_options
endiff

@if %#% GT 2 goto How2Use
if "%@INSTR[0,1,%1]" == "-" goto unknown_option

iff %tc_allin1% == 1 then
  set decl_extr=%GPF%\BIN\decl-extr.exe
  iff NOT exist %decl_extr% then
    echo You need %decl_extr% to generate test cases
    goto error
  endiff
endiff

iff %tc_tdc% == 1 then
  set msdev=%@search[msdev]
  iff "x%msdev%" == "x" then
    echo You need MSDEV in your Path to generate TDC test cases
    goto error
  endiff
endiff

iff "x%2" != "x" then
  iff "x%tc_testconfig" != "x" then
    echo Warning: parameter "%2" ignored, because -eut was set
  else
    set tc_testconfig=%@UPPER[%2]
  endiff
else
  if "x%tc_testconfig" == "x" set tc_testconfig=%@UPPER[%1]
endiff
set ENTI=%@LOWER[%1]
if "x%tc_bnam%" == "x" set tc_bnam=%ENTI%
if "x%tc_tdcenti%" == "x" set tc_tdcenti=%ENTI%

@rem Stack-Specifics
iff "x%TCDIR%" == "x" then
  iff "%PROST" == "WARP" .OR. "%PROST%" == "g23net" then
    set TCDIR=%BINDIR%
  else
    set TCDIR=%TESTROOT%\%SIDE%\TEST
  endiff
endiff
iff %tc_tdc% == 1 then
  iff %PROST% == generic then
    set TDCSRCDIR=%TESTROOT%\spec\test\%ENTI%
  else
    iff exist %TESTROOT%\ms\src\%tc_tdcenti%\%tc_bnam%_test then
      set TDCSRCDIR=%TESTROOT%\ms\src\%tc_tdcenti%\%tc_bnam%_test
    elseiff exist %TESTROOT%\ms\src\%tc_tdcenti%\test_%tc_bnam% then
      set TDCSRCDIR=%TESTROOT%\ms\src\%tc_tdcenti%\test_%tc_bnam%
    else
      echo No test case directory
      echo Neither %TESTROOT%\ms\src\%tc_tdcenti%\%tc_bnam%_test
      echo ^s^s^s^snor %TESTROOT%\ms\src\%tc_tdcenti%\test_%tc_bnam% exist
      goto error
    endiff
  endiff
endiff

%TESTDRIVE%

rem check if test case directory is substructured
iff "x%tc_testdlldir" =="x" then
  iff "x%TCNOTSUBSTRUCT" == "x" then
    set TESTDLLDIR=%TCDIR%\%tc_testpref%%ENTI%_test
  else
    set TESTDLLDIR=%TCDIR%
  endiff
else
  iff "%@INSTR[0,1,%tc_testdlldir%]" == "." .OR. "%@INSTR[0,1,%tc_testdlldir%]" == "/" .OR. "%@INSTR[0,1,%tc_testdlldir%]" == "\" .OR. "%@INSTR[1,1,%tc_testdlldir%]" == ":" then
    set TESTDLLDIR=%tc_testdlldir%
  else
    set TESTDLLDIR=%TCDIR%\%tc_testdlldir%
  endiff
endiff

iff NOT exist %TESTDLLDIR% .AND. %tc_tdc% != 1 then
  echo "Creating test directory %TESTDLLDIR% ..."
  mkdir /S %TESTDLLDIR%
endiff

rem check if configstring is like EUT=ACI or like MFW
set EQINP2=%@WORDS["=",%tc_testconfig]
@iff %EQINP2% GT 1 then
  set TSTDLLCONF="%tc_testconfig%"
@else
  set TSTDLLCONF="CONFDLL=%tc_testconfig%"
@endiff


iff %tc_tdc% == 1 then
  set tcerr=%TDCSRCDIR%\%ENTI%.err
  iff exist %TDCSRCDIR%\makefile then
    echo Building Testlib with %TDCSRCDIR%\makefile
    call gnumake > %tcerr%
  else
    iff exist %TDCSRCDIR%\%ENTI%_test.dsp then
      set msdevfile=%TDCSRCDIR%\%ENTI%_test.dsp
    elseiff exist %TDCSRCDIR%\%ENTI%_test.dsw then
      set msdevfile=%TDCSRCDIR%\%ENTI%_test.dsw
    elseiff exist %TDCSRCDIR%\test_%ENTI%.dsp then
      set msdevfile=%TDCSRCDIR%\test_%ENTI%.dsp
    elseiff exist %TDCSRCDIR%\test_%ENTI%.dsw then
      set msdevfile=%TDCSRCDIR%\test_%ENTI%.dsw
    else
      set msdevfile=_not_found_
    endiff
    iff %msdevfile% == _not_found_ then
      echo No Project/Workspace file %ENTI%_test found in %TDCSRCDIR%
      goto error
    endiff
    echo Building Testlib with %msdevfile%
    call msdev.exe %msdevfile% /MAKE "%@NAME[%msdevfile%] - Win32 Debug" /CLEAN > %tcerr%
    iff %? == 0 then
      call msdev.exe %msdevfile% /MAKE "%@NAME[%msdevfile%] - Win32 Debug" /REBUILD >> %tcerr%
    endiff
  endiff

  iff %? == 0 then
    echo ...done.
    if exist %tcerr% del /q %tcerr%
  else echo See errors %tcerr & goto end
  endiff
  goto end
else
  set tcerr=%TDSDIR%\%ENTI%\%ENTI%.err
endiff

@if %tc_genc == 1 goto gen_c
@if %TC_COMPILE_ONLY == 1 goto compile_only

@if NOT exist %TSTDOCDIR%\%ENTI%.doc goto NoDoc

@rem Check for tdsgen
set tdsgen=%GPF%\BIN\tdsGen.exe%
iff NOT exist %tdsgen% then
  echo You need %tdsgen% to generate test cases
goto error
@endiff

rem Check for doc2txt
set doc2txt=%GPF%\tools\bin\Doc2txt.exe
iff NOT exist %doc2txt% then
echo You need %doc2txt% to generate test cases
goto error
endiff
set doc2txt_opts=-O -w -f wdFormatTextLineBreaks

rem Check for tdscheck.exe
iff %enable_check% == 1 then 
  set tdscheck=%GPF%\BIN\tdscheck.exe
  iff NOT EXIST %tdscheck% then
    echo You need %tdscheck% to check your tds files
    goto error
  endiff
endiff

rem check if tds directory exists
@iff NOT exist %TDSDIR%\%ENTI% then
@echo "Creating test directory %TDSDIR%\%ENTI% ..."
@mkdir /S %TDSDIR%\%ENTI%
@endiff

@if exist %TDSDIR%\%ENTI%\*.tds del /q %TDSDIR%\%ENTI%\*.tds

%doc2txt% %doc2txt_opts% %TSTDOCDIR%\%ENTI%.doc
rem hack for office 2000 where a blank is inserted after a backslash-newline
move /q %TSTDOCDIR%\%ENTI%.txt %TSTDOCDIR%\%ENTI%.txt_
%sed% -e "s/\\ $/\\/" %TSTDOCDIR%\%ENTI%.txt_ > %TSTDOCDIR%\%ENTI%.txt
del /q %TSTDOCDIR%\%ENTI%.txt_ > nul
rem end of hack
%tdsgen% %TCDIR% %ENTI% %TSTDOCDIR% %TDSDIR%\%ENTI%
if %tc_cons_output% == 1 type %tcerr%
if errorlevel GT 0 goto tdsgenerr
gosub gen_suites
@iff %enable_check% == 1 then 
  %tdscheck% %TDSDIR%\%ENTI% %ENTI%
  @if errorlevel GT 1 goto tapcheckerrors
@endiff
if %tc_gen_only == 1 goto end

:gen_c
:compile_only
@if NOT exist %TDSDIR%\%ENTI%\*.tds goto NoTds
cd %TDSDIR%\%ENTI%
set tc_exmp_=%@FINDFIRST[*.tds]
set tc_exmp=%@NAME[%tc_exmp_]
set tc_exmp_=%@FINDCLOSE[*.tds]
iff %tc_testenv% == new then
%grep% SCRIPT_BEGIN %tc_exmp%.tds > nul
  iff %? == 0 then
    set tc_testlanguage=TCSL 
  else
    set tc_testlanguage=TDS
  endiff
endiff

if %tc_allin1% == 0 goto not_allin1

@if %TC_COMPILE_ONLY == 1 goto compile_c
echo #include "%ENTI%.h" > %ENTI%.c

@FOR %tcase IN (%TDSDIR%\%ENTI%\*.tds) do (
%sed% -e 1,2d -e "s/TESTCASE (\([a-zA-Z0-9_]*\))/EXPORT UBYTE \1(){&/" -e "s/ENDCASE/&;return (%tc_tap_errfunc%());}/" -e "s/#include \"\([a-zA-Z0-9_]*\).[tT][dD][sS]\"/\1();/" %tcase% >> %ENTI%.c
)

%grep% EXPORT %ENTI%.c | sed s/{.*/;/ > %ENTI%.h
%decl_extr% %ENTI%.def %ENTI%.decl
%grep% #include %ENTI%.def >> %ENTI%.decl

:compile_c
cdd %tc_gendir%
call gnumake -f testdll.mk OUTDLL=%TESTDLLDIR%/%ENTI%.DLL %TSTDLLCONF% ALL_IN_ONE=1 TSTDOCNAM=%ENTI% TC_FURTHERINCLUDES="%tc_furtherincludes" TC_TESTLANGUAGE=%tc_testlanguage% all >%tcerr%

iff %? == 0 then
  echo Generated Testlib %TESTDLLDIR%\%ENTI%.DLL.
  if exist %tcerr% del /q %tcerr%
else echo See %tcerr & goto end
endiff
goto end

:not_allin1
rem Check ranges
iff %tc_range_supplied% == 1 then
  set tc_ords=%@SUBSTR[%tc_exmp,%@LEN[%tc_bnam%]]
  set tc_len=%@LEN[%tc_ords]
  if %@NUMERIC[%tc_ords] == 0 set tc_len=%@DEC[%tc_len%]
  iff x%tc_firsttc == x then
    iff %tc_len% == 4 then
      set tc_firsttc=0000
    else
      set tc_firsttc=000
    endiff
  else
    set tc_len_=%@LEN[%tc_firsttc]
    if %@NUMERIC[%tc_firsttc] == 0 set tc_len_=%@DEC[%tc_len_%]
    if %tc_len != %tc_len_ echo Warning: your range "%tc_firsttc" is ambigious
  endiff
  iff x%tc_lasttc == x then
    iff %tc_len% == 4 then
      set tc_lasttc=9999Z
    else
      set tc_lasttc=999Z
    endiff
  else
    set tc_len_=%@LEN[%tc_lasttc]
    if %@NUMERIC[%tc_lasttc] == 0 set tc_len_=%@DEC[%tc_len_%]
    if %tc_len != %tc_len_ echo Warning: your range "%tc_lasttc" is ambigious
  endiff
endiff

rem Deleting all old .err-Files
@if exist %TDSDIR%\%ENTI%\*.err del /q %TDSDIR%\%ENTI%\%ENTI%*.err

iff %tc_delete_olds == 1 then
  iff exist %TESTDLLDIR%\%tc_bnam%*.dll .OR. exist %TESTDLLDIR%\sui\%tc_bnam%*.dll then
    echo Deleting all old .dll-Files
    if exist %TESTDLLDIR%\%tc_bnam%*.dll del /q %TESTDLLDIR%\%tc_bnam%*.dll
    if exist %TESTDLLDIR%\sui\%tc_bnam%*.dll del /q %TESTDLLDIR%\sui\%tc_bnam%*.dll
  endiff
endiff

iff %TC_FINALTESTS% == 1 then
set tc_nonfdummy=%TDSDIR%\%ENTI%\%ENTI%_nonfdummy.txt
if exist %tc_nonfdummy% del /q %tc_nonfdummy
%grep% -hi "#include.*tds" %TDSDIR%\%ENTI%\*.tds | %sed% -e "s/#include  *[\"^<]\([a-zA-Z0-9]*\).*[\"^>]/\1.td_/" > %tc_nonfdummy%
iff %tc_testlanguage% == TCSL then
    if exist %ENTI%.sui echo Warning: option -f in combination with Suites and test language TCSL cannot always work properly 
else
  %grep% -Li "#include.*tds" %TDSDIR%\%ENTI%\*.tds | %sed% -e "s/.*\\//" -e "s/tds/td_/" >> %tc_nonfdummy
endiff
%sort% < %tc_nonfdummy% | %uniq% | %gawk% -- "{ print $1 > $1 }"
iff exist %ENTI%.sui then
  %sort% < %tc_nonfdummy% | %uniq% | %sed% -e "s/\(.*\)\.td_/\/\1\/{ print \"\1\"}/" > %ENTI%.awk 
  %gawk% -f %ENTI%.awk %ENTI%.sui | %sort% | %uniq% | %sed% -e "s/.*/&.td__/" | %gawk% -- "{ print $1 > $1}"
  del /q %ENTI%.awk
  if NOT isdir %TESTDLLDIR%\sui .AND. exist *.td__ mkdir %TESTDLLDIR%\sui
endiff
del /q %tc_nonfdummy
endiff

cdd %tc_gendir%
@echo Compiling testcases
set tc_error_occurred=0
FOR %tcase IN (%TDSDIR%\%ENTI%\*.tds) do (
  if %tc_error_occurred == 0 gosub mk_test
)
goto clean_up

:mk_test
set tcname=%@NAME[%tcase]
iff %tc_range_supplied% == 1 then
  set tc_ords=%@SUBSTR[%tcname,%@LEN[%tc_bnam%]]
  set tc_namparam=%tc_bnam%%tc_ords%
  iff %tc_ords% GE %tc_firsttc% .AND. %tc_ords% LE %tc_lasttc% then
    set tc_inrange=1
  else
    set tc_inrange=0
  endiff
else
  set tc_namparam=%tcname%
  set tc_inrange=1
endiff
iff %tc_inrange% == 1 then
  iff EXIST %TDSDIR%\%ENTI%\%tcname%.td__ then
    set OUTDLL=%TESTDLLDIR%/sui/%tcname%.dll
  elseiff NOT EXIST %TDSDIR%\%ENTI%\%tcname%.td_ then
    set OUTDLL=%TESTDLLDIR%/%tcname%.dll
  else
    set OUTDLL=
  endiff
  iff "x%OUTDLL" != "x" then
    %gnumake% -f testdll.mk OUTDLL=%OUTDLL% TSTDOCNAM=%ENTI% TC_NAME=%tc_namparam% %TSTDLLCONF% TC_FURTHERINCLUDES="%tc_furtherincludes" TC_TESTLANGUAGE=%tc_testlanguage% all >%tcerr%
    iff %tc_cons_output% == 1 then
      if %? != 0 set tc_error_occurred=1
      type %tcerr%
    else
      iff %? == 0 then
        echo %@NAME[%tcase] done.
      else echo Error (%tcname%): See %tcerr & set tc_error_occurred=1
    endiff
  endiff
endiff
return

:gen_suites
%grep% Suites %TSTDOCDIR%\%ENTI%.txt > nul
iff %? == 0 then
  set gensuites=%GPF%\BIN\gensuites.awk
  iff NOT EXIST %gensuites% .OR. NOT EXIST %gawk% then
    echo Warning: You need %gensuites% and %gawk% to generate suites
    return
  endiff
  %gawk% -f %gensuites% %TSTDOCDIR%\%ENTI%.txt | tee %TDSDIR%\%ENTI%\%ENTI%.sui > %TESTDLLDIR%\%ENTI%.sui
  echo Generated %TDSDIR%\%ENTI%\%ENTI%.sui
  echo ^s^s^s^s^s^sand %TESTDLLDIR%\%ENTI%.sui
else
  echo No Suites
endiff
return

:clean_up
iff %tc_error_occurred% == 0 then
  echo Generated Test Cases are in %TESTDLLDIR%
  if exist %tcerr% del /q %tcerr%
endiff

if exist %TDSDIR%\%ENTI%\*.td_ del /q %TDSDIR%\%ENTI%\*.td_
if exist %TDSDIR%\%ENTI%\*.td__ del /q %TDSDIR%\%ENTI%\*.td__
goto end


:NoDoc
@echo "%TSTDOCDIR%\%ENTI%.doc does not exist"
goto error

:NoTds
@echo "No tds-Files in %TDSDIR%\%ENTI%"
goto error

:tdsgenerr
iff %?%==2 @echo Parse error in test case document. See %TDSDIR%\%ENTI%\%ENTI%.err
iff %?%==3 @echo Error while opening file during generation of test cases 
goto error

:tapcheckerrors
@echo "tapcheck has found problems in %TSTDOCDIR%\%ENTI%.doc"
@echo "inspect %TDSDIR%\%ENTI%\%ENTI%.chk"
goto error

:still_open
@echo "%TSTDOCDIR%\%ENTI%.doc is still open"
goto error

:Need4NT
@echo "Error: 4DOS or 4NT is needed
goto error

:unknown_option
echo Unknown Option: %1

:How2Use
text
MkAllTc : Create test cases
Usage   : MkAllTc [-chk] [-co] [-to] [-f] [-r [<first>]-[<last>]] [-k] [-tty] [-oe] [-oed] [-i <incdir>] [-tc <tcbase>] [-eut <entity>] [-td <testdlldir>] [-tdc] <Tdoc> [config]
Example : MkAllTc CC  -  creates all available test cases for CC (from CC.doc)
    -chk: call TDSCheck after generating TDS files
    -co : compile only - do not regenerate tds-Files from word source
    -to : generate TDS files only; don't compile test cases
    -f  : generate final test only (test, that are not preambles)
    -r  : generate range from <first> to <last>
    -k  : keep (don't delete) older testcases (useful when using -r)
    -tty: write tools output to console
    -i  : set <incdir> as additional include directory for test case compilation
    -td : set <testdlldir> as directory for the test cases
    -oe : old environment; generate test case for Tap on old frame
    -oed: same as -oe, but create test cases in a differently named directory
    -eut: same as EUT=<entity> as last parameter
		-tc : set test case base name
    -tdc: use dedicated makefile or msdev project to generate tdc test cases
  config: EUT=<entity> where the names of testdoc and entity differ
    like: MkAllTc BMIT EUT=ACI
endtext

:error
set tc_exitcode=1

:end
endlocal
popd
quit %tc_exitcode%
