@echo off
@pushd
rem ----------------------------------------------------------------------------- 
rem  Project :  
rem  Modul   :  
rem ----------------------------------------------------------------------------- 
rem  Copyright 2002 Texas Instruments Berlin, AG 
rem                 All rights reserved. 
rem 
rem                 This file is confidential and a trade secret of Texas 
rem                 Instruments Berlin, AG 
rem                 The receipt of or possession of this file does not convey 
rem                 any rights to reproduce or disclose its contents or to 
rem                 manufacture, use, or sell anything it may describe, in 
rem                 whole, or in part, without the specific written consent of 
rem                 Texas Instruments Berlin, AG. 
rem ----------------------------------------------------------------------------- 
rem |  Purpose :  
rem ----------------------------------------------------------------------------- 
setlocal

@if x%_4ver% == x goto Need4NT

set FRAME_ALL=0
@if x"%PROJECT%" != x"" unset PROJECT
@if x"%TARGET%" != x"" unset TARGET
@if x"%PLATFORM%" != x"" unset PLATFORM
@if x"%DEBUG%" != x"" unset DEBUG

@if x"%1" == x"" goto How2Use

:check_options
iff x"%1" == x"-debug" then
  echo on
  shift
  goto check_options
endiff
iff x"%1" == x"-n" then
  set MAKEFLAGS=%MAKEFLAGS%n
  shift
  goto check_options
endiff

@rem select for type
@if x"%1" == x"frame" goto frame_set
@if x"%1" == x"ccd" goto ccd_set
@if x"%1" == x"xpan" goto xpan
@if x"%1" == x"pco" goto pco
@if x"%1" == x"tap" goto tap
@if x"%1" == x"ccddata" goto ccddata

@if x%2 == x goto How2Use


rem ------ FRAME and CCD ---------------
rem ------------------------------------
:ccd_set
@rem Set project and OS name!
@if x%3 == x goto How2Use

set PROJECT=%2
set TARGET=%3
set PLATFORM=%4

@rem Set the name extension for the library!
set libext=lib
@if "x%3" == "xwin32"  set libext=dll
@if "x%3" == "xvxworks"  set libext=a
echo libext=%libext%
goto option_set

:frame_set
set TARGET=%2
set PLATFORM=%3

@rem Set the name extension for the library!
set libext=lib
@if "x%2" == "xwin32"  set libext=dll
@if "x%2" == "xvxworks"  set libext=a
echo libext=%libext%

:option_set
@rem Initialize the environment variables needed by makefiles!
set TRACE=0
set ROUTING=0
set FAX=0
set MEMSUPER=0
set DEBUG=0
set ALR=0
set PCON=0
set RUN_INT_RAM=0
set RUN_FLASH=0

@rem Parse the command line options!
for %option in (%3 %4 %5 %6 %7 %8 %9) do (
  if "%option%" == "tr" set TRACE=1
  && if "%option%" == "rt" set ROUTING=1
  && if "%option%" == "ps" set MEMSUPER=2
  && if "%option%" == "db" set DEBUG=1
  && if "%option%" == "al" set ALR=1
  && if "%option%" == "pn" set PCON=1
  && if "%option%" == "fl" set RUN_FLASH=1
  && if "%option%" == "ir" set RUN_INT_RAM=1
)

echo PROJECT=%PROJECT%
echo TARGET=%TARGET%
echo PLATFORM=%PLATFORM%
echo MEMSUPER=%MEMSUPER%
echo DEBUG=%DEBUG%
echo PCON=%PCON%
echo RUN_FLASH=%RUN_FLASH%
echo RUN_INT_RAM=%RUN_INT_RAM%

REM use clearmake if under ClearCase
REM default is gnumake:
set MAKE=gnumake
REM is clearcase installed ?
if "%CLEARCASE_PRIMARY_GROUP%" == "" goto use_gnu
REM are we using a clearcase view ?
cleartool lsview -cview >nul 2>>&1
if errorlevel 1 goto use_gnu
REM on a clearcase view: use clearmake in gnu mode:
set MAKE=clearmake -V -C gnu SHELL=%TESTDRIVE%/gpf/tools/bin/sh.exe
echo Using clearmake
goto build
:use_gnu
echo Using gnumake

:build
@rem ---- build library name -----------------------
@rem 1. The "first name" of the lib (frame, tif, misc,..)
for %option in (%3 %4 %5 %6 %7 %8 %9) do (
  if "%option%" == "frame" set TARGET_LIB=%option &&
  if "%option%" == "tif" set TARGET_LIB=%option &&
  if "%option%" == "misc" set TARGET_LIB=%option
)

:---- target operating system -------------------
@iff "%TARGET"=="vxworks" then
  set TOOL=
rem  INKEY What toolchain ? (D)IAB or (G)NU:  %%key
set key=g
  iff "%key"=="D" then
    @rem !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    @rem ToDo: This belongs to "initproj.bat" !!!
    set DIABLIB=c:/diab/4.3g
    @rem !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    set TOOL=diab
  endiff
  iff "%key"=="G" then
    set TOOL=gnu
    set CPU=PPC603
  endiff
  if "%TOOL"=="" goto How2Use
  
  @rem for the DIAB compiler TARGET means the target CPU
  set TARGET_OS=vxworks
  if not exist %DEV%\project\%PROJECT%\lib\%TARGET_OS% md /s %DEV%\project\%PROJECT%\lib\%TARGET_OS%
@endiff

@rem Use the corresponding makefile for gnumake.exe! 
@if x"%1" == x"frame" goto frame
@if x"%1" == x"ccd" goto ccd


rem ------ FRAME -------------------------
rem ------------------------------------

:frame
@if x%2 == xnuc goto nuc_frame

@if x%2 == xvxworks goto no_copt_del
@echo deleting c.opt
if exist %GPF%\frame\c.opt del %GPF%\frame\c.opt
if exist %GPF%\misc\c.opt del %GPF%\misc\c.opt
if exist %GPF%\tst\c.opt del %GPF%\tst\c.opt

:no_copt_del
@if x%3 == xframe goto frame_frame
@if x%3 == xmisc goto frame_misc
@if x%3 == xtif goto frame_tif
@if x%3 == xosx goto frame_osx
@if x%3 == xclean goto check_frame_clean
@if x%3 == xlabel goto check_frame_label
@if x%3 == xdepend goto check_frame_depend
goto frame_all

:check_frame_clean
@echo Cleaning frame ...
@if x%4 == xframe goto clean_frame_frame
@if x%4 == xmisc goto clean_frame_misc
@if x%4 == xtif goto clean_frame_tif
@if x%4 == xosx goto clean_frame_osx
goto clean_frame_all

:nuc_frame
@if x%4 == xframe goto frame_frame
@if x%4 == xmisc goto frame_misc
@if x%4 == xtif goto frame_tif
@if x%4 == xosx goto frame_osx
@if x%4 == xclean goto check_nuc_frame_clean
@if x%4 == xlabel goto check_frame_label
@if x%4 == xdepend goto check_frame_depend
goto frame_all

:check_nuc_frame_clean
@echo Cleaning frame ...
@if x%5 == xframe goto clean_frame_frame
@if x%5 == xmisc goto clean_frame_misc
@if x%5 == xtif goto clean_frame_tif
@if x%5 == xosx goto clean_frame_osx
goto clean_frame_all

:frame_all
@iff x%2 == xwin32 then
cd %GPF%\frame
echo frame.lib :
%MAKE% implib
if %? != 0 goto end
endiff
set FRAME_ALL=1

:frame_misc
cd %GPF%\misc
echo misc.%libext%:
iff "x%3" == "xvxworks" .AND. "%TOOL%" == "diab" then
  set TARGET_LIB=misc
  clearmake -C gnu -f dmakefile
@else
  %MAKE% misc.%libext%
@endiff
if %? != 0 goto end
if %FRAME_ALL% != 1 goto end

:frame_tif
cd %GPF%\TST
echo tif.%libext%:
iff "x%3" == "xvxworks" .AND. "%TOOL%" == "diab" then
  set TARGET_LIB=tif
  clearmake -C gnu -f dmakefile
@else
  %MAKE% tif.%libext%
@endiff
if %? != 0 goto end
if %FRAME_ALL% != 1 goto end

:frame_frame
cd %GPF%\FRAME
echo frame.%libext%:
iff "x%3" == "xvxworks" .AND. "%TOOL%" == "diab" then
  set TARGET_LIB=frame
  clearmake -C gnu -f dmakefile
@else
  %MAKE% frame.%libext%
@endiff
goto end

:frame_osx
cd %GPF%\FRAME\cust_os
echo osx.%libext%
%MAKE% osx.%libext%
goto end


@rem Clean frame, misc and tif!
:clean_frame_all
echo Clean frame, misc and tif!
cd %GPF%\frame
iff "x%3" == "xvxworks" .AND. "%TOOL%" == "diab" then
  set TARGET_LIB=frame
  clearmake -C gnu -f dmakefile clean
@else
  %MAKE% clean
@endiff
cd %GPF%\tst
iff "x%3" == "xvxworks" .AND. "%TOOL%" == "diab" then
  set TARGET_LIB=tif
  clearmake -C gnu -f dmakefile clean
@else
  %MAKE% clean
@endiff
cd %GPF%\misc
iff "x%3" == "xvxworks" .AND. "%TOOL%" == "diab" then
  set TARGET_LIB=misc
  clearmake -C gnu -f dmakefile clean
@else
  %MAKE% clean
@endiff
goto end

:clean_frame_frame
cd %GPF%\FRAME
echo cleaning frame.%libext%
iff "x%3" == "xvxworks" .AND. "%TOOL%" == "diab" then
  set TARGET_LIB=frame
  clearmake -C gnu -f dmakefile clean
@else
  %MAKE% clean
@endiff
goto end

:clean_frame_misc
@cd %GPF%\MISC
@echo cleaning misc.%libext%
iff "x%3" == "xvxworks" .AND. "%TOOL%" == "diab" then
  set TARGET_LIB=misc
  clearmake -C gnu -f dmakefile clean
@else
  %MAKE% clean
@endiff
goto end

:clean_frame_tif
cd %GPF%\TST
@echo cleaning tif.%libext%
iff "x%3" == "xvxworks" .AND. "%TOOL%" == "diab" then
  set TARGET_LIB=tif
  clearmake -C gnu -f dmakefile clean
@else
  %MAKE% clean
@endiff
goto end

:clean_frame_osx
cd %GPF%\FRAME\cust_os
echo cleaning osx.%libext%
%MAKE% clean
goto end


:check_frame_depend
@if x%5 == xframe goto depend_frame_frame
@if x%5 == xmisc goto depend_frame_misc
@if x%5 == xtif goto depend_frame_tif
goto depend_frame_all

:check_frame_label
@if x%6 == xframe goto label_frame_frame
@if x%6 == xmisc goto label_frame_misc
@if x%6 == xtif goto label_frame_tif
goto label_frame_all


@rem label frame, misc and tif!
:label_frame_all
@echo labling all frame-stuff 
cd %GPF%\FRAME
%MAKE% label LABEL=%5 
cd %GPF%\TST
%MAKE% label LABEL=%5
cd %GPF%\MISC
%MAKE% label LABEL=%5
goto end

:label_frame_frame
cd %GPF%\FRAME
echo labling frame.%libext%-stuff
%MAKE% label LABEL=%5 
goto end

:label_frame_misc
@cd %GPF%\MISC
@echo labeling misc.%libext%-stuff
%MAKE% label LABEL=%5 
goto end

:label_frame_tif
cd %GPF%\TST
@echo labling tif.%libext%-stuff
%MAKE% label LABEL=%5 
goto end


@rem Generate dependencies
:depend_frame_all
cd %GPF%\FRAME
echo Generating dependencies for frame
%MAKE% depend
cd %GPF%\TST
echo Generating dependencies for tif
%MAKE% depend
cd %GPF%\MISC
echo Generating dependencies for misc
%MAKE% depend
goto end

:depend_frame_frame
cd %GPF%\FRAME
echo Generating dependencies for frame
%MAKE% depend
goto end

:depend_frame_misc
cd %GPF%\MISC
echo Generating dependencies for misc
%MAKE% depend
goto end

:depend_frame_tif
cd %GPF%\TST
echo Generating dependencies for tif
%MAKE% depend
goto end

rem ------ CCD -------------------------
rem ------------------------------------
:ccd
if %MEMSUPER% == 2 set MEMSUPER=1
if "%TARGET%" == "nuc" shift
@if x%4 == xclean goto clean_ccd
@if x%4 == xdepend goto depend_ccd

cd %GPF%\CCD
@echo ccd.%libext%:
gnumake
goto end

:clean_ccd
cd %GPF%\CCD
@echo cleaning ccd.%libext% ...
gnumake clean
goto end

:depend_ccd
cd %GPF%\CCD
@echo Generating dependencies for ccd
gnumake depend
goto end

rem ------ XPAN -------------------------
rem ------------------------------------
:xpan
cd %GPF%\util\xpanel
@echo xpanel:
gnumake %2 %3 %4 %5 %6 %7 %8 %9
goto end


rem ------ PCO -------------------------
rem ------------------------------------
:pco
cd %GPF%\util\pco
@echo pco:
gnumake %2 %3 %4 %5 %6 %7 %8 %9
goto end


rem ------ TAP -------------------------
rem ------------------------------------
:tap
cd %GPF%\TAP
echo gnumake %2$
gnumake %2$
goto end

rem ------ ccddata DLL -----------------
rem ------------------------------------
:ccddata
cd %GPF%\CCD
echo gnumake -f ccddata.mk %2$
gnumake -f ccddata.mk %2$ 
goto end

rem ------ GENERAL -------------------------
rem ------------------------------------
:Need4NT
@echo "Error: 4DOS or 4NT is needed
@goto end

:How2Use
text
Usage:  

m [-n] <configuration>
-> option "-n" will only test making of the chosen configuration

<configuration>:
m frame <target> [<platform>] [clean|depend|label <labelname>] [<lib>] [db] [ps] [pn] [ir] [fl] [su] [al]"
m ccd   <project> <target> [clean] [tr] [rt] [db]
  project : gsm, gprs, g23net, tools
  target  : nuc, psos(g23net only), vxworks(g23net only), win32
  lib     : frame, misc, tif, all(=frame+misc+tif...default)
  Examples: m frame nuc arm7 frame db ps
	    m frame nuc arm7 frame db ir -> generates to lib containing internal RAM code
	    m frame nuc arm7 frame db fl -> generates to lib containing FLASH code
            m frame nuc pc all db
            m frame psos tif db ps
            m frame vxworks all db
            m frame win32 db
            m frame nuc arm7 clean db
              --> deletes *.obj and lib of frame, misc and tif 
            m ccd g23net nuc pc tr db 
            m ccd g23net nuc arm7 clean tr db 
              --> deletes *.obj and lib of CCD 
m {xpan|pco} [help|<xpan make options>|<pco make options>]
  Examples: m xpan DEBUG=1
            m xpan help
            m pco GUI=0
            m pco clean
m tap [<tap make options>]
  Examples: m tap
m ccddata [help|<ccddata make options>]
endtext

:end
rem restore MAKEFLAGS
endlocal
@popd
