#----------------------------------------------------------------------------- 
#  Project :  
#  Modul   :  
#----------------------------------------------------------------------------- 
#  Copyright 2002 Texas Instruments Berlin, AG 
#                 All rights reserved. 
# 
#                 This file is confidential and a trade secret of Texas 
#                 Instruments Berlin, AG 
#                 The receipt of or possession of this file does not convey 
#                 any rights to reproduce or disclose its contents or to 
#                 manufacture, use, or sell anything it may describe, in 
#                 whole, or in part, without the specific written consent of 
#                 Texas Instruments Berlin, AG. 
#----------------------------------------------------------------------------- 
#|  Purpose :  extract stacksize information from ARM9 asm files
#----------------------------------------------------------------------------- 
/.*FUNCTION NAME: \$/{
  if (infunc)
    printf ("end %s %d\n\n", fn, s+p);
  infunc = 1;
  s = 0;
  p = 0;
  fn = gensub(/.*\$([^ ]+) .*/, "\\1", 1, $0)
  print "proc "  fn
}

/BL *\$/{
  if (infunc)
    print " call " gensub(/.*\$([^;]+).*$/, "\\1", 1, $0)
}

/FUNCTION VENEER:/{
  if (infunc)
    printf ("end %s %d\n\n", fn, s+p);
  infunc = 0;
}

/ADD *SP, #-/{
  s = gensub(/.*-([0-9]*).*$/, "\\1", 1, $0)
}

/PUSH/{
  p0 = split($0, foo, ",")
  p += p0 * 4
}

END{
  if (infunc)
    printf ("end %s %d\n\n", fn, s+p);
}
