@echo off
@pushd
rem --------------------------------------------------------------------------- 
rem  Project :  
rem  Modul   :  
rem --------------------------------------------------------------------------- 
rem  Copyright 2002 Texas Instruments Berlin, AG 
rem                 All rights reserved. 
rem 
rem                 This file is confidential and a trade secret of Texas 
rem                 Instruments Berlin, AG 
rem                 The receipt of or possession of this file does not convey 
rem                 any rights to reproduce or disclose its contents or to 
rem                 manufacture, use, or sell anything it may describe, in 
rem                 whole, or in part, without the specific written consent of 
rem                 Texas Instruments Berlin, AG. 
rem --------------------------------------------------------------------------- 
rem  Purpose : Generate a test case.
rem --------------------------------------------------------------------------- 
@if x%_4ver% == x goto Need4NT

@rem Check %PROST
@iff x%PROST == x then
@echo Which Protocol Stack shall be tested?
@echo set the environment variable PROST to the name of the stack.
@echo e.g. set PROST=GSM or set PROST=WARP will work
@goto end
@endiff

@rem Check for gnumake
set gnumake=%GPF%\tools\bin\gnumake.exe
iff NOT exist %gnumake% then
  echo You need %gnumake% to generate test cases
  goto end
endiff

@set TC_GENTDS=0
set tc_cons_output=0
iff "x%TDSCHECK_ENABLED" == "x" then
set enable_check=0
else
set enable_check=1
endiff
set tc_furtherincludes=
set tc_testconfig=
set tc_testdlldir=
set tc_toolerror=0
set tc_testenv=new
set tc_gendir=%GPF%\util\tap\gen
set tc_testpref=

@rem Check Parameters
:check_options
@if x%1 == x goto How2Use
@iff "%1" == "-gen" then
  gosub prepare_gen
  if %tc_toolerror% == 1 goto end
  set TC_GENTDS=1
  shift 1
  goto check_options
elseiff "%1" == "-eut" then
  set tc_testconfig=EUT=%@UPPER[%2]
  shift 2
  goto check_options
elseiff "%1" == "-tty" then
  set tc_cons_output=1
  shift 1
  goto check_options
elseiff "%1" == "-oe" then
  set tc_gendir=%GPF%\tap
  set tc_testenv=old
  shift 1
  goto check_options
elseiff "%1" == "-oed" then
  set tc_gendir=%GPF%\tap
  set tc_testenv=old
  set tc_testpref=oe_
  shift 1
  goto check_options
elseiff "%1" == "-debug" then
  echo on
  shift 1
  goto check_options
elseiff "%1" == "-chk" then
  rem Generate tds files first
  set TC_GENTDS=1
  rem Call TDSCheck after generating tds files
  set enable_check=1
  shift 1
  goto check_options
elseiff "%1" == "-td" then
  if "x%2" == "x" (echo Missing testdll directory  for "-td" & goto How2Use)
  set tc_testdlldir=%2
  shift 2
  goto check_options
elseiff "%1" == "-i" then
  if "x%2" == "x" (echo Missing include directory  for "-i" & goto How2Use)
  iff "%@INSTR[0,1,%2]" == "." .OR. "%@INSTR[0,1,%2]" == "/" .OR. "%@INSTR[0,1,%2]" == "\" .OR. "%@INSTR[1,1,%2]" == ":" then
    set tc_furtherincludes=%tc_furtherincludes% -I %2
  else
    set tc_furtherincludes=%tc_furtherincludes% -I %TDSDIR%/%2
  endiff
  shift 2
  goto check_options
endiff

set grep=%GPF%\tools\bin\grep.exe
iff NOT exist %grep% then
  echo You need %grep% to generate test cases
  set tc_toolerror=1
endiff

@if %#% GT 3 goto How2Use
if "%@INSTR[0,1,%1]" == "-" goto unknown_option
@if x%2 == x goto How2Use
iff "x%3" != "x" then
  iff "x%tc_testconfig" != "x" then
    echo Warning: parameter "%3" ignored, because -eut was set
  else
    set tc_testconfig=%@UPPER[%3]
  endiff
else
  if "x%tc_testconfig" == "x" set tc_testconfig=%@UPPER[%1]
endiff

@rem Check style of second parameter (e.g. 037 or cc037)
@set ENTI=%@UPPER[%1]
@set FC2=%@INSTR[0,1,%2]
@iff %@NUMERIC[%FC2] == 1 then
set tc_bnam=%ENTI%%@UPPER[%2]
@else
set tc_bnam=%@UPPER[%2]
@endiff
set TCBASE=%TDSDIR%\%ENTI%\%tc_bnam%

@if not exist %TCBASE%.tds .AND. not exist %TSTDOCDIR%\%ENTI%.doc goto NoThing

@%TESTDRIVE%

@rem Stack-Specifics
iff "x%TCDIR%" == "x" then
  iff "%PROST" == "WARP" .OR. "%PROST%" == "g23net" then 
    set TCDIR=%BINDIR%
  else
    set TCDIR=%TESTROOT%\%SIDE%\TEST
  endiff
endiff

iff "x%tc_testdlldir" =="x" then
  iff "x%TCNOTSUBSTRUCT" == "x" then
    set TESTDLLDIR=%TCDIR%\%tc_testpref%%ENTI%_test
  else
    set TESTDLLDIR=%TCDIR%
  endiff
else
  iff "%@INSTR[0,1,%tc_testdlldir%]" == "." .OR. "%@INSTR[0,1,%tc_testdlldir%]" == "/" .OR. "%@INSTR[0,1,%tc_testdlldir%]" == "\" .OR. "%@INSTR[1,1,%tc_testdlldir%]" == ":" then
    set TESTDLLDIR=%tc_testdlldir%
  else
    set TESTDLLDIR=%TCDIR%\%tc_testdlldir%
  endiff
endiff

iff NOT exist %TESTDLLDIR% then
  echo "Creating test directory %TESTDLLDIR% ..."
  mkdir /S %TESTDLLDIR%
endiff


rem check if tds directory exists
@iff NOT exist %TDSDIR%\%ENTI% then
@echo "Creating test directory %TDSDIR%\%ENTI% ..."
@mkdir /S %TDSDIR%\%ENTI%
@endiff

rem Check for tdscheck.exe
iff %enable_check% == 1 then 
  set tdscheck=%GPF%\BIN\tdscheck.exe
  iff NOT EXIST %tdscheck% then 
    echo You need %tdscheck% to check your tds files 
    goto end
  endiff
endiff

@if %TC_GENTDS% == 1 goto remake

@if not exist %TCBASE%.tds goto NoSuchFile

@set TC_RESP=n
@iff exist %TSTDOCDIR%\%ENTI%.doc then
@iff %@FILEAGE[%TSTDOCDIR%\%ENTI%.doc] gt %@FILEAGE[%TCBASE%.tds] then
@echo Testdocument %TSTDOCDIR%\%ENTI%.doc is newer than
@echo test case %TCBASE%.tds.
@inkey /k"yn" /c Remake it?[yn] %%TC_RESP
@endiff
@endiff
@if %TC_RESP% != y goto compile

:remake
gosub prepare_gen
if %tc_toolerror% == 1 goto end
%doc2txt% %doc2txt_opts% %TSTDOCDIR%\%ENTI%.doc
rem hack for office 2000 where a blank is inserted after a backslash-newline
move /q %TSTDOCDIR%\%ENTI%.txt %TSTDOCDIR%\%ENTI%.txt_
%sed% -e "s/\\ $/\\/" %TSTDOCDIR%\%ENTI%.txt_ > %TSTDOCDIR%\%ENTI%.txt
del /q %TSTDOCDIR%\%ENTI%.txt_ > nul
rem end of hack
%tdsgen% %TCDIR% %ENTI% %TSTDOCDIR% %TDSDIR%\%ENTI%
if %tc_cons_output% == 1 type %TDSDIR%\%ENTI%\%ENTI%.err
@if errorlevel GT 0 goto tdsgenerr
@if not exist %TCBASE%.tds goto NoTc
gosub gen_suites
@iff %enable_check% == 1 then 
  call %tdscheck% %TDSDIR%\%ENTI% %ENTI%
  @if errorlevel GT 1 goto tapcheckerrors
@endiff

:compile
cd %tc_gendir%
iff %tc_testenv% == new then
%grep% SCRIPT_BEGIN %TCBASE%.tds > nul
  iff %? == 0 then
    set tc_testlanguage=TCSL 
  else
    set tc_testlanguage=TDS
  endiff
endiff
@echo Compiling and Linking Testcase %tc_bnam%
@set EQINP2=%@WORDS["=",%tc_testconfig]
@iff %EQINP2% GT 1 then
  set TSTDLLCONF="%tc_testconfig%"
@else
  set TSTDLLCONF="CONFDLL=%tc_testconfig%"
@endiff
set tc_comperror=0
%gnumake% -f testdll.mk OUTDLL=%TESTDLLDIR%/%tc_bnam%.DLL %TSTDLLCONF% TSTDOCNAM=%ENTI% TC_NAME=%tc_bnam% TC_FURTHERINCLUDES="%tc_furtherincludes" TC_TESTLANGUAGE=%tc_testlanguage% all > %TCBASE%.err
iff %tc_cons_output% == 1 then
  if %? != 0 set tc_comperror=1 
  type %TCBASE%.err
  if %tc_comperror% == 0 del /q %TCBASE%.err
else
  @iff %? == 0 then
  @echo ^sdone.
  @echo Generated Test Case %TESTDLLDIR%\%tc_bnam%.DLL
  del /q %TCBASE%.err
  @else
  @echo See %TCBASE%.err
  @endiff
@endiff

@goto end

:prepare_gen
set doc2txt=%GPF%\tools\bin\Doc2txt.exe
iff NOT exist %doc2txt% then
  echo You need %doc2txt% to generate test cases
  set tc_toolerror=1
endiff
set tdsgen=%GPF%\BIN\tdsGen.exe%
iff NOT exist %tdsgen% then
  echo You need %tdsgen% to generate test cases
  set tc_toolerror=1
endiff
set doc2txt_opts=-O -w -f wdFormatTextLineBreaks
set sed=%GPF%\tools\bin\sed.exe
iff NOT exist %sed% then
  echo You need %sed% to generate tests
  goto error
endiff
return

:gen_suites
%grep% Suites %TSTDOCDIR%\%ENTI%.txt > nul
iff %? == 0 then
  set gawk=%GPF%\tools\bin\gawk.exe
  set gensuites=%GPF%\BIN\gensuites.awk
  iff NOT EXIST %gensuites% .OR. NOT EXIST %gawk% then
    echo Warning: You need %gensuites% and %gawk% to generate suites 
    return
  endiff
  %gawk% -f %gensuites% %TSTDOCDIR%\%ENTI%.txt | tee %TDSDIR%\%ENTI%\%ENTI%.sui > %TESTDLLDIR%\%ENTI%.sui
  echo Generated %TDSDIR%\%ENTI%\%ENTI%.sui
  echo ^s^s^s^s^s^sand %TESTDLLDIR%\%ENTI%.sui
else
echo No Suites
endiff
return

:NoThing
@echo What is %ENTI%?
@echo Neither %TCBASE%.tds
@echo nor %TSTDOCDIR%\%ENTI%.doc exist!
@goto end

:NoSuchFile
@echo "%TCBASE%.tds - no such file!"
@goto end

:NoTc
@echo ...nevertheless: a test case "%TCBASE%.tds" does not exist
@goto end

:tdsgenerr
iff %?%==2 @echo Parse error in test case document. See %TDSDIR%\%ENTI%\%ENTI%.err
iff %?%==3 @echo Error while opening file during generation of test cases 
@goto end

:tapcheckerrors
@echo "tdscheck has found problems in %TSTDOCDIR%\%ENTI%.doc"
@echo "inspect %TDSDIR%\%ENTI%\%ENTI%.chk"
@goto end


:Need4NT
@echo "Error: 4DOS or 4NT is needed
@goto end

:unknown_option
echo Unknown Option: %1

:How2Use
text
MkTc    : Create a DLL containing a Test Case
Usage   : MkTc [-chk] [-gen] [-tty] [-oe] [-oed] [-i <incdir>] [-eut <entity>] [-td <testdlldir>] <Entity> <TestCase> [config]
  -chk  : Regenerate tds-Files from Word-Document, then call TDSCheck
  -gen  : Regenerate tds-Files from Word-Document
  -tty  : write tools output to console
  -i    : set <incdir> as additional include directory for test case compilation
  -td   : set <testdlldir> as directory for the test cases
  -oe   : old environment; generate test case for Tap on old frame
  -oed: same as -oe, but create test cases in a differently named directory
  -eut  : same as EUT=<entity> as last parameter
 config : EUT=<entity> where the names of testdoc and entity differ
Example : MkTc CC [CC]001
endtext

:end
@popd
