#
# verify_target_file.pl
#
# tool to check for make-like dependency
#
# format: verify_target_file.pl temp-file other-dest-file-index other-command other-parameters
#
# the intention of this command is to modify conditionally a file, as would it
# have done by make. since there is no date information, the tool uses the
# content of the file.
#
# the behaviour of this script is somehow specific:
# - it expects that other-dest-file-index decribes which parameter of 
#   other-parameters describes the file to be generated. first parameter is 
#   described with 0 etc. other-command is a perl script and will be invoked 
#   with "do".
# - it invokes other-command, but replaces the first parameter with temp-file
# - it then verifies temp-file against the expected result file (the first
#   parameter). if this file does not exist or is different to temp-file,
#   temp-file is renamed to the first parameter. otherwise (file exists and
#   its content is equal to the content of temp-file), only the temp-file is
#   removed.
# - since the file is already so special, it brings its own comparison tool,
#   that way there is no need to install anything else, that tool compares
#   text files
#
# IMPORTANT:
#   since the used rename does not rename over file system boundaries (at least
#   it is not promised), choose your temp-file accordingly
#

use strict;
#use warnings;

my $temp_file = shift;
my $other_dest_file_index = shift;
my $other_command = shift;
my $other_dest_file = $ARGV[$other_dest_file_index];

# modify command_line
$ARGV[$other_dest_file_index] = $temp_file;

my $result = do $other_command;

if ((! defined $result) && ($! || $@))
{
    die "system $other_command failed: $!\n$@";
}

if (! -e $temp_file)
{
    #something unexpected occured
    die "$temp_file should have been generated";
}

if (( ! -e $other_dest_file ) ||
    compare_files($other_dest_file, $temp_file) == 0)
{
    unlink $other_dest_file;
    rename $temp_file, $other_dest_file;
}
else
{
    unlink $temp_file;
}

sub get_contents_of_file
{
    my ($filename) = @_;

    open(FILE, "<$filename") or die "open failed: $filename";
    my @lines = <FILE>;
    my $text = join '', @lines;
    close FILE;

    $text
}

sub compare_files
{
    my ($file1, $file2) = @_;
    
    get_contents_of_file($file1) eq get_contents_of_file($file2)
}

