#!perl -w
#----------------------------------------------------------------------------- 
#  Project :  
#  Modul   :  tune_make_buildconfig.pl
#----------------------------------------------------------------------------- 
#  Copyright 2003 Texas Instruments Deutschland GmbH
#                 All rights reserved. 
# 
#                 This file is confidential and a trade secret of Texas 
#                 Instruments Deutschland GmbH
#                 The receipt of or possession of this file does not convey 
#                 any rights to reproduce or disclose its contents or to 
#                 manufacture, use, or sell anything it may describe, in 
#                 whole, or in part, without the specific written consent of 
#                 Texas Instruments Deutschland GmbH. 
#----------------------------------------------------------------------------- 
#  Purpose :  Dumps the build config in the generated BuSyB makefile
#----------------------------------------------------------------------------- 
use strict;

(@ARGV == 3)
    or die "Usage: tune_mak_buildconfig <makefile-in> <makefile-out> <buildconfig_file>";

open (IN, $ARGV[0])
    or die "ERROR: could not open file \"" . $ARGV[0] . "\" for reading ($!),";

open (OUT, ">$ARGV[1]")
    or die "ERROR: could not open file \"" . $ARGV[1] . "\" for writing ($!),";

open (XMLFILE, $ARGV[2])
    or die "ERROR: could not open file \"" . $ARGV[2] . "\" for reading ($!),";

while (<IN>)
{
    if (/^#### contents of the XML configset file \(DO NOT CHANGE THIS TEXT!\) ####$/)
    {
        print OUT "#Filename: " . $ARGV[2] . "\n";
        while (<XMLFILE>)
        {
            print OUT "#" . $_;
        }
    }
    else
    {
        print OUT $_;
    }
}

close IN;
close OUT;
close XMLFILE;
