#!perl -w

# This script modifies a BUSYB generated makefile. Once BUSYB generates variables it
# won't be needed anymore.
# It collects all *.obj *.lib ... files and writes them into variables.
use strict;

my %objects;
my %libs;
my %cs;
my %pdfs;
my %mdfs;
my $mconst;
my $rvswe;

(@ARGV == 3) || die "Usage: tune_mak <in_file> <out_file> <abc_exp_name>";

open(IN, $ARGV[0]) || die "Could not open file $ARGV[0]: $!";

while (<IN>) {
  if (/\%/) {
    # ignore lines that contain the % charater
  }
  elsif (/       (__out__.+?\.obj)\b/) {
    $objects{$1} = "";
  }
  elsif (/       (__out__.+?\.lib)\b/) {
    $libs{$1} = "";
  }
  elsif (/       (__out__.+?\.c)\b/) {
    $cs{$1} = "";
  }
  elsif (/       (__out__.+?\.pdf)\b/) {
    $pdfs{$1} = "";
  }
  elsif (/       (__out__.+?\.mdf)\b/) {
    my $doc = $1;
    # special handling for m_rrlp_asn1_msg.mdf, m_rrlp_asn1_inc.mdf
    # remove m_ to allow name deduction for TDC
    if ($doc =~ /m_(rrlp_asn1)/) {
      $mdfs{"$`$1$'"} = "";
    }
    else {
      $mdfs{$doc} = "";
    }
  }
  elsif (/       (__out__.+?mconst\.cdg)\b/) {
    $mconst = $1;
  }
  elsif (/       (__out__.+?rv_swe\.h)\b/) {
    $rvswe = $1;
  }
}


my @objects = sort(keys(%objects));
my @libs = sort(keys(%libs));
my @cs = sort(keys(%cs));
my @pdfs = sort(keys(%pdfs));
my @mdfs = sort(keys(%mdfs));

close IN;

# reopen and modify the file
open(IN, $ARGV[0])  || die "Could not open file $ARGV[0]: $!";
open(OUT, ">$ARGV[1]")  || die "Could not open file $ARGV[1]: $!";

my $i;
my $line;
my $tdcSpecial = 0;
while (defined ($line = <IN>)) {
  if (($line =~ /###BSB_OUT_MCONST/) && defined($mconst)) {
    print OUT "BSB_OUT_MCONST = $mconst\n";
  }
  elsif (($line =~ /###BSB_OUT_RVSWE/) && defined($rvswe)) {
    print OUT "BSB_OUT_RVSWE = $rvswe\n";
  }
  elsif (($line =~ /###BSB_OUT_OBJS/) && @objects > 0) {
    print OUT "BSB_OUT_OBJS = ";
    for ($i=0;$i<@objects;$i++) {
      print OUT "$objects[$i] ";
#      if ($i<(@objects-1)) {
#        print " \\";
#      }
#  print "\n";
    }
    print OUT  "\n";
   }
  elsif (($line =~ /###BSB_OUT_CS/) && @cs > 0) {
    print OUT "BSB_OUT_CS = ";
    for ($i=0;$i<@cs;$i++) {
      print OUT "$cs[$i] ";
    }
    print OUT "\n";
   }
  elsif (($line =~ /###BSB_OUT_LIBS/) && @libs > 0) {
    print OUT "BSB_OUT_LIBS = ";
    for ($i=0;$i<@libs;$i++) {
      print OUT "$libs[$i] ";
    }
    print OUT "\n";
   }
  elsif (($line =~ /###BSB_OUT_PDFS/) && @pdfs > 0) {
    print OUT "BSB_OUT_PDFS = ";
    for ($i=0;$i<@pdfs;$i++) {
      print OUT "$pdfs[$i] ";
    }
    print OUT "\n";
   }
  elsif (($line =~ /###BSB_OUT_MDFS/) && @mdfs > 0) {
    print OUT "BSB_OUT_MDFS = ";
    for ($i=0;$i<@mdfs;$i++) {
      print OUT "$mdfs[$i] ";
    }
    print OUT "\n";
   }
  # same condition as in first run - this needs a cleanup
  elsif ($line =~ s/^(__out__.+?)(rv_swe\.h):/$1$2 $1%\.cfg:/) {
    print OUT $line;
  }
  # same condition as in first run - this needs a cleanup
  elsif ($line =~ s/^(__out__.+?)(cdginc\/)(mconst\.cdg):/$1$2$3 $1$2%\.cdg $1$2%\.h $1$2%\.val $1tdcinc\/%\.cpp:/) {
    print OUT $line;
  }
  # BuSyB generates a fixed "-include abc_exports.mak" statement but we want
  # to include <makefile>.abc_exports.mak, given as 3rd parameter.
  elsif ($line =~ s/ abc_exports.mak$/ $ARGV[2]/) {
    print OUT $line;
  }
  elsif ($line =~ /^(__out__.+?)(tdclib\.lib):/) {
    $tdcSpecial = 1;
    print OUT $line;
  }
  elsif ($tdcSpecial) {
    $tdcSpecial = 1;
    if ($line =~ /(__out__.+?)p_(%.*?)(_dsc)?\.obj/ ) {
      print OUT "\$(patsubst __out__/g23m_dfile/prim/%.pdf,$&,\$(BSB_OUT_PDFS))$'";
    }
    elsif ($line =~ /(__out__.+?)m_(%.*?)(_dsc)?\.obj/ ) {
      print OUT "\$(patsubst __out__/g23m_dfile/msg/%.mdf,$&,\$(BSB_OUT_MDFS))$'";
    }
    else {
      print OUT $line;
    }
    if ($line =~ /\\$/) {
    }
    else {
      $tdcSpecial = 0;
    }
  }
  else {
    print OUT $line;
  }
}
