#!perl -w
use strict;
use File::Copy;
use File::Glob ':glob';

# define global variables
my $outCmdFile;
my $inPPFile;
my $cmdFile;
my $outDir;
my @cmdFiles;

# check command line
(@ARGV == 2) || die "To few/much parameters !\n";

$outCmdFile = $ARGV[0]; # a full filename
$inPPFile =  $ARGV[1];  # a full filename

# get the output directory from the first parameter
if ($ARGV[0] =~ /(.*)(\\|\/)/ ) {
  $outDir = $1;
  }
else {
  $outDir = ".";
}

#copy the *.pp file to it's new location
copy($inPPFile,$outDir ) || print "Could not copy $cmdFile to $outCmdFile!\n";

# find the original cmd file
@cmdFiles = bsd_glob("$outDir/*.cmd");
if (@cmdFiles != 1) {
  print "More/less than one cmd file found !\n";
  exit;
}
$cmdFile = $cmdFiles[0];

#copy (and rename) the cmd file to it's new location
copy($cmdFile,$outCmdFile ) || print "Could not copy $cmdFile to $outCmdFile!\n";






